/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class RolePermission
extends GenericBean {
    protected int id = -1;
    protected int roleId = -1;
    protected int permissionId = -1;
    protected boolean add = false;
    protected boolean view = false;
    protected boolean edit = false;
    protected boolean delete = false;

    public RolePermission() {
    }

    public RolePermission(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public RolePermission(Connection db, int thisId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM role_permission rp WHERE rp.id = ? ");
        pst.setInt(1, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.roleId == -1) {
            throw new SQLException("RolePermission record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setRoleId(int tmp) {
        this.roleId = tmp;
    }

    public void setRoleId(String tmp) {
        this.roleId = Integer.parseInt(tmp);
    }

    public void setPermissionId(int tmp) {
        this.permissionId = tmp;
    }

    public void setPermissionId(String tmp) {
        this.permissionId = Integer.parseInt(tmp);
    }

    public void setAdd(boolean tmp) {
        this.add = tmp;
    }

    public void setAdd(String tmp) {
        this.add = DatabaseUtils.parseBoolean(tmp);
    }

    public void setView(boolean tmp) {
        this.view = tmp;
    }

    public void setView(String tmp) {
        this.view = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEdit(boolean tmp) {
        this.edit = tmp;
    }

    public void setEdit(String tmp) {
        this.edit = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDelete(boolean tmp) {
        this.delete = tmp;
    }

    public void setDelete(String tmp) {
        this.delete = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public int getPermissionId() {
        return this.permissionId;
    }

    public boolean getAdd() {
        return this.add;
    }

    public boolean getView() {
        return this.view;
    }

    public boolean getEdit() {
        return this.edit;
    }

    public boolean getDelete() {
        return this.delete;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.roleId = rs.getInt("role_id");
        this.permissionId = rs.getInt("permission_id");
        this.view = rs.getBoolean("role_view");
        this.add = rs.getBoolean("role_add");
        this.edit = rs.getBoolean("role_edit");
        this.delete = rs.getBoolean("role_delete");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "role_permission_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO role_permission (" + (this.id > -1 ? "id, " : "") + "role_id, permission_id, role_view, " + "role_add, role_edit, role_delete) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?,?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.roleId);
        pst.setInt(++i, this.permissionId);
        pst.setBoolean(++i, this.view);
        pst.setBoolean(++i, this.add);
        pst.setBoolean(++i, this.edit);
        pst.setBoolean(++i, this.delete);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "role_permission_id_seq", this.id);
        return true;
    }
}

