/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.RolePermission;
import org.aspcfs.utils.DatabaseUtils;

public class RolePermissionList
extends Hashtable {
    private int roleId = -1;
    private int enabledState = 1;

    public RolePermissionList() {
    }

    public RolePermissionList(Connection db, int roleId) throws SQLException {
        this.roleId = roleId;
        this.buildCombinedList(db);
    }

    public RolePermissionList(HttpServletRequest request) {
        int i = 0;
        while (request.getParameter("permission" + ++i + "id") != null) {
            Permission thisPermission = new Permission();
            thisPermission.buildRecord(request, i);
            this.put("permission" + i, thisPermission);
        }
    }

    public void setEnabledState(int tmp) {
        this.enabledState = tmp;
    }

    public int getEnabledState() {
        return this.enabledState;
    }

    public void buildCombinedList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT p.*, c.category, role_add, role_view, role_edit, role_delete FROM permission p, permission_category c, role_permission r WHERE p.category_id = c.category_id AND p.permission_id = r.permission_id ");
        sqlOrder.append("ORDER BY r.role_id, c." + DatabaseUtils.addQuotes(db, "level") + ", p." + DatabaseUtils.addQuotes(db, "level") + " ");
        this.createFilter(sqlFilter);
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Permission thisPermission = new Permission(rs);
            thisPermission.setView(rs.getBoolean("role_view"));
            thisPermission.setAdd(rs.getBoolean("role_add"));
            thisPermission.setEdit(rs.getBoolean("role_edit"));
            thisPermission.setDelete(rs.getBoolean("role_delete"));
            this.put(thisPermission.getName(), thisPermission);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabledState != -1) {
            sqlFilter.append("AND p.enabled = ? ");
            sqlFilter.append("AND c.enabled = ? ");
        }
        if (this.roleId > -1) {
            sqlFilter.append("AND r.role_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabledState != -1) {
            pst.setBoolean(++i, this.enabledState == 1);
            pst.setBoolean(++i, this.enabledState == 1);
        }
        if (this.roleId > -1) {
            pst.setInt(++i, this.roleId);
        }
        return i;
    }

    public boolean hasPermission(String thisName, String thisType) {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Permission thisPermission = (Permission)((Object)this.get((String)i.next()));
            if ("add".equals(thisType) && thisName.equals(thisPermission.getName()) && thisPermission.getAdd()) {
                return true;
            }
            if ("view".equals(thisType) && thisName.equals(thisPermission.getName()) && thisPermission.getView()) {
                return true;
            }
            if ("edit".equals(thisType) && thisName.equals(thisPermission.getName()) && thisPermission.getEdit()) {
                return true;
            }
            if (!"delete".equals(thisType) || !thisName.equals(thisPermission.getName()) || !thisPermission.getDelete()) continue;
            return true;
        }
        return false;
    }

    public static ArrayList recordList(Connection db) throws SQLException {
        ArrayList<RolePermission> records = new ArrayList<RolePermission>();
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("SELECT * FROM role_permission r WHERE r.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString());
        rs = pst.executeQuery();
        while (rs.next()) {
            RolePermission permission = new RolePermission(rs);
            records.add(permission);
        }
        rs.close();
        pst.close();
        return records;
    }
}

