/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class SICCode {
    private int code = -1;
    private String description = null;
    private int level = -1;
    protected boolean enabled = true;
    protected boolean defaultItem = false;
    private String constantId = null;

    public String getConstantId() {
        return this.constantId;
    }

    public int getId() {
        return this.code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isDefaultItem() {
        return this.defaultItem;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getLevel() {
        return this.level;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setDefaultItem(boolean defaultItem) {
        this.defaultItem = defaultItem;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setConstantId(String constantId) {
        this.constantId = constantId;
    }

    public SICCode() {
    }

    public SICCode(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public SICCode(Connection db, int code) throws SQLException {
        this.queryRecord(db, code);
    }

    public void build(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public boolean update(Connection db) throws SQLException {
        return this.insert(db);
    }

    public boolean insert(Connection db) throws SQLException {
        int id = DatabaseUtils.getNextSeq(db, "lookup_sic_codes");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO lookup_sic_codes (" + (id > -1 ? "code, " : "") + "description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, constant_id) " + "VALUES (" + (id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        if (id > -1) {
            pst.setInt(++i, id);
        }
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getDefaultItem());
        pst.setInt(++i, this.getLevel());
        pst.setBoolean(++i, this.isEnabled());
        pst.setString(++i, this.getConstantId());
        pst.execute();
        pst.close();
        this.code = DatabaseUtils.getCurrVal(db, "lookup_sic_codes_code_seq", id);
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.code = rs.getInt("code");
        this.description = rs.getString("description");
        this.defaultItem = rs.getBoolean("default_item");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        this.constantId = rs.getString("constant_id");
        if (!this.isEnabled()) {
            this.description = this.description + " (X)";
        }
    }

    public void queryRecord(Connection db, int tmpCode) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SICCode-> Retrieving ID: " + tmpCode + " from lookup_sic_codes ");
        }
        this.setCode(tmpCode);
        PreparedStatement pst = db.prepareStatement("SELECT code, description, default_item, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, constant_id " + "FROM lookup_sic_codes " + "WHERE code = ? ");
        pst.setInt(1, this.getCode());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.build(rs);
        }
        rs.close();
        pst.close();
        if (this.code < 0) {
            throw new SQLException("ID not found");
        }
    }
}

