/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.admin.base.SICCode;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class SICCodeList
extends ArrayList {
    private static final long serialVersionUID = 322620745210514895L;
    public String tableName = "lookup_sic_codes";
    protected HashMap selectedItems = null;
    private String constantId = null;
    private boolean enabled = true;

    public SICCodeList() {
    }

    public SICCodeList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void addItem(int tmp1, String tmp2) {
        if (!this.exists(tmp1)) {
            SICCode thisElement = new SICCode();
            thisElement.setCode(tmp1);
            thisElement.setDescription(tmp2);
            if (this.size() > 0) {
                this.add(0, thisElement);
            } else {
                this.add(thisElement);
            }
        }
    }

    public boolean exists(int tmp1) {
        for (SICCode thisElement : this) {
            if (thisElement.getCode() != tmp1) continue;
            return true;
        }
        return false;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("SELECT sict.* FROM " + DatabaseUtils.getTableName(db, this.tableName) + " sict " + "WHERE code > -1 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ",description ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            SICCode thisType = new SICCode(rs);
            this.add(thisType);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.constantId != null) {
            sqlFilter.append("AND constant_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.constantId != null) {
            pst.setString(++i, this.constantId);
        }
        return i;
    }

    public int getIdFromConstantId(String constantId) {
        for (SICCode thisElement : this) {
            if (!thisElement.getConstantId().equals(constantId)) continue;
            return thisElement.getId();
        }
        return -1;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        return this.getHtmlSelect(selectName, defaultKey, false);
    }

    public String getHtmlSelect(String selectName, int defaultKey, boolean disabled) {
        HtmlSelect thisSelect = new HtmlSelect();
        thisSelect.setDisabled(disabled);
        Iterator i = this.iterator();
        boolean keyFound = false;
        int lookupDefault = defaultKey;
        while (i.hasNext()) {
            SICCode thisElement = (SICCode)i.next();
            if (thisElement.getEnabled()) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
                if (thisElement.getDefaultItem()) {
                    lookupDefault = thisElement.getCode();
                }
            } else if (thisElement.getCode() == defaultKey) {
                thisSelect.addItem(thisElement.getCode(), thisElement.getDescription());
            }
            if (thisElement.getCode() != defaultKey) continue;
            keyFound = true;
        }
        if (keyFound) {
            return thisSelect.getHtml(selectName, defaultKey);
        }
        return thisSelect.getHtml(selectName, lookupDefault);
    }

    public String getDescriptionByCode(int code) {
        for (SICCode thisElement : this) {
            if (thisElement.getCode() != code) continue;
            return thisElement.getDescription();
        }
        return null;
    }
}

