/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.admin.base.Usage;
import org.aspcfs.utils.DatabaseUtils;

public class UsageList
extends ArrayList {
    public static final String tableName = "usage_log";
    public static final String uniqueField = "usage_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int action = -1;
    private Timestamp enteredRangeStart = null;
    private Timestamp enteredRangeEnd = null;
    private long count = -1L;
    private long size = -1L;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setAction(int tmp) {
        this.action = tmp;
    }

    public void setAction(String tmp) {
        this.action = Integer.parseInt(tmp);
    }

    public void setEnteredRangeStart(Timestamp tmp) {
        this.enteredRangeStart = tmp;
    }

    public void setEnteredRangeStart(String tmp) {
        this.enteredRangeStart = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredRangeEnd(Timestamp tmp) {
        this.enteredRangeEnd = tmp;
    }

    public void setEnteredRangeEnd(String tmp) {
        this.enteredRangeEnd = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setCount(long tmp) {
        this.count = tmp;
    }

    public void setSize(long tmp) {
        this.size = tmp;
    }

    public int getAction() {
        return this.action;
    }

    public Timestamp getEnteredRangeStart() {
        return this.enteredRangeStart;
    }

    public Timestamp getEnteredRangeEnd() {
        return this.enteredRangeEnd;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT count(*) AS recordcount FROM usage_log ul ");
        this.createFilter(db, sqlFilter);
        sqlOrder.append("ORDER BY ul.usage_id ");
        sqlSelect.append(" SELECT ");
        sqlSelect.append("* FROM usage_log ul WHERE ul.usage_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Usage usage = new Usage(rs);
            this.add(usage);
        }
        rs.close();
        pst.close();
    }

    public void buildUsage(Connection db) throws SQLException {
        StringBuffer sqlFilter = new StringBuffer();
        String sqlCount = "SELECT COUNT(*) AS recordcount, SUM(record_size) AS recordsize FROM usage_log u WHERE u.usage_id > -1 ";
        this.createFilter(db, sqlFilter);
        PreparedStatement pst = db.prepareStatement(sqlCount + sqlFilter.toString());
        int items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.count = DatabaseUtils.getInt(rs, "recordcount", 0);
            this.size = DatabaseUtils.getInt(rs, "recordsize", 0);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.action > -1) {
            sqlFilter.append("AND " + DatabaseUtils.addQuotes(db, "action") + " = ? ");
        }
        if (this.enteredRangeStart != null) {
            sqlFilter.append("AND entered >= ? ");
        }
        if (this.enteredRangeEnd != null) {
            sqlFilter.append("AND entered <= ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.action > -1) {
            pst.setInt(++i, this.action);
        }
        if (this.enteredRangeStart != null) {
            pst.setTimestamp(++i, this.enteredRangeStart);
        }
        if (this.enteredRangeEnd != null) {
            pst.setTimestamp(++i, this.enteredRangeEnd);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

