/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.AccessLog;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.GraphSummaryList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.PasswordHash;
import org.aspcfs.utils.StringUtils;

public class User
extends GenericBean {
    protected String errmsg = "";
    protected int id = -1;
    protected String username = null;
    protected String encryptedPassword = null;
    protected String password = null;
    protected String password1 = null;
    protected String password2 = null;
    protected String webdavPassword = null;
    protected int contactId = -1;
    protected int roleId = -1;
    protected String role = null;
    private int roleType = -1;
    protected int managerId = -1;
    protected User managerUser = null;
    protected String ip = null;
    protected String timeZone = null;
    private String currency = null;
    private String language = null;
    private Locale locale = null;
    protected int startOfDay = -1;
    protected int endOfDay = -1;
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected boolean enabled = true;
    protected boolean hasWebdavAccess = false;
    protected boolean hasHttpApiAccess = false;
    private int siteId = -1;
    private String siteIdName = null;
    protected Timestamp entered = null;
    protected Timestamp modified = null;
    protected Timestamp lastLogin = null;
    protected Timestamp expires = null;
    protected String previousUsername = null;
    private int assistant = -1;
    private int alias = -1;
    protected boolean hidden = false;
    protected Contact contact = new Contact();
    protected UserList childUsers = null;
    protected boolean buildContact = false;
    protected boolean buildContactDetails = false;
    protected boolean buildHierarchy = false;
    protected boolean hideHiddenChildren = false;
    private boolean managerUserEnabled = true;
    protected boolean opportunityLock = false;
    protected boolean revenueLock = false;
    protected double YTD = 0.0;
    protected double pipelineValue = 0.0;
    protected boolean pipelineValueIsValid = false;
    protected GraphSummaryList gmr = new GraphSummaryList();
    protected GraphSummaryList ramr = new GraphSummaryList();
    protected GraphSummaryList cgmr = new GraphSummaryList();
    protected GraphSummaryList cramr = new GraphSummaryList();
    protected GraphSummaryList revenue = new GraphSummaryList();
    protected boolean leadsLock = false;
    protected double leadsNumber = 0.0;
    protected boolean leadsNumberIsValid = false;
    protected GraphSummaryList lccr = new GraphSummaryList();
    protected boolean addContact = true;

    public User() {
    }

    public User(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public User(Connection db, String userId) throws SQLException {
        this.buildRecord(db, Integer.parseInt(userId));
    }

    public User(Connection db, String userId, boolean doHierarchy) throws SQLException {
        this.buildHierarchy = doHierarchy;
        this.buildRecord(db, Integer.parseInt(userId));
    }

    public User(Connection db, int userId) throws SQLException {
        this.buildRecord(db, userId);
    }

    public boolean getAddContact() {
        return this.addContact;
    }

    public void setAddContact(boolean tmp) {
        this.addContact = tmp;
    }

    public void setAddContact(String tmp) {
        this.addContact = DatabaseUtils.parseBoolean(tmp);
    }

    public void setWebdavPassword(String tmp) {
        this.webdavPassword = tmp;
    }

    public String getWebdavPassword() {
        return this.webdavPassword;
    }

    public GraphSummaryList getRevenue() {
        return this.revenue;
    }

    public boolean getHasWebdavAccess() {
        return this.hasWebdavAccess;
    }

    public void setHasWebdavAccess(boolean tmp) {
        this.hasWebdavAccess = tmp;
    }

    public void setHasWebdavAccess(String tmp) {
        this.hasWebdavAccess = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHasHttpApiAccess() {
        return this.hasHttpApiAccess;
    }

    public void setHasHttpApiAccess(boolean tmp) {
        this.hasHttpApiAccess = tmp;
    }

    public void setHasHttpApiAccess(String tmp) {
        this.hasHttpApiAccess = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRevenue(GraphSummaryList revenue) {
        this.revenue = revenue;
    }

    public double getYTD() {
        return this.YTD;
    }

    public void setYTD(double YTD) {
        this.YTD = YTD;
    }

    public String getYTDValue() {
        double value_2dp = (double)Math.round(this.YTD * 100.0) / 100.0;
        String toReturn = String.valueOf(value_2dp);
        if (toReturn.endsWith(".0")) {
            toReturn = toReturn.substring(0, toReturn.length() - 2);
        }
        if (Integer.parseInt(toReturn) == 0) {
            toReturn = "";
        }
        return toReturn;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean tmp) {
        this.hidden = tmp;
    }

    public void setHidden(String tmp) {
        this.hidden = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHideHiddenChildren() {
        return this.hideHiddenChildren;
    }

    public void setHideHiddenChildren(boolean tmp) {
        this.hideHiddenChildren = tmp;
    }

    public void setHideHiddenChildren(String tmp) {
        this.hideHiddenChildren = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getLeadsLock() {
        return this.leadsLock;
    }

    public void setLeadsLock(boolean tmp) {
        this.leadsLock = tmp;
    }

    public void setLeadsLock(String tmp) {
        this.leadsLock = DatabaseUtils.parseBoolean(tmp);
    }

    public double getLeadsNumber() {
        return this.leadsNumber;
    }

    public void setLeadsNumber(double tmp) {
        this.leadsNumber = tmp;
    }

    public void setLeadsNumber(String tmp) {
        this.leadsNumber = Double.parseDouble(tmp);
    }

    public boolean getLeadsNumberIsValid() {
        return this.leadsNumberIsValid;
    }

    public void setLeadsNumberIsValid(boolean tmp) {
        this.leadsNumberIsValid = tmp;
    }

    public void setLeadsNumberIsValid(String tmp) {
        this.leadsNumberIsValid = DatabaseUtils.parseBoolean(tmp);
    }

    public GraphSummaryList getLccr() {
        return this.lccr;
    }

    public void setLccr(GraphSummaryList tmp) {
        this.lccr = tmp;
    }

    public void setGraphValuesLeads(String key, Double value) {
        this.getLccr().setValue(key, value);
    }

    public boolean getIsValidLead() {
        return this.lccr.getIsValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLeadsLock() {
        while (this.leadsLock) {
        }
        User user = this;
        synchronized (user) {
            while (this.leadsLock) {
            }
            this.leadsLock = true;
        }
    }

    public void doLeadsUnlock() {
        this.leadsLock = false;
    }

    public void setIsValidLead(boolean isValid, boolean dataAlso) {
        if (dataAlso) {
            this.lccr.setIsValid(isValid);
        }
        if (!isValid) {
            this.lccr.setLastFileName(null);
        }
        if (this.managerUser != null) {
            this.managerUser.setIsValidLead(false, false);
        }
    }

    public User(Connection db, int userId, boolean doHierarchy) throws SQLException {
        this.buildHierarchy = doHierarchy;
        this.buildRecord(db, userId);
    }

    public void setExpires(Timestamp expires) {
        this.expires = expires;
        this.checkHidden();
    }

    public void setExpires(String tmp) {
        this.expires = DatabaseUtils.parseDateToTimestamp(tmp);
        this.checkHidden();
    }

    public String generateRandomPassword(Connection db) throws SQLException {
        int resultCount = -1;
        String newPassword = String.valueOf(StringUtils.rand(100000, 999999));
        this.setPassword1(newPassword);
        this.setPassword2(newPassword);
        resultCount = this.newPassword(db);
        return newPassword;
    }

    public void setAssistant(int tmp) {
        this.assistant = tmp;
    }

    public UserList getChildUsers() {
        return this.childUsers;
    }

    public void setAssistant(String tmp) {
        this.assistant = Integer.parseInt(tmp);
    }

    public void setAlias(int tmp) {
        this.alias = tmp;
    }

    public void setAlias(String tmp) {
        this.alias = Integer.parseInt(tmp);
    }

    public void setGmr(GraphSummaryList tmp) {
        this.gmr = tmp;
    }

    public void setManagerUserEnabled(boolean managerUserEnabled) {
        this.managerUserEnabled = managerUserEnabled;
    }

    public boolean getManagerUserEnabled() {
        return this.managerUserEnabled;
    }

    public boolean getRevenueLock() {
        return this.revenueLock;
    }

    public void setRevenueLock(boolean revenueLock) {
        this.revenueLock = revenueLock;
    }

    public void setRamr(GraphSummaryList tmp) {
        this.ramr = tmp;
    }

    public boolean getPipelineValueIsValid() {
        return this.pipelineValueIsValid;
    }

    public void setPipelineValueIsValid(boolean pipelineValueIsValid) {
        this.pipelineValueIsValid = pipelineValueIsValid;
    }

    public void setIsValid(boolean isValid, boolean dataAlso) {
        if (dataAlso) {
            this.gmr.setIsValid(isValid);
            this.ramr.setIsValid(isValid);
            this.cgmr.setIsValid(isValid);
            this.cramr.setIsValid(isValid);
        }
        if (!isValid) {
            this.gmr.setLastFileName(null);
            this.ramr.setLastFileName(null);
            this.cgmr.setLastFileName(null);
            this.cramr.setLastFileName(null);
        }
        if (this.managerUser != null) {
            this.managerUser.setIsValid(false, false);
        }
    }

    public void setRevenueIsValid(boolean isValid, boolean dataAlso) {
        if (dataAlso) {
            this.revenue.setIsValid(isValid);
        }
        if (!isValid) {
            this.revenue.setLastFileName(null);
        }
        if (this.managerUser != null) {
            this.managerUser.setRevenueIsValid(false, false);
        }
    }

    public void setGraphValues(String key, Double v1, Double v2, Double v3, Double v4) {
        this.getGmr().setValue(key, v1);
        this.getRamr().setValue(key, v2);
        this.getCgmr().setValue(key, v3);
        this.getCramr().setValue(key, v4);
    }

    public void setRevenueGraphValues(String key, Double v1) {
        this.getRevenue().setValue(key, v1);
    }

    public void setCgmr(GraphSummaryList tmp) {
        this.cgmr = tmp;
    }

    public void setCramr(GraphSummaryList tmp) {
        this.cramr = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setUsername(String tmp) {
        this.username = tmp;
    }

    public void setPreviousUsername(String tmp) {
        this.previousUsername = tmp;
    }

    public void setEncryptedPassword(String tmp) {
        this.encryptedPassword = tmp;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public void setPassword1(String tmp) {
        this.password1 = tmp;
    }

    public void setPassword2(String tmp) {
        this.password2 = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
        this.contact.setId(tmp);
    }

    public void setContactId(String tmp) {
        if (tmp != null) {
            this.setContactId(Integer.parseInt(tmp));
        }
    }

    public void setRoleId(int tmp) {
        this.roleId = tmp;
    }

    public boolean reassign(Connection db, int newManager) throws SQLException {
        int result = -1;
        this.setManagerId(newManager);
        result = this.update(db);
        return result != -1;
    }

    public void setRoleId(String tmp) {
        if (tmp != null) {
            this.roleId = Integer.parseInt(tmp);
        }
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setPipelineValue(double pipelineValue) {
        this.pipelineValue = pipelineValue;
    }

    public double getPipelineValue() {
        return this.pipelineValue;
    }

    public void setRole(String tmp) {
        this.role = tmp;
    }

    public void setManagerId(int tmp) {
        this.managerId = tmp;
    }

    public void setManagerId(String tmp) {
        if (tmp != null) {
            this.managerId = Integer.parseInt(tmp);
        }
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        if (tmp != null) {
            this.enteredBy = Integer.parseInt(tmp);
        }
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
        this.checkHidden();
    }

    public void setEnabled(String tmp) {
        this.enabled = !tmp.toLowerCase().equals("false");
        this.checkHidden();
    }

    public void setLastLogin(Timestamp tmp) {
        this.lastLogin = tmp;
    }

    public void setLastLogin(String tmp) {
        this.lastLogin = DateUtils.parseTimestampString(tmp);
    }

    public void setIp(String tmp) {
        this.ip = tmp;
    }

    public void setTimeZone(String tmp) {
        this.timeZone = tmp;
    }

    public void setBuildContact(boolean tmp) {
        this.buildContact = tmp;
    }

    public void setBuildContactDetails(boolean tmp) {
        this.buildContactDetails = tmp;
    }

    public void setBuildHierarchy(boolean tmp) {
        this.buildHierarchy = tmp;
    }

    public void setContact(Contact tmp) {
        this.contact = tmp;
    }

    public void setManagerUser(User tmp) {
        this.managerUser = tmp;
    }

    public void setChildUsers(UserList tmp) {
        this.childUsers = tmp;
    }

    public void setRoleType(int tmp) {
        this.roleType = tmp;
    }

    public void setRoleType(String tmp) {
        this.roleType = Integer.parseInt(tmp);
    }

    public Timestamp getExpires() {
        return this.expires;
    }

    public String getExpiresString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.expires);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getLastLogin() {
        return this.lastLogin;
    }

    public String getLastLoginString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.lastLogin);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getAssistant() {
        return this.assistant;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public String getSiteIdName() {
        return this.siteIdName;
    }

    public int getAlias() {
        return this.alias;
    }

    public boolean getIsValid() {
        return this.gmr.getIsValid() && this.ramr.getIsValid() && this.cgmr.getIsValid() && this.cramr.getIsValid();
    }

    public boolean getRevenueIsValid() {
        return this.revenue.getIsValid();
    }

    public GraphSummaryList getGmr() {
        return this.gmr;
    }

    public GraphSummaryList getRamr() {
        return this.ramr;
    }

    public GraphSummaryList getCgmr() {
        return this.cgmr;
    }

    public GraphSummaryList getCramr() {
        return this.cramr;
    }

    public int getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPreviousUsername() {
        return this.previousUsername;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEncryptedPassword() {
        if (this.encryptedPassword != null) {
            return this.encryptedPassword;
        }
        return this.encryptPassword(this.password);
    }

    public String getPassword1() {
        return this.password1;
    }

    public String getPassword2() {
        return this.password2;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public int getManagerId() {
        return this.managerId;
    }

    public String getRole() {
        return this.role;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public String getIp() {
        return this.ip;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public TimeZone getTimeZoneActual() {
        TimeZone tZone = Calendar.getInstance().getTimeZone();
        if (this.timeZone != null && !"".equals(this.timeZone)) {
            tZone = TimeZone.getTimeZone(this.timeZone);
        }
        return tZone;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String tmp) {
        this.currency = tmp;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String tmp) {
        this.language = tmp;
        if (this.language == null) {
            this.locale = Locale.getDefault();
        } else {
            switch (this.language.length()) {
                case 2: {
                    this.locale = new Locale(this.language.substring(0, 2), "");
                    break;
                }
                case 5: {
                    this.locale = new Locale(this.language.substring(0, 2), this.language.substring(3, 5));
                    break;
                }
                case 10: {
                    this.locale = new Locale(this.language.substring(0, 2), this.language.substring(3, 5), this.language.substring(6));
                    break;
                }
                default: {
                    this.locale = Locale.getDefault();
                }
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale tmp) {
        this.locale = tmp;
    }

    public UserList getFullChildList(UserList inList, UserList currentList) {
        if (inList != null) {
            for (User thisRec : inList) {
                thisRec.setHideHiddenChildren(this.getHideHiddenChildren());
                currentList.addElement(thisRec);
                UserList countList = thisRec.getShortChildList();
                if (countList == null || countList.getListSize() <= 0) continue;
                currentList = thisRec.getFullChildList(countList, currentList);
            }
        }
        return currentList;
    }

    public UserList getShortChildList() {
        return this.childUsers;
    }

    public User getChild(int childId) {
        UserList shortChildList = this.getShortChildList();
        if (shortChildList != null) {
            UserList fullChildList = this.getFullChildList(shortChildList, new UserList());
            for (User childRecord : fullChildList) {
                if (childRecord.getId() != childId) continue;
                return childRecord;
            }
        }
        return null;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Contact getContact() {
        return this.contact;
    }

    public User getManagerUser() {
        return this.managerUser;
    }

    public int getRoleType() {
        return this.roleType;
    }

    public boolean isManagerOf(int userId) {
        return this.getChild(userId) != null;
    }

    public boolean isPortalUser() {
        return this.roleType > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOpportunityLock() {
        while (this.opportunityLock) {
        }
        User user = this;
        synchronized (user) {
            while (this.opportunityLock) {
            }
            this.opportunityLock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRevenueLock() {
        while (this.revenueLock) {
        }
        User user = this;
        synchronized (user) {
            while (this.revenueLock) {
            }
            this.revenueLock = true;
        }
    }

    public void doOpportunityUnlock() {
        this.opportunityLock = false;
    }

    public void doRevenueUnlock() {
        this.revenueLock = false;
    }

    public int updatePassword(Connection db, ActionContext context, String currPass) throws SQLException {
        if (!this.isValidChangePass(context, currPass)) {
            return -1;
        }
        int resultCount = -1;
        if (this.getId() == -1) {
            throw new SQLException("User ID was not specified");
        }
        this.checkHidden();
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET " + DatabaseUtils.addQuotes(db, "password") + " = ?, webdav_password = ?, hidden = ? " + "WHERE user_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.encryptPassword(this.password1));
        pst.setString(++i, this.encryptWebdavPassword(this.username, this.password1));
        pst.setBoolean(++i, this.getHidden());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public void checkWebdavAccess(Connection db, String pwd) throws SQLException {
        String tmpPwd = this.encryptWebdavPassword(this.username, pwd);
        if (!tmpPwd.equals(this.webdavPassword)) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("User-> Generating a new webdav password");
            }
            if (this.getId() == -1) {
                throw new SQLException("User ID was not specified");
            }
            this.checkHidden();
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET webdav_password = ?, hidden = ? " + "WHERE user_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            pst.setString(++i, tmpPwd);
            pst.setBoolean(++i, this.getHidden());
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            this.setWebdavPassword(tmpPwd);
            pst.close();
        }
    }

    public int select(Connection db) throws SQLException {
        this.buildRecord(db, this.id);
        if (this.expires != null && new Date().after(this.expires)) {
            return -1;
        }
        if (this.alias > 0) {
            return this.alias;
        }
        return this.id;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("User-> Beginning insert");
            }
            if (this.contactId < 1 && this.addContact) {
                Contact newContact = this.getContact();
                newContact.setEnteredBy(this.enteredBy);
                newContact.setModifiedBy(this.modifiedBy);
                newContact.setOwner(this.enteredBy);
                newContact.insert(db);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("User-> Inserting new Contact");
                }
                this.contactId = newContact.getId();
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("User-> New Contact ID: " + newContact.getId());
                }
            }
            this.checkHidden();
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "access_user_id_seq");
            sql.append("INSERT INTO " + DatabaseUtils.addQuotes(db, "access") + " " + "(username, " + DatabaseUtils.addQuotes(db, "password") + ", contact_id, alias, " + "manager_id, role_id, expires, ");
            if (this.id > -1) {
                sql.append("user_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            if (this.lastLogin != null) {
                sql.append("last_login, ");
            }
            sql.append("site_id, ");
            if (this.timeZone != null) {
                sql.append("timezone, ");
            }
            if (this.currency != null) {
                sql.append("currency, ");
            }
            if (this.language != null) {
                sql.append("" + DatabaseUtils.addQuotes(db, "language") + ", ");
            }
            sql.append("enteredBy, modifiedBy, webdav_password, hidden, allow_webdav_access, allow_httpapi_access ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            if (this.lastLogin != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.timeZone != null) {
                sql.append("?, ");
            }
            if (this.currency != null) {
                sql.append("?, ");
            }
            if (this.language != null) {
                sql.append("?, ");
            }
            sql.append("?, ?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getUsername());
            if (this.encryptedPassword != null) {
                pst.setString(++i, this.encryptedPassword);
            } else {
                pst.setString(++i, this.encryptPassword(this.password1));
            }
            pst.setInt(++i, this.contact.getId());
            pst.setInt(++i, this.getAlias());
            if (this.getAlias() > -1) {
                DatabaseUtils.setInt(pst, ++i, -1);
            } else {
                pst.setInt(++i, this.getManagerId());
            }
            pst.setInt(++i, this.getRoleId());
            DatabaseUtils.setTimestamp(pst, ++i, this.getExpires());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            if (this.lastLogin != null) {
                pst.setTimestamp(++i, this.lastLogin);
            }
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            if (this.timeZone != null) {
                pst.setString(++i, this.timeZone);
            }
            if (this.currency != null) {
                pst.setString(++i, this.currency);
            }
            if (this.language != null) {
                pst.setString(++i, this.language);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.encryptWebdavPassword(this.username, this.password1));
            pst.setBoolean(++i, this.getHidden());
            pst.setBoolean(++i, this.getHasWebdavAccess());
            pst.setBoolean(++i, this.getHasHttpApiAccess());
            pst.execute();
            pst.close();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("User-> Getting interval value");
            }
            this.id = DatabaseUtils.getCurrVal(db, "access_user_id_seq", this.id);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("User-> Updating contact");
            }
            pst = db.prepareStatement("UPDATE contact SET user_id = ? WHERE contact_id = ? ");
            pst.setInt(1, this.id);
            pst.setInt(2, this.contact.getId());
            pst.executeUpdate();
            pst.close();
            if (doCommit) {
                db.commit();
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("User-> User inserted & contact record updated");
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int updatePortalUser(Connection db) throws SQLException {
        int updated = -1;
        if (this.hasErrors()) {
            return updated;
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("User-> Beginning update");
        }
        this.checkHidden();
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET expires = ?, ");
        if (this.password1 != null) {
            sql.append("" + DatabaseUtils.addQuotes(db, "password") + " = ?,");
        }
        sql.append("role_id = ?, hidden = ?, modifiedBy = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " " + "WHERE username = ? " + "AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setTimestamp(++i, this.expires);
        if (this.password1 != null) {
            pst.setString(++i, this.encryptPassword(this.password1));
        }
        pst.setInt(++i, this.roleId);
        pst.setBoolean(++i, this.getHidden());
        pst.setInt(++i, this.modifiedBy);
        pst.setString(++i, this.username);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        updated = pst.executeUpdate();
        pst.close();
        return updated;
    }

    public boolean insert(Connection db, ActionContext context) throws Exception {
        if (!this.isValid(db, context)) {
            return false;
        }
        return this.insert(db);
    }

    public boolean disable(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID not specified.");
        }
        this.checkHidden(false);
        int resultCount = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET enabled = ?, hidden = ? " + "WHERE user_id = ? ");
        pst.setBoolean(1, false);
        pst.setBoolean(2, this.getHidden());
        pst.setInt(3, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount != 0;
    }

    public boolean enable(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID not specified.");
        }
        this.checkHidden(true);
        int resultCount = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET enabled = ? , hidden = ? " + "WHERE user_id = ? ");
        pst.setBoolean(1, true);
        pst.setBoolean(2, this.getHidden());
        pst.setInt(3, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount != 0;
    }

    public void buildResources(Connection db) throws SQLException {
        if ((this.buildContact || this.buildHierarchy) && this.getContactId() > -1) {
            this.contact = new Contact();
            this.contact.setId(this.getContactId());
            this.contact.setBuildDetails(this.buildContactDetails);
            this.contact.setBuildTypes(this.buildContactDetails);
            this.contact.build(db);
        }
        if (this.buildHierarchy) {
            this.buildChildren(db);
        }
    }

    public void updateLogin(Connection db) throws SQLException {
        if (this.id > -1) {
            this.checkHidden();
            String sql = "UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET last_login = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "last_ip = ?, hidden = ? " + "WHERE user_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setString(1, this.ip);
            pst.setBoolean(2, this.getHidden());
            pst.setInt(3, this.id);
            pst.executeUpdate();
            pst.close();
        }
        this.insertLogRecord(db);
    }

    public void updateHttpApiAccess(Connection db, boolean access) throws SQLException {
        if (this.id > -1) {
            this.checkHidden();
            String sql = "UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET allow_httpapi_access = ?, " + "hidden = ? " + "WHERE user_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setBoolean(1, access);
            pst.setBoolean(2, this.getHidden());
            pst.setInt(3, this.id);
            pst.executeUpdate();
            pst.close();
        }
    }

    public void updateWebdavAccess(Connection db, boolean access) throws SQLException {
        if (this.id > -1) {
            this.checkHidden();
            String sql = "UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET allow_webdav_access = ?, " + "hidden = ? " + "WHERE user_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setBoolean(1, access);
            pst.setBoolean(2, this.getHidden());
            pst.setInt(3, this.id);
            pst.executeUpdate();
            pst.close();
        }
    }

    public void insertLogRecord(Connection db) throws SQLException {
        AccessLog thisLog = new AccessLog();
        thisLog.setUserId(this.getId());
        thisLog.setUsername(this.getUsername());
        thisLog.setIp(this.getIp());
        thisLog.insert(db);
    }

    public void updateSettings(Connection db) throws SQLException {
        if (this.id > -1) {
            this.checkHidden();
            String sql = "UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET timezone = ?, currency = ?, " + DatabaseUtils.addQuotes(db, "language") + " = ?, hidden = ? " + "WHERE user_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setString(1, this.timeZone);
            pst.setString(2, this.currency);
            pst.setString(3, this.language);
            pst.setBoolean(4, this.getHidden());
            pst.setInt(5, this.id);
            pst.executeUpdate();
            pst.close();
        }
    }

    public void buildRecord(Connection db, int userId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.username, a." + DatabaseUtils.addQuotes(db, "password") + ", a.role_id, a.last_login, a.manager_id, " + "a.site_id AS siteid, " + "a.last_ip, a.timezone, a.startofday AS access_startofday, " + "a.endofday AS access_endofday, a.expires, a.alias, " + "a.contact_id AS contact_id_link, a.user_id AS access_user_id, " + "a.enabled AS access_enabled, a.assistant AS access_assistant, " + "a.entered AS access_entered, a.enteredby AS access_enteredby, " + "a.modified AS access_modified, a.modifiedby AS access_modifiedby, " + "a.currency, a." + DatabaseUtils.addQuotes(db, "language") + ", a.webdav_password, a.hidden, a.allow_webdav_access, a.allow_httpapi_access, " + "r." + DatabaseUtils.addQuotes(db, "role") + " AS systemrole, r.role_type, " + "m_usr.enabled AS mgr_enabled, " + "b.description AS site_id_name, " + "c.*, o.enabled AS orgenabled, o.trashed_date AS orgtrasheddate, " + "d.description AS departmentname, ca.city AS city, ca.postalcode AS postalcode " + "FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "LEFT JOIN contact c ON (a.contact_id = c.contact_id) " + "LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) " + "LEFT JOIN organization o ON (c.org_id = o.org_id) " + "LEFT JOIN lookup_department d ON (c.department = d.code) " + "LEFT JOIN " + DatabaseUtils.addQuotes(db, "access") + " m_usr ON (a.manager_id = m_usr.user_id) " + "LEFT JOIN " + DatabaseUtils.addQuotes(db, "role") + " r ON (a.role_id = r.role_id) " + "LEFT JOIN lookup_site_id b ON (a.site_id = b.code) " + "WHERE a.user_id > -1 " + "AND (ca.address_id IS NULL OR ca.address_id IN ( " + "SELECT cta.address_id FROM contact_address cta WHERE cta.contact_id = c.contact_id AND cta.primary_address = ?) " + "OR ca.address_id IN (SELECT MIN(ctadd.address_id) FROM contact_address ctadd WHERE ctadd.contact_id = c.contact_id AND " + " ctadd.contact_id NOT IN (SELECT contact_id FROM contact_address WHERE contact_address.primary_address = ?))) ");
        if (userId > -1) {
            sql.append("AND a.user_id = ? ");
        } else {
            sql.append("AND " + DatabaseUtils.toLowerCase(db) + "(a.username) = ? " + "AND a." + DatabaseUtils.addQuotes(db, "password") + " = ? " + "AND a.enabled = ? ");
        }
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        if (userId > -1) {
            pst.setInt(++i, userId);
        } else {
            pst.setString(++i, this.username);
            pst.setString(++i, this.encryptPassword(this.password));
            pst.setBoolean(++i, true);
        }
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("User record not found.");
        }
        this.buildResources(db);
    }

    public void buildRevenueYTD(Connection db, int year, int type) throws SQLException {
        ResultSet rs;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT sum(rv.amount) as s FROM revenue rv WHERE rv.owner IN (" + this.getIdRange() + ") AND rv.year = ? ");
        if (type > 0) {
            sql.append("AND rv.type = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, year);
        if (type > 0) {
            pst.setInt(++i, type);
        }
        if ((rs = pst.executeQuery()).next()) {
            this.setYTD(rs.getDouble("s"));
        }
        rs.close();
        pst.close();
    }

    public double getGrossPipeline(int divisor) {
        return (double)Math.round(this.pipelineValue) / (double)divisor;
    }

    public void buildGrossPipelineValue(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT SUM(oc.guessvalue) AS thesum FROM opportunity_component oc WHERE oc.owner IN (" + this.getIdRange() + ") " + "AND oc.enabled = ? AND oc.closed IS NULL AND oc.trashed_date IS NULL ");
        pst.setBoolean(1, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setPipelineValue(rs.getDouble("thesum"));
        }
        rs.close();
        pst.close();
        this.setPipelineValueIsValid(true);
    }

    public int newPassword(Connection db) throws SQLException {
        int resultCount = -1;
        if (this.getId() == -1) {
            throw new SQLException("User ID was not specified");
        }
        this.checkHidden();
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET " + DatabaseUtils.addQuotes(db, "password") + " = ?, hidden = ? ");
        if (this.modifiedBy > -1) {
            sql.append(", modifiedby = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        }
        sql.append(" WHERE user_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.encryptPassword(this.password1));
        pst.setBoolean(++i, this.getHidden());
        if (this.modifiedBy > -1) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected boolean isValid(Connection db, ActionContext context) throws Exception {
        this.isValidNoPass(db, context);
        if (!(this.contactId >= 1 || this.contact != null && ObjectValidator.validate(null, db, (Object)this.contact))) {
            this.errors.put("contactIdError", "Contact needs to be selected or newly created first");
        }
        if (this.password1 == null || this.password1.trim().equals("")) {
            this.errors.put("password1Error", "Password cannot be left blank");
        }
        if (!this.password1.equals(this.password2)) {
            this.errors.put("password2Error", "Verification password does not match");
        }
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        if (this.hidden && this.expires != null && currentTime.before(this.expires) && this.enabled) {
            this.errors.put("expiresError", "The user cannot be hidden when the user is enabled and has not expired.");
            this.errors.put("enabledError", "The user cannot be hidden when the user is enabled and has not expired.");
        }
        return !this.hasErrors();
    }

    protected boolean isValidChangePass(ActionContext context, String currentPass) {
        if (!this.getEncryptedPassword().equals(currentPass) || this.password == null || this.password.trim().equals("")) {
            this.errors.put("passwordError", "Incorrect value for current password");
        }
        if (this.password1 == null || this.password1.trim().equals("")) {
            this.errors.put("password1Error", "Password cannot be left blank");
        }
        if (!this.password1.equals(this.password2)) {
            this.errors.put("password2Error", "Verification password does not match");
        }
        return !this.hasErrors();
    }

    protected boolean isValidNoPass(Connection db, ActionContext context) throws SQLException {
        if (this.username == null || this.username.trim().equals("")) {
            this.errors.put("usernameError", "Username cannot be left blank");
        } else if (this.isDuplicate(db)) {
            this.errors.put("usernameError", "Username is already in use");
        }
        if (this.roleId < 0) {
            this.errors.put("roleError", "Role needs to be selected");
        }
        if (this.managerId > 0 && this.id > -1 && this.alias == -1) {
            if (this.managerId == this.id) {
                this.errors.put("managerIdError", "User cannot report to self");
            } else {
                ConnectionElement ce = (ConnectionElement)context.getRequest().getSession().getAttribute("ConnectionElement");
                SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
                User updatedUser = systemStatus.getHierarchyList().getUser(this.id);
                User testChild = updatedUser.getChild(this.managerId);
                if (testChild != null) {
                    Stack<String> names = new Stack<String>();
                    int currentId = testChild.getId();
                    while (currentId != this.id) {
                        String childName = testChild.getContact().getNameFirstLast();
                        names.push(childName);
                        testChild = testChild.getManagerUser();
                        currentId = testChild.getId();
                    }
                    names.push(updatedUser.getContact().getNameFirstLast());
                    StringBuffer sb = new StringBuffer();
                    sb.append("Cannot create a circular hierarchy, review current hierarchy:\r\n");
                    while (!names.empty()) {
                        sb.append((String)names.pop());
                        if (names.empty()) continue;
                        sb.append(" < ");
                    }
                    this.errors.put("managerIdError", sb.toString());
                }
            }
        }
        return !this.hasErrors();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setUsername(rs.getString("username"));
        String thisPassword = rs.getString("password");
        this.setPassword(thisPassword);
        this.setEncryptedPassword(thisPassword);
        this.setRoleId(rs.getInt("role_id"));
        this.lastLogin = rs.getTimestamp("last_login");
        this.setManagerId(rs.getInt("manager_id"));
        this.setSiteId(DatabaseUtils.getInt(rs, "siteid"));
        this.ip = rs.getString("last_ip");
        this.timeZone = rs.getString("timezone");
        this.startOfDay = rs.getInt("access_startofday");
        this.endOfDay = rs.getInt("access_endofday");
        this.expires = rs.getTimestamp("expires");
        this.setAlias(rs.getInt("alias"));
        this.setContactId(rs.getInt("contact_id_link"));
        this.setId(rs.getInt("access_user_id"));
        this.enabled = rs.getBoolean("access_enabled");
        this.setAssistant(rs.getInt("access_assistant"));
        this.entered = rs.getTimestamp("access_entered");
        this.enteredBy = rs.getInt("access_enteredby");
        this.modified = rs.getTimestamp("access_modified");
        this.modifiedBy = rs.getInt("access_modifiedby");
        this.currency = rs.getString("currency");
        this.language = rs.getString("language");
        this.setWebdavPassword(rs.getString("webdav_password"));
        this.hidden = rs.getBoolean("hidden");
        this.hasWebdavAccess = rs.getBoolean("allow_webdav_access");
        this.hasHttpApiAccess = rs.getBoolean("allow_httpapi_access");
        this.setRole(rs.getString("systemrole"));
        this.roleType = DatabaseUtils.getInt(rs, "role_type");
        this.managerUserEnabled = this.managerId > -1 ? rs.getBoolean("mgr_enabled") : false;
        this.siteIdName = rs.getString("site_id_name");
    }

    public boolean isDuplicate(Connection db) throws SQLException {
        boolean duplicate = false;
        if (this.previousUsername != null && this.previousUsername.equals(this.username)) {
            return false;
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE " + DatabaseUtils.toLowerCase(db) + "(username) = ? " + "AND enabled = ? ");
        pst.setString(1, this.getUsername().toLowerCase());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            duplicate = true;
        }
        rs.close();
        pst.close();
        pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + ", contact " + "WHERE " + DatabaseUtils.toLowerCase(db) + "(username) = ? " + "AND " + DatabaseUtils.addQuotes(db, "access") + ".enabled = ? " + "AND contact.user_id = " + DatabaseUtils.addQuotes(db, "access") + ".user_id " + "AND contact.enabled = ? ");
        int i = 0;
        pst.setString(++i, this.getUsername().toLowerCase());
        pst.setBoolean(++i, false);
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        if (rs.next()) {
            duplicate = true;
        }
        rs.close();
        pst.close();
        return duplicate;
    }

    public static int getContactId(Connection db, int userId) throws SQLException {
        int contactId = -1;
        if (userId == -1) {
            throw new SQLException("User Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT contact_id FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? ");
        pst.setInt(1, userId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            contactId = rs.getInt("contact_id");
        }
        rs.close();
        pst.close();
        return contactId;
    }

    private void buildChildren(Connection db) throws SQLException {
        this.childUsers = new UserList();
        this.childUsers.setManagerId(this.getId());
        this.childUsers.setManagerUser(this);
        this.childUsers.setBuildHierarchy(true);
        if (this.hideHiddenChildren) {
            this.childUsers.setHidden(0);
        }
        this.childUsers.buildList(db);
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        int i = -1;
        i = this.update(db, context, false);
        return i;
    }

    public int update(Connection db) throws SQLException {
        return this.update(db, null, true);
    }

    private int update(Connection db, ActionContext context, boolean override) throws SQLException {
        int resultCount = 0;
        int defaultManager = -1;
        if (context != null && !this.isValidNoPass(db, context)) {
            return -1;
        }
        if (this.getId() == -1) {
            throw new SQLException("User ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.addQuotes(db, "access") + " " + "SET username = ?, manager_id = ?, role_id = ?, expires = ?, site_id = ?, ");
        if (this.password1 != null) {
            sql.append("" + DatabaseUtils.addQuotes(db, "password") + " = ?, ");
            sql.append("webdav_password = ?, ");
        }
        if (this.enteredBy > -1) {
            sql.append("enteredby = ?, ");
        }
        if (this.modifiedBy > -1) {
            sql.append("modifiedby = ?, ");
        }
        if (this.contactId > -1) {
            sql.append("contact_id = ?, ");
        }
        if (this.assistant > -1) {
            sql.append("assistant = ?, ");
        }
        sql.append("alias = ?, hidden = ?, allow_webdav_access = ?, allow_httpapi_access = ? ");
        sql.append("WHERE user_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.username);
        if (this.getAlias() > -1) {
            pst.setInt(++i, defaultManager);
        } else {
            pst.setInt(++i, this.getManagerId());
        }
        pst.setInt(++i, this.roleId);
        if (this.expires == null) {
            pst.setNull(++i, 93);
        } else {
            pst.setTimestamp(++i, this.getExpires());
        }
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        if (this.password1 != null) {
            pst.setString(++i, this.encryptPassword(this.password1));
            pst.setString(++i, this.encryptWebdavPassword(this.username, this.password1));
        }
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.modifiedBy > -1) {
            pst.setInt(++i, this.modifiedBy);
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.assistant > -1) {
            pst.setInt(++i, this.assistant);
        }
        pst.setInt(++i, this.alias);
        pst.setBoolean(++i, this.hidden);
        pst.setBoolean(++i, this.hasWebdavAccess);
        pst.setBoolean(++i, this.hasHttpApiAccess);
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    private String encryptPassword(String tmp) {
        return PasswordHash.encrypt(tmp);
    }

    private String encryptWebdavPassword(String username, String password) {
        if (username != null && password != null) {
            return PasswordHash.encrypt(username + ":" + "Centric CRM" + ":" + password);
        }
        return null;
    }

    public String getIdRange() {
        UserList shortChildList = this.getShortChildList();
        UserList fullChildList = this.getFullChildList(shortChildList, new UserList());
        return fullChildList.getUserListIds(this.id);
    }

    public static int getNumberOfSimilarUsernames(Connection db, String tmpUsername) throws SQLException {
        ResultSet rs = null;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as recordcount FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE username LIKE (?)");
        int i = 0;
        pst.setString(++i, tmpUsername + "%");
        rs = pst.executeQuery();
        int no = 0;
        if (rs.next()) {
            no = rs.getInt("recordcount");
        }
        rs.close();
        pst.close();
        return no;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("expires");
        return thisList;
    }

    public static int getIdByEmailAddress(Connection db, String email) throws SQLException {
        int userId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT user_id FROM contact c, contact_emailaddress e WHERE " + DatabaseUtils.toLowerCase(db) + "(e.email) = ? " + "AND c.contact_id = e.contact_id " + "AND user_id IS NOT NULL " + "AND user_id > 0 ");
        pst.setString(1, email.toLowerCase());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            userId = rs.getInt("user_id");
        }
        rs.close();
        pst.close();
        return userId;
    }

    public boolean exists(Connection db, String username) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "WHERE  username = ? " + "AND user_id IS NOT NULL " + "AND user_id > 0 ");
        pst.setString(1, username.toLowerCase());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.id = rs.getInt("user_id");
        }
        rs.close();
        pst.close();
        return this.id > -1;
    }

    private void checkHidden() {
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        if (this.getExpires() != null && currentTime.before(this.getExpires()) && this.getEnabled()) {
            this.setHidden(false);
        } else if (this.getExpires() == null && this.getEnabled()) {
            this.setHidden(false);
        }
    }

    private void checkHidden(boolean enabledValue) {
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        if (this.getExpires() != null && currentTime.before(this.getExpires()) && enabledValue) {
            this.setHidden(false);
        } else if (this.getExpires() == null && enabledValue) {
            this.setHidden(false);
        }
    }

    public String toString() {
        return this.getUsername() + "(" + this.getId() + ")";
    }
}

