/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.DatabaseUtils;

public class UserGroup
extends GenericBean {
    protected int id = -1;
    protected String name = null;
    protected String description = null;
    protected boolean enabled = false;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Timestamp trashedDate = null;
    private int siteId = -1;
    private String siteName = null;
    private boolean buildResources = false;
    public UserList groupUsers = null;
    private String insertMembers = null;
    private String deleteMembers = null;
    private int userCount = 0;
    private boolean buildUserCount = false;

    public UserGroup() {
    }

    public UserGroup(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public UserGroup(Connection db, String groupId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(groupId));
    }

    public UserGroup(Connection db, int groupId) throws SQLException {
        this.queryRecord(db, groupId);
    }

    public void queryRecord(Connection db, int groupId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ug.*, ls.description AS site_name FROM user_group ug LEFT JOIN lookup_site_id ls ON (ug.site_id = ls.code) WHERE ug.group_id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, groupId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("User Group record not found.");
        }
        if (this.getBuildUserCount()) {
            this.buildUserCount(db);
        }
        if (this.getBuildResources()) {
            this.buildResources(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("group_id"));
        this.setName(rs.getString("group_name"));
        this.setDescription(rs.getString("description"));
        this.setEnabled(rs.getBoolean("enabled"));
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.siteName = rs.getString("site_name");
    }

    public void buildResources(Connection db) throws SQLException {
        this.groupUsers = new UserList();
        this.groupUsers.setBuildContact(true);
        this.groupUsers.setBuildContactDetails(true);
        this.groupUsers.setSiteId(this.getSiteId());
        this.groupUsers.setIncludeUsersWithAccessToAllSites(true);
        this.groupUsers.setUserGroupId(this.getId());
        this.groupUsers.buildList(db);
    }

    public void buildUserCount(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS usercount FROM user_group_map WHERE group_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = null;
        rs = pst.executeQuery();
        if (rs.next()) {
            this.setUserCount(DatabaseUtils.getInt(rs, "usercount", 0));
        }
        rs.close();
        pst.close();
    }

    public boolean insert(Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("UserGroup-> Beginning insert");
        }
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "user_group_group_id_seq");
        sql.append("INSERT INTO user_group (" + (this.id > -1 ? "group_id," : "") + " group_name, description, enabled, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy, site_id ) ");
        sql.append("VALUES (" + (this.id > -1 ? "?," : "") + " ?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getEnabled());
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "user_group_group_id_seq", this.id);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("UserGroup-> User Group inserted");
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE user_group  SET group_name = ?,  description = ?,  enabled = ?,  modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + " modifiedby = ?, " + " site_id = ? " + " WHERE group_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getEnabled());
        DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.getSiteId());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        if (this.getId() == -1) {
            throw new SQLException("Group ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int ticketCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) AS ticketcount FROM ticket WHERE user_group_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (ticketCount = rs.getInt("ticketcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("ticketMap");
                thisDependency.setCount(ticketCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        try {
            int campaignCount;
            i = 0;
            pst = db.prepareStatement("DELETE FROM campaign_group_map WHERE user_group_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("SELECT count(*) AS campaigncount FROM campaign_group_map WHERE user_group_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (campaignCount = rs.getInt("campaigncount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("campaignMap");
                thisDependency.setCount(campaignCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        try {
            int stepCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) AS stepcount FROM action_step WHERE group_id = ? AND permission_type = ? ");
            pst.setInt(++i, this.getId());
            pst.setInt(++i, 8);
            rs = pst.executeQuery();
            if (rs.next() && (stepCount = rs.getInt("stepcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("actionSteps");
                thisDependency.setCount(stepCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote ID not specified");
        }
        PreparedStatement pst = null;
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            pst = db.prepareStatement("DELETE FROM campaign_group_map WHERE user_group_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM user_group_map WHERE group_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM user_group WHERE group_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean addUser(Connection db, int userId) throws SQLException {
        return this.addUser(db, userId, 10);
    }

    public boolean addUser(Connection db, int userId, int level) throws SQLException {
        if (this.isUserInGroup(db, userId)) {
            return true;
        }
        StringBuffer sql = new StringBuffer();
        int mapId = DatabaseUtils.getNextSeq(db, "user_group_map_group_map_id_seq");
        sql.append("INSERT INTO user_group_map (" + (mapId > -1 ? "group_map_id," : "") + " user_id, group_id, " + DatabaseUtils.addQuotes(db, "level") + ", ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enabled ) ");
        sql.append("VALUES (" + (mapId > -1 ? "?," : "") + " ?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("? ) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (mapId > -1) {
            pst.setInt(++i, mapId);
        }
        pst.setInt(++i, userId);
        pst.setInt(++i, this.getId());
        pst.setInt(++i, level);
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        pst.setBoolean(++i, true);
        pst.execute();
        pst.close();
        mapId = DatabaseUtils.getCurrVal(db, "user_group_map_group_map_id_seq", mapId);
        return true;
    }

    public boolean removeUser(Connection db, int userId) throws SQLException {
        if (userId == -1) {
            return false;
        }
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM user_group_map WHERE user_id = ? AND group_id = ? AND group_map_id > -1 ");
        pst.setInt(1, userId);
        pst.setInt(2, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean isUserInGroup(Connection db, int userId) throws SQLException {
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement("SELECT * FROM user_group_map WHERE group_id = ? AND user_id = ? ");
        pst.setInt(1, this.getId());
        pst.setInt(2, userId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public boolean updateUserMembership(Connection db) throws SQLException {
        try {
            StringTokenizer users;
            db.setAutoCommit(false);
            if (this.insertMembers != null && !this.insertMembers.equals("") && this.getId() > -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("UserGroup::UserList-> New: " + this.insertMembers);
                }
                users = new StringTokenizer(this.insertMembers, "|");
                while (users.hasMoreTokens()) {
                    int thisUserId = -1;
                    String thisUserIdValue = users.nextToken();
                    thisUserId = Integer.parseInt(thisUserIdValue);
                    if (thisUserId == -1) continue;
                    this.addUser(db, thisUserId);
                }
            }
            if (this.deleteMembers != null && !this.deleteMembers.equals("") && this.getId() > -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("UserGroup::UserList-> Del: " + this.deleteMembers);
                }
                users = new StringTokenizer(this.deleteMembers, "|");
                while (users.hasMoreTokens()) {
                    String thisUserId = users.nextToken();
                    this.removeUser(db, Integer.parseInt(thisUserId));
                }
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int getPermission(int siteId) {
        int result = -1;
        result = this.getSiteId() == -1 ? (this.getSiteId() == siteId ? 4 : 1) : (siteId == -1 ? 4 : (siteId == this.getSiteId() ? 4 : -1));
        return result;
    }

    public String toString() {
        return this.getName() + " (" + this.getId() + ")";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public UserList getGroupUsers() {
        return this.groupUsers;
    }

    public void setGroupUsers(UserList tmp) {
        this.groupUsers = tmp;
    }

    public String getInsertMembers() {
        return this.insertMembers;
    }

    public void setInsertMembers(String tmp) {
        this.insertMembers = tmp;
    }

    public String getDeleteMembers() {
        return this.deleteMembers;
    }

    public void setDeleteMembers(String tmp) {
        this.deleteMembers = tmp;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String tmp) {
        this.siteName = tmp;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void setUserCount(int tmp) {
        this.userCount = tmp;
    }

    public void setUserCount(String tmp) {
        this.userCount = Integer.parseInt(tmp);
    }

    public boolean getBuildUserCount() {
        return this.buildUserCount;
    }

    public void setBuildUserCount(boolean tmp) {
        this.buildUserCount = tmp;
    }

    public void setBuildUserCount(String tmp) {
        this.buildUserCount = DatabaseUtils.parseBoolean(tmp);
    }
}

