/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class UserGroupList
extends ArrayList {
    PagedListInfo pagedListInfo = null;
    protected int groupId = -1;
    protected int userId = -1;
    protected int campaignId = -1;
    protected int enabled = -1;
    protected boolean buildResources = false;
    protected boolean getEnabledForUser = false;
    protected boolean getEnabledForCampaign = false;
    private String labelNoneSelected = null;
    private int siteId = -1;
    private boolean includeAllSites = false;
    private boolean exclusiveToSite = false;
    private boolean buildUserCount = false;
    public static final String tableName = "user_group";
    public static final String uniqueField = "group_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM user_group ug LEFT JOIN lookup_site_id ls ON (ug.site_id = ls.code) WHERE ug.group_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(ug.group_name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("ug.group_name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY ug.group_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" ug.*, ls.description AS site_name FROM user_group ug LEFT JOIN lookup_site_id ls ON (ug.site_id = ls.code) WHERE ug.group_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            UserGroup thisGroup = new UserGroup(rs);
            this.add(thisGroup);
        }
        rs.close();
        pst.close();
        if (this.buildResources || this.buildUserCount) {
            for (UserGroup group : this) {
                if (this.buildResources) {
                    group.buildResources(db);
                    continue;
                }
                if (!this.buildUserCount) continue;
                group.buildUserCount(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.groupId > -1) {
            sqlFilter.append("AND ug.group_id = ? ");
        }
        if (!this.getEnabledForUser && !this.getEnabledForCampaign) {
            if (this.userId > -1) {
                sqlFilter.append("AND ug.group_id IN (SELECT group_id FROM user_group_map WHERE user_id = ? ) ");
            }
            if (this.campaignId > -1) {
                sqlFilter.append("AND ug.group_id IN (SELECT user_group_id FROM campaign_group_map WHERE campaign_id = ?) ");
            }
            if (this.enabled != -1) {
                sqlFilter.append("AND ug.enabled = ? ");
            }
        } else if (this.getEnabledForUser) {
            sqlFilter.append("AND (ug.group_id IN (SELECT group_id FROM user_group_map WHERE user_id = ? ) " + (this.enabled != -1 ? " OR ug.enabled = ?" : "") + ") ");
            if (this.campaignId > -1) {
                sqlFilter.append("AND ug.group_id IN (SELECT user_group_id FROM campaign_group_map WHERE campaign_id = ?) ");
            }
        } else if (this.getEnabledForCampaign) {
            sqlFilter.append("AND (ug.group_id IN (SELECT user_group_id FROM campaign_group_map WHERE campaign_id = ?) " + (this.enabled != -1 ? " OR ug.enabled = ?" : "") + ") ");
            if (this.userId > -1) {
                sqlFilter.append("AND ug.group_id IN (SELECT group_id FROM user_group_map WHERE user_id = ?) ");
            }
        } else {
            sqlFilter.append(" AND (ug.group_id IN (SELECT group_id FROM user_group_map WHERE user_id = ? ) OR ug.enabled = ?) ");
        }
        if (!this.includeAllSites) {
            if (this.siteId > -1) {
                if (this.exclusiveToSite) {
                    sqlFilter.append(" AND site_id = ? ");
                } else {
                    sqlFilter.append(" AND (site_id = ? OR site_id IS NULL) ");
                }
            } else {
                sqlFilter.append(" AND site_id IS NULL ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.groupId > -1) {
            pst.setInt(++i, this.groupId);
        }
        if (!this.getEnabledForUser && !this.getEnabledForCampaign) {
            if (this.userId > -1) {
                pst.setInt(++i, this.userId);
            }
            if (this.enabled != -1) {
                pst.setBoolean(++i, this.enabled == 1);
            }
            if (this.campaignId > -1) {
                pst.setInt(++i, this.campaignId);
            }
        } else if (this.getEnabledForUser) {
            pst.setInt(++i, this.userId);
            if (this.enabled != -1) {
                pst.setBoolean(++i, this.enabled == 1);
            }
            if (this.campaignId > -1) {
                pst.setInt(++i, this.campaignId);
            }
        } else if (this.getEnabledForCampaign) {
            pst.setInt(++i, this.campaignId);
            if (this.enabled != -1) {
                pst.setBoolean(++i, this.enabled == 1);
            }
            if (this.userId > -1) {
                pst.setInt(++i, this.userId);
            }
        }
        if (this.siteId > -1 && !this.includeAllSites) {
            pst.setInt(++i, this.getSiteId());
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public HashMap getHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (UserGroup group : this) {
            map.put(String.valueOf(group.getId()), group.getName());
        }
        return map;
    }

    public boolean addUsersForGroups(Connection db, HashMap map, int userId) throws SQLException {
        for (UserGroup group : this) {
            if (map.get(String.valueOf(group.getId())) != null) {
                map.remove(String.valueOf(group.getId()));
                continue;
            }
            group.removeUser(db, userId);
        }
        for (Integer key : map.keySet()) {
            UserGroup group = new UserGroup();
            group.setBuildResources(true);
            group.queryRecord(db, key);
            group.addUser(db, userId);
        }
        return true;
    }

    public void setGetEnabledForUser(int enabledOK, int uId) {
        this.enabled = enabledOK;
        this.userId = uId;
        this.getEnabledForUser = true;
    }

    public void setGetEnabledForCampaign(int enabledOK, int cId) {
        this.enabled = enabledOK;
        this.campaignId = cId;
        this.getEnabledForCampaign = true;
    }

    public HtmlSelect getHtmlSelectObj(int selectedKey) {
        HtmlSelect groupListSelect = new HtmlSelect();
        if (this.labelNoneSelected != null) {
            groupListSelect.addItem(-1, this.getLabelNoneSelected());
        }
        for (UserGroup thisGroup : this) {
            if (thisGroup.getEnabled()) {
                groupListSelect.addItem(thisGroup.getId(), thisGroup.getName() + (thisGroup.getSiteId() != -1 ? thisGroup.getSiteName() : ""));
                continue;
            }
            if (thisGroup.getId() != selectedKey) continue;
            groupListSelect.addItem(thisGroup.getId(), thisGroup.getName() + (thisGroup.getSiteId() != -1 ? thisGroup.getSiteName() : "") + " (X)");
        }
        return groupListSelect;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getGetEnabledForUser() {
        return this.getEnabledForUser;
    }

    public void setGetEnabledForUser(boolean tmp) {
        this.getEnabledForUser = tmp;
    }

    public void setGetEnabledForUser(String tmp) {
        this.getEnabledForUser = DatabaseUtils.parseBoolean(tmp);
    }

    public String getLabelNoneSelected() {
        return this.labelNoneSelected;
    }

    public void setLabelNoneSelected(String tmp) {
        this.labelNoneSelected = tmp;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public boolean getGetEnabledForCampaign() {
        return this.getEnabledForCampaign;
    }

    public void setGetEnabledForCampaign(boolean tmp) {
        this.getEnabledForCampaign = tmp;
    }

    public void setGetEnabledForCampaign(String tmp) {
        this.getEnabledForCampaign = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildUserCount() {
        return this.buildUserCount;
    }

    public void setBuildUserCount(boolean tmp) {
        this.buildUserCount = tmp;
    }

    public void setBuildUserCount(String tmp) {
        this.buildUserCount = DatabaseUtils.parseBoolean(tmp);
    }
}

