/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.ContactUtils;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class UserList
extends Vector
implements SyncableList {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final String tableName = "access";
    public static final String uniqueField = "user_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private String emptyHtmlSelectRecord = null;
    private int enteredBy = -1;
    private int roleId = -1;
    private int managerId = -1;
    private User managerUser = null;
    private boolean buildContact = false;
    private boolean buildContactDetails = false;
    private boolean buildHierarchy = false;
    private boolean buildEmployeeUsersOnly = false;
    private boolean buildAccountUsersOnly = false;
    private boolean topLevel = false;
    private int department = -1;
    private int enabled = -1;
    private int hasWebdavAccess = -1;
    private int hasHttpApiAccess = -1;
    private String jsEvent = null;
    private int includeAliases = 0;
    private int hidden = -1;
    private Timestamp expires = null;
    private int expired = -1;
    private boolean buildRevenueYTD = false;
    private int revenueYear = -1;
    private int revenueType = 0;
    private boolean buildGrossPipelineValue = false;
    private boolean includeMe = false;
    private String myValue = "";
    private int myId = -1;
    private String username = null;
    private String password = null;
    private boolean excludeDisabledIfUnselected = false;
    private boolean includeUsersWithRolesOnly = true;
    private boolean excludeExpiredIfUnselected = false;
    private Timestamp enteredRangeStart = null;
    private Timestamp enteredRangeEnd = null;
    private int roleType = -1;
    private int userGroupId = -1;
    private int siteId = -1;
    private boolean includeUsersWithAccessToAllSites = false;

    public UserList() {
    }

    public UserList(Connection db, User parentUser, boolean doHierarchy) throws SQLException {
        this.managerId = parentUser.getId();
        this.managerUser = parentUser;
        this.buildHierarchy = doHierarchy;
        this.buildList(db);
    }

    public int getHasWebdavAccess() {
        return this.hasWebdavAccess;
    }

    public void setHasWebdavAccess(int tmp) {
        this.hasWebdavAccess = tmp;
    }

    public void setHasWebdavAccess(String tmp) {
        this.hasWebdavAccess = Integer.parseInt(tmp);
    }

    public int getHasHttpApiAccess() {
        return this.hasHttpApiAccess;
    }

    public void setHasHttpApiAccess(int tmp) {
        this.hasHttpApiAccess = tmp;
    }

    public void setHasHttpApiAccess(String tmp) {
        this.hasHttpApiAccess = Integer.parseInt(tmp);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public boolean getBuildRevenueYTD() {
        return this.buildRevenueYTD;
    }

    public void setBuildRevenueYTD(boolean buildRevenueYTD) {
        this.buildRevenueYTD = buildRevenueYTD;
    }

    public boolean getExcludeDisabledIfUnselected() {
        return this.excludeDisabledIfUnselected;
    }

    public boolean getIncludeUsersWithRolesOnly() {
        return this.includeUsersWithRolesOnly;
    }

    public void setExcludeDisabledIfUnselected(boolean excludeDisabledIfUnselected) {
        this.excludeDisabledIfUnselected = excludeDisabledIfUnselected;
    }

    public void setIncludeUsersWithRolesOnly(boolean tmp) {
        this.includeUsersWithRolesOnly = tmp;
    }

    public void setEnteredRangeStart(Timestamp tmp) {
        this.enteredRangeStart = tmp;
    }

    public void setEnteredRangeEnd(Timestamp tmp) {
        this.enteredRangeEnd = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setRoleType(int tmp) {
        this.roleType = tmp;
    }

    public void setRoleType(String tmp) {
        this.roleType = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setIncludeUsersWithAccessToAllSites(boolean tmp) {
        this.includeUsersWithAccessToAllSites = tmp;
    }

    public void setIncludeUsersWithAccessToAllSites(String tmp) {
        this.includeUsersWithAccessToAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildGrossPipelineValue() {
        return this.buildGrossPipelineValue;
    }

    public void setBuildGrossPipelineValue(boolean buildGrossPipelineValue) {
        this.buildGrossPipelineValue = buildGrossPipelineValue;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setRoleId(int tmp) {
        this.roleId = tmp;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setDepartment(int department) {
        this.department = department;
    }

    public void setDepartment(String department) {
        this.department = Integer.parseInt(department);
    }

    public int getRevenueType() {
        return this.revenueType;
    }

    public void setRevenueType(int revenueType) {
        this.revenueType = revenueType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setJsEvent(String jsEvent) {
        this.jsEvent = jsEvent;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setIncludeMe(boolean tmp) {
        this.includeMe = tmp;
    }

    public int getRevenueYear() {
        return this.revenueYear;
    }

    public void setRevenueYear(int revenueYear) {
        this.revenueYear = revenueYear;
    }

    public void setMyValue(String tmp) {
        this.myValue = tmp;
    }

    public void setMyId(int tmp) {
        this.myId = tmp;
    }

    public void setIncludeAliases(int tmp) {
        this.includeAliases = tmp;
    }

    public void setManagerId(int tmp) {
        this.managerId = tmp;
    }

    public void setTopLevel(boolean tmp) {
        this.topLevel = tmp;
    }

    public void setBuildContact(boolean tmp) {
        this.buildContact = tmp;
    }

    public void setBuildContactDetails(boolean tmp) {
        this.buildContactDetails = tmp;
    }

    public void setBuildHierarchy(boolean tmp) {
        this.buildHierarchy = tmp;
    }

    public void setBuildEmployeeUsersOnly(boolean tmp) {
        this.buildEmployeeUsersOnly = tmp;
    }

    public void setBuildEmployeeUsersOnly(String tmp) {
        this.buildEmployeeUsersOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildAccountUsersOnly(boolean tmp) {
        this.buildAccountUsersOnly = tmp;
    }

    public void setBuildAccountUsersOnly(String tmp) {
        this.buildAccountUsersOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public void setManagerUser(User tmp) {
        this.managerUser = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public String getUsername() {
        return this.username;
    }

    public int getIncludeAliases() {
        return this.includeAliases;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getDepartment() {
        return this.department;
    }

    public boolean getIncludeMe() {
        return this.includeMe;
    }

    public String getMyValue() {
        return this.myValue;
    }

    public int getMyId() {
        return this.myId;
    }

    public int getListSize() {
        return this.size();
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect userListSelect = new HtmlSelect();
        userListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            userListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        if (this.includeMe) {
            userListSelect.addItem(this.myId, this.myValue);
        }
        for (User thisUser : this) {
            String elementText = null;
            Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            elementText = thisUser.getContact().getValidName();
            if (!thisUser.getEnabled() || thisUser.getExpires() != null && currentTime.after(thisUser.getExpires())) {
                elementText = elementText + " *";
            }
            if (thisUser.getSiteId() != -1) {
                elementText = elementText + " (" + thisUser.getSiteIdName() + ")";
            }
            if (!thisUser.getEnabled() && (thisUser.getEnabled() || this.excludeDisabledIfUnselected) && (!this.excludeDisabledIfUnselected || thisUser.getId() != defaultKey) || !(thisUser.getExpires() == null || thisUser.getExpires() != null && currentTime.before(thisUser.getExpires()) || thisUser.getExpires() != null && currentTime.after(thisUser.getExpires()) && !this.excludeExpiredIfUnselected) && (!this.excludeExpiredIfUnselected || thisUser.getId() != defaultKey) || thisUser.getId() == 0) continue;
            userListSelect.addItem(thisUser.getId(), elementText);
        }
        return userListSelect.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelectObj(String selectName, int defaultKey) {
        HtmlSelect userListSelect = new HtmlSelect();
        userListSelect.setJsEvent(this.jsEvent);
        if (this.emptyHtmlSelectRecord != null) {
            userListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        if (this.includeMe) {
            userListSelect.addItem(this.myId, this.myValue);
        }
        for (User thisUser : this) {
            String elementText = null;
            Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            elementText = thisUser.getContact().getValidName();
            if (!thisUser.getEnabled() || thisUser.getExpires() != null && currentTime.after(thisUser.getExpires())) {
                elementText = elementText + " *";
            }
            if (thisUser.getSiteId() != -1) {
                elementText = elementText + " (" + thisUser.getSiteIdName() + ")";
            }
            if (!thisUser.getEnabled() && (thisUser.getEnabled() || this.excludeDisabledIfUnselected) && (!this.excludeDisabledIfUnselected || thisUser.getId() != defaultKey)) continue;
            userListSelect.addItem(thisUser.getId(), elementText);
        }
        return userListSelect;
    }

    public String getUserListIds(int toInclude) {
        StringBuffer values = new StringBuffer();
        values.append(String.valueOf(toInclude));
        Iterator i = this.iterator();
        if (i.hasNext()) {
            values.append(", ");
        }
        while (i.hasNext()) {
            User thisUser = (User)((Object)i.next());
            values.append(String.valueOf(thisUser.getId()));
            if (!i.hasNext()) continue;
            values.append(", ");
        }
        return values.toString();
    }

    public String getUserListIds() {
        StringBuffer values = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            User thisUser = (User)((Object)i.next());
            values.append(String.valueOf(thisUser.getId()));
            if (!i.hasNext()) continue;
            values.append(", ");
        }
        return values.toString();
    }

    public int getHidden() {
        return this.hidden;
    }

    public void setHidden(int tmp) {
        this.hidden = tmp;
    }

    public void setHidden(String tmp) {
        this.hidden = Integer.parseInt(tmp);
    }

    public Timestamp getExpires() {
        return this.expires;
    }

    public void setExpires(Timestamp tmp) {
        this.expires = tmp;
    }

    public void setExpires(String tmp) {
        this.expires = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getExpired() {
        return this.expired;
    }

    public void setExpired(int tmp) {
        this.expired = tmp;
    }

    public void setExpired(String tmp) {
        this.expired = Integer.parseInt(tmp);
    }

    public User getUser(int childId) {
        for (User thisUser : this) {
            if (thisUser.getId() == childId) {
                return thisUser;
            }
            User childUser = thisUser.getChild(childId);
            if (childUser == null) continue;
            return childUser;
        }
        return null;
    }

    public User getTopUser(int userId) {
        for (User thisUser : this) {
            if (thisUser.getId() != userId) continue;
            return thisUser;
        }
        return null;
    }

    public User getManagerUser() {
        return this.managerUser;
    }

    public User getObject(ResultSet rs) throws SQLException {
        User thisUser = new User(rs);
        return thisUser;
    }

    public int getRoleType() {
        return this.roleType;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public boolean getIncludeUsersWithAccessToAllSites() {
        return this.includeUsersWithAccessToAllSites;
    }

    public boolean getExcludeExpiredIfUnselected() {
        return this.excludeExpiredIfUnselected;
    }

    public void setExcludeExpiredIfUnselected(boolean tmp) {
        this.excludeExpiredIfUnselected = tmp;
    }

    public void setExcludeExpiredIfUnselected(String tmp) {
        this.excludeExpiredIfUnselected = DatabaseUtils.parseBoolean(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (User thisUser : this) {
            if (!thisUser.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public HashMap reassignElements(ActionContext context, Connection db, SystemStatus systemStatus, int newOwner, int userId) throws SQLException {
        HashMap errors = new HashMap();
        boolean total = false;
        for (User thisUser : this) {
            thisUser.setModifiedBy(userId);
            if (this.checkManager(thisUser, newOwner, errors, systemStatus)) continue;
            break;
        }
        if (errors.size() == 0) {
            for (User thisUser : this) {
                thisUser.setModifiedBy(userId);
                thisUser.reassign(db, newOwner);
            }
        }
        return errors;
    }

    public boolean checkManager(User thisUser, int managerId, HashMap errors, SystemStatus systemStatus) throws SQLException {
        if (managerId > 0 && thisUser.getId() > -1 && thisUser.getAlias() == -1) {
            if (managerId == thisUser.getId()) {
                errors.put("managerIdError", systemStatus.getLabel("user.userCanNotReportToSelf"));
            } else {
                User updatedUser = systemStatus.getHierarchyList().getUser(thisUser.getId());
                User testChild = updatedUser.getChild(managerId);
                if (testChild != null) {
                    Stack<String> names = new Stack<String>();
                    int currentId = testChild.getId();
                    while (currentId != thisUser.getId()) {
                        String childName = testChild.getContact().getNameFirstLast();
                        names.push(childName);
                        testChild = testChild.getManagerUser();
                        currentId = testChild.getId();
                    }
                    names.push(updatedUser.getContact().getNameFirstLast());
                    StringBuffer sb = new StringBuffer();
                    sb.append(systemStatus.getLabel("user.canNotCreateCircularHierarchy.text") + "\r\n");
                    while (!names.empty()) {
                        sb.append((String)names.pop());
                        if (names.empty()) continue;
                        sb.append(systemStatus.getLabel("user.lessThan.withSpaces.symbol"));
                    }
                    errors.put("managerIdError", sb.toString());
                }
            }
        }
        return errors.size() <= 0;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (User thisUser : this) {
            thisUser.setModifiedBy(userId);
            if (!thisUser.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            User thisUser = new User(rs);
            if (thisUser.getContactId() > -1) {
                thisUser.setContact(new Contact(rs));
            }
            if (this.managerUser != null) {
                thisUser.setManagerId(this.managerUser.getId());
                thisUser.setManagerUser(this.managerUser);
            }
            this.add(thisUser);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        this.buildResources(db);
    }

    public void buildRevenueYTD(Connection db) throws SQLException {
        for (User tempUser : this) {
            tempUser.buildRevenueYTD(db, this.getRevenueYear(), this.getRevenueType());
        }
    }

    public void buildPipelineValues(Connection db) throws SQLException {
        for (User tempUser : this) {
            tempUser.buildGrossPipelineValue(db);
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + DatabaseUtils.addQuotes(db, tableName) + " a " + "LEFT JOIN contact c ON (a.contact_id = c.contact_id) " + "LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) " + "LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) " + "LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) " + "LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) " + "LEFT JOIN organization o ON (c.org_id = o.org_id) " + "LEFT JOIN lookup_department d ON (c.department = d.code) " + "LEFT JOIN " + DatabaseUtils.addQuotes(db, tableName) + " m_usr ON (a.manager_id = m_usr.user_id) " + "LEFT JOIN " + DatabaseUtils.addQuotes(db, "role") + " r ON (a.role_id = r.role_id) " + "LEFT JOIN lookup_site_id b ON (a.site_id = b.code) " + "WHERE a.user_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND (" + DatabaseUtils.toLowerCase(db) + "(c.namelast) < ? AND c.namelast IS NOT NULL) ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("a.enabled DESC,c.namelast", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY a.enabled DESC,c.namelast ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("a.username, a." + DatabaseUtils.addQuotes(db, "password") + ", a.role_id, a.last_login, a.manager_id, " + "a.site_id AS siteid, " + "a.last_ip, a.timezone, a.startofday AS access_startofday, " + "a.endofday AS access_endofday, a.expires, a.alias, " + "a.contact_id AS contact_id_link, a.user_id AS access_user_id, " + "a.enabled AS access_enabled, a.assistant AS access_assistant, " + "a.entered AS access_entered, a.enteredby AS access_enteredby, " + "a.modified AS access_modified, a.modifiedby AS access_modifiedby, " + "a.currency, a." + DatabaseUtils.addQuotes(db, "language") + ", a.webdav_password, a.hidden, a.allow_webdav_access, a.allow_httpapi_access, " + "r." + DatabaseUtils.addQuotes(db, "role") + " AS systemrole, r.role_type, " + "m_usr.enabled AS mgr_enabled, " + "b.description AS site_id_name, " + "c.*, o.enabled AS orgenabled, o.trashed_date AS orgtrasheddate, " + "d.description AS departmentname, ca.city AS city, ca.postalcode AS postalcode, " + "lind.description AS industry_name, " + "lcs.description AS source_name, " + "lcr.description AS rating_name " + "FROM " + DatabaseUtils.addQuotes(db, tableName) + " a " + "LEFT JOIN contact c ON (a.contact_id = c.contact_id) " + "LEFT JOIN lookup_industry lind ON (c.industry_temp_code = lind.code) " + "LEFT JOIN lookup_contact_source lcs ON (c.source = lcs.code) " + "LEFT JOIN lookup_contact_rating lcr ON (c.rating = lcr.code) " + "LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id) " + "LEFT JOIN organization o ON (c.org_id = o.org_id) " + "LEFT JOIN lookup_department d ON (c.department = d.code) " + "LEFT JOIN " + DatabaseUtils.addQuotes(db, tableName) + " m_usr ON (a.manager_id = m_usr.user_id) " + "LEFT JOIN " + DatabaseUtils.addQuotes(db, "role") + " r ON (a.role_id = r.role_id) " + "LEFT JOIN lookup_site_id b ON (a.site_id = b.code) " + "WHERE a.user_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void buildResources(Connection db) throws SQLException {
        for (User thisUser : this) {
            thisUser.setBuildContact(this.buildContact);
            thisUser.setBuildContactDetails(this.buildContactDetails);
            thisUser.setBuildHierarchy(this.buildHierarchy);
            if (this.buildContact || this.buildHierarchy) {
                thisUser.buildResources(db);
            }
            if (this.buildRevenueYTD && this.revenueYear > -1) {
                thisUser.buildRevenueYTD(db, this.getRevenueYear(), this.getRevenueType());
            }
            if (!this.buildGrossPipelineValue) continue;
            thisUser.buildGrossPipelineValue(db);
        }
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        sqlFilter.append("AND (ca.address_id IS NULL OR ca.address_id IN ( SELECT cta.address_id FROM contact_address cta WHERE cta.contact_id = c.contact_id AND cta.primary_address = ?) OR ca.address_id IN (SELECT MIN(ctadd.address_id) FROM contact_address ctadd WHERE ctadd.contact_id = c.contact_id AND  ctadd.contact_id NOT IN (SELECT contact_id FROM contact_address WHERE contact_address.primary_address = ?))) ");
        if (this.includeAliases == 1) {
            sqlFilter.append("AND a.alias > -1 ");
        }
        if (this.includeAliases == 0) {
            sqlFilter.append("AND a.alias = -1 ");
        }
        if (this.enteredBy > -1) {
            sqlFilter.append("AND a.enteredby = ? ");
        }
        if (this.roleId > -1) {
            sqlFilter.append("AND r.role_id = ? ");
        }
        if (this.managerId > -1) {
            sqlFilter.append("AND a.manager_id = ? ");
        }
        if (this.department > -1) {
            if (this.department == 0) {
                sqlFilter.append("AND c.department IS NULL ");
            } else {
                sqlFilter.append("AND c.department = ? ");
            }
        } else if (this.topLevel) {
            sqlFilter.append("AND a.manager_id = -1 ");
        } else {
            sqlFilter.append("AND a.contact_id > -1 ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND a.enabled = ? ");
        }
        if (this.hasWebdavAccess != -1) {
            sqlFilter.append("AND a.allow_webdav_access = ? ");
        }
        if (this.hasHttpApiAccess != -1) {
            sqlFilter.append("AND a.allow_httpapi_access = ? ");
        }
        if (this.username != null) {
            sqlFilter.append("AND a.username = ? ");
        }
        if (this.password != null) {
            sqlFilter.append("AND a." + DatabaseUtils.addQuotes(db, "password") + " = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND a.entered > ? ");
            }
            sqlFilter.append("AND a.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND a.modified > ? ");
            sqlFilter.append("AND a.entered < ? ");
            sqlFilter.append("AND a.modified < ? ");
        }
        if (this.enteredRangeStart != null) {
            sqlFilter.append("AND a.entered >= ? ");
        }
        if (this.enteredRangeEnd != null) {
            sqlFilter.append("AND a.entered <= ? ");
        }
        if (this.includeUsersWithRolesOnly) {
            sqlFilter.append("AND a.role_id > -1 AND a.role_id IS NOT NULL ");
        }
        if (this.roleType != -1) {
            sqlFilter.append("AND r.role_type = ? ");
        }
        if (this.siteId != -1) {
            sqlFilter.append("AND ");
            if (this.includeUsersWithAccessToAllSites) {
                sqlFilter.append(" ( ");
            }
            sqlFilter.append("a.site_id = ? ");
            if (this.includeUsersWithAccessToAllSites) {
                sqlFilter.append("OR a.site_id IS NULL ) ");
            }
        }
        if (this.siteId == -1 && this.includeUsersWithAccessToAllSites) {
            sqlFilter.append("AND a.site_id IS NULL ");
        }
        if (this.buildEmployeeUsersOnly) {
            sqlFilter.append("AND c.org_id = 0 ");
        }
        if (this.buildAccountUsersOnly) {
            sqlFilter.append("AND c.org_id > 0 ");
        }
        if (this.hidden != -1) {
            sqlFilter.append("AND (a.hidden = ? " + (this.hidden == 0 ? " OR a.hidden IS NULL " : " AND a.hidden IS NOT NULL ") + ")");
        }
        if (this.expired != -1) {
            sqlFilter.append("AND a.expires " + (this.expired == 1 ? "<" : ">") + " ? ");
        }
        if (this.userGroupId > -1) {
            sqlFilter.append("AND a.user_id IN (SELECT user_id FROM user_group_map WHERE group_id = ?) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.roleId > -1) {
            pst.setInt(++i, this.roleId);
        }
        if (this.managerId > -1) {
            pst.setInt(++i, this.managerId);
        }
        if (this.department > 0) {
            pst.setInt(++i, this.department);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.hasWebdavAccess != -1) {
            pst.setBoolean(++i, this.hasWebdavAccess == 1);
        }
        if (this.hasHttpApiAccess != -1) {
            pst.setBoolean(++i, this.hasHttpApiAccess == 1);
        }
        if (this.username != null) {
            pst.setString(++i, this.username);
        }
        if (this.password != null) {
            pst.setString(++i, this.password);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.enteredRangeStart != null) {
            pst.setTimestamp(++i, this.enteredRangeStart);
        }
        if (this.enteredRangeEnd != null) {
            pst.setTimestamp(++i, this.enteredRangeEnd);
        }
        if (this.roleType != -1) {
            pst.setInt(++i, this.roleType);
        }
        if (this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.hidden != -1) {
            pst.setBoolean(++i, this.hidden == 1);
        }
        if (this.expired != -1) {
            pst.setTimestamp(++i, this.expires != null ? this.expires : new Timestamp(Calendar.getInstance().getTimeInMillis()));
        }
        if (this.userGroupId > -1) {
            pst.setInt(++i, this.userGroupId);
        }
        return i;
    }

    public int queryRecordCount(Connection db) throws SQLException {
        int recordCount = 0;
        StringBuffer sqlFilter = new StringBuffer();
        String sqlCount = "SELECT COUNT(*) AS recordcount FROM " + DatabaseUtils.addQuotes(db, tableName) + " a " + "LEFT JOIN contact c ON (a.contact_id = c.contact_id) " + "LEFT JOIN contact_address ca ON (c.contact_id = ca.contact_id), " + "" + DatabaseUtils.addQuotes(db, "role") + " r " + "WHERE a.role_id = r.role_id ";
        this.createFilter(db, sqlFilter);
        PreparedStatement pst = db.prepareStatement(sqlCount + sqlFilter.toString());
        int items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = DatabaseUtils.getInt(rs, "recordcount", 0);
        }
        rs.close();
        pst.close();
        return recordCount;
    }

    public static final Contact retrieveUserContact(ActionContext context, int userId) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        if (ce == null) {
            return null;
        }
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        if (systemStatus == null) {
            return null;
        }
        User thisUser = systemStatus.getUser(userId);
        if (thisUser != null) {
            Contact thisContact = thisUser.getContact();
            return thisContact;
        }
        return null;
    }

    public static UserList sortEnabledUsers(UserList inList, UserList currentList) {
        int counter = 0;
        for (User thisUser : inList) {
            if (thisUser.getHidden()) continue;
            if (thisUser.getEnabled()) {
                currentList.add(counter++, thisUser);
                continue;
            }
            currentList.add(thisUser);
        }
        return currentList;
    }

    public int getUserIdByName(String name) {
        int result = -1;
        Object str = null;
        String[] names = StringUtils.getFirstLastNames(name);
        for (User thisUser : this) {
            Contact contact = thisUser.getContact();
            if (!ContactUtils.checkNameMatch(contact.getNameLastFirst(), names[1], names[0])) continue;
            result = thisUser.getId();
            break;
        }
        return result;
    }

    public User getUserById(int userId) {
        User result = null;
        for (User thisUser : this) {
            if (thisUser.getId() != userId) continue;
            result = thisUser;
            break;
        }
        return result;
    }
}

