/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.utils.DatabaseUtils;

public class UserPermissionList
extends Vector {
    private int roleId = -1;

    public UserPermissionList() {
    }

    public UserPermissionList(Connection db, int roleId) throws SQLException {
        this.roleId = roleId;
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT p.*, c.category, role_add, role_view, role_edit, role_delete FROM permission p, permission_category c, role_permission r WHERE p.category_id = c.category_id AND p.permission_id = r.permission_id ");
        sqlOrder.append("ORDER BY role_id, c." + DatabaseUtils.addQuotes(db, "level") + ", p." + DatabaseUtils.addQuotes(db, "level") + " ");
        this.createFilter(sqlFilter);
        sqlFilter.append("AND p.enabled = ? ");
        sqlFilter.append("AND c.enabled = ? ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        pst.setBoolean(++items, true);
        pst.setBoolean(++items, true);
        rs = pst.executeQuery();
        while (rs.next()) {
            Permission thisPermission = new Permission(rs);
            thisPermission.setAdd(rs.getBoolean("role_add"));
            thisPermission.setView(rs.getBoolean("role_view"));
            thisPermission.setEdit(rs.getBoolean("role_edit"));
            thisPermission.setDelete(rs.getBoolean("role_delete"));
            this.addElement(thisPermission);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.roleId > -1) {
            sqlFilter.append("AND r.role_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.roleId > -1) {
            pst.setInt(++i, this.roleId);
        }
        return i;
    }
}

