/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.ViewpointPermissionList;
import org.aspcfs.utils.DatabaseUtils;

public class Viewpoint
extends GenericBean {
    private int id = -1;
    private int userId = -1;
    private int vpUserId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private User vpUser = null;
    private ViewpointPermissionList permissionList = new ViewpointPermissionList();

    public Viewpoint() {
    }

    public Viewpoint(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Viewpoint(Connection db, int viewpointId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM viewpoint WHERE viewpoint_id = ? ");
        pst.setInt(1, viewpointId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Viewpoint record not found.");
        }
        this.buildResources(db);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserId(String userId) {
        this.userId = Integer.parseInt(userId);
    }

    public void setVpUserId(int vpUserId) {
        this.vpUserId = vpUserId;
    }

    public void setVpUserId(String vpUserId) {
        this.vpUserId = Integer.parseInt(vpUserId);
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setEnteredBy(String enteredBy) {
        this.enteredBy = Integer.parseInt(enteredBy);
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = Integer.parseInt(modifiedBy);
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setModified(String modified) {
        this.modified = DatabaseUtils.parseTimestamp(modified);
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setEntered(String entered) {
        this.entered = DatabaseUtils.parseTimestamp(entered);
    }

    public void setVpUser(User vpUser) {
        this.vpUser = vpUser;
    }

    public void setRequestItems(HttpServletRequest request) {
        this.permissionList = new ViewpointPermissionList(request);
        if (request.getParameter("enabled") == null) {
            this.enabled = false;
        }
    }

    public void buildVpUserDetails(Connection db) throws SQLException {
        if (this.vpUserId == -1) {
            throw new SQLException("Id not specified");
        }
        this.vpUser = new User();
        this.vpUser.setBuildContact(true);
        this.vpUser.buildRecord(db, this.vpUserId);
    }

    public void setPermissionList(ViewpointPermissionList permissionList) {
        this.permissionList = permissionList;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = DatabaseUtils.parseBoolean(enabled);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public ViewpointPermissionList getPermissionList() {
        return this.permissionList;
    }

    public User getVpUser() {
        return this.vpUser;
    }

    public int getId() {
        return this.id;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getVpUserId() {
        return this.vpUserId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public boolean isVpUserValid(Connection db) throws SQLException {
        return this.vpUserId != -1;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "viewpoint_viewpoint_id_seq");
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO viewpoint ");
            sql.append("(user_id, vp_user_id, enteredby, ");
            if (this.id > -1) {
                sql.append("viewpoint_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("modifiedby) ");
            sql.append("VALUES (?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.userId);
            DatabaseUtils.setInt(pst, ++i, this.vpUserId);
            pst.setInt(++i, this.enteredBy);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.modifiedBy);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "viewpoint_viewpoint_id_seq", this.id);
            this.insertPermissions(db);
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE viewpoint SET vp_user_id = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP, enabled = ? WHERE viewpoint_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst.setInt(++i, this.vpUserId);
        pst.setInt(++i, this.getModifiedBy());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getId());
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        this.deletePermissions(db);
        this.insertPermissions(db);
        return resultCount;
    }

    private void deletePermissions(Connection db) throws SQLException {
        boolean commit = false;
        try {
            int i = 0;
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM viewpoint_permission WHERE viewpoint_id = ? ");
            pst.setInt(++i, this.id);
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    private void insertPermissions(Connection db) throws SQLException {
        Iterator ipermission = this.permissionList.keySet().iterator();
        while (ipermission.hasNext()) {
            Permission thisPermission = (Permission)((Object)this.permissionList.get((String)ipermission.next()));
            if (!thisPermission.getEnabled()) continue;
            this.addPermission(db, thisPermission.getId(), thisPermission.getAdd(), thisPermission.getView(), thisPermission.getEdit(), thisPermission.getDelete());
        }
    }

    public void addPermission(Connection db, int permissionId, boolean add, boolean view, boolean edit, boolean delete) throws SQLException {
        int viewpointPermissionId = DatabaseUtils.getNextSeq(db, "viewpoint_per_vp_permission_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO viewpoint_permission (" + (viewpointPermissionId > -1 ? "vp_permission_id, " : "") + "viewpoint_id, permission_id, viewpoint_add, viewpoint_view, viewpoint_edit, viewpoint_delete) " + "VALUES (" + (viewpointPermissionId > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ? ) ");
        int i = 0;
        if (viewpointPermissionId > -1) {
            pst.setInt(++i, viewpointPermissionId);
        }
        pst.setInt(++i, this.getId());
        pst.setInt(++i, permissionId);
        pst.setBoolean(++i, add);
        pst.setBoolean(++i, view);
        pst.setBoolean(++i, edit);
        pst.setBoolean(++i, delete);
        pst.execute();
        pst.close();
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int recordCount = 0;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.deletePermissions(db);
            PreparedStatement pst = db.prepareStatement("DELETE FROM viewpoint WHERE viewpoint_id = ? ");
            pst.setInt(1, this.id);
            recordCount = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return recordCount != 0;
    }

    private void buildResources(Connection db) throws SQLException {
        this.permissionList = new ViewpointPermissionList(db, this.id);
        this.buildVpUserDetails(db);
    }

    public void buildPermissions(Connection db) throws SQLException {
        this.permissionList = new ViewpointPermissionList(db, this.id);
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("viewpoint_id");
        this.userId = rs.getInt("user_id");
        this.vpUserId = rs.getInt("vp_user_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
    }
}

