/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.admin.base.Viewpoint;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ViewpointList
extends ArrayList {
    public static final String tableName = "viewpoint";
    public static final String uniqueField = "viewpoint_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int enteredBy = -1;
    private int userId = -1;
    private int vpUserId = -1;
    private boolean includeEnabledOnly = false;
    private PagedListInfo pagedListInfo = null;
    private boolean buildResources = false;

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setVpUserId(int vpUserId) {
        this.vpUserId = vpUserId;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setBuildResources(boolean buildResources) {
        this.buildResources = buildResources;
    }

    public void setIncludeEnabledOnly(boolean includeEnabledOnly) {
        this.includeEnabledOnly = includeEnabledOnly;
    }

    public boolean getIncludeEnabledOnly() {
        return this.includeEnabledOnly;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getVpUserId() {
        return this.vpUserId;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM viewpoint vp LEFT JOIN contact c ON c.user_id = vp.vp_user_id WHERE vp.viewpoint_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND (" + DatabaseUtils.toLowerCase(db) + "(c.namelast) < ? AND c.namelast IS NOT NULL) ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("c.namelast", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.namelast ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("vp.viewpoint_id, vp.user_id, vp.vp_user_id, vp.entered, vp.enteredby, vp.modified, vp.modifiedby, vp.enabled FROM viewpoint vp LEFT JOIN contact c ON c.user_id = vp.vp_user_id WHERE vp.viewpoint_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Viewpoint thisViewpoint = new Viewpoint(rs);
            this.add(thisViewpoint);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (Viewpoint thisViewpoint : this) {
                thisViewpoint.buildVpUserDetails(db);
                thisViewpoint.buildPermissions(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND vp.enteredby = ? ");
        }
        if (this.userId != -1) {
            sqlFilter.append("AND vp.user_id = ? ");
        }
        if (this.includeEnabledOnly) {
            sqlFilter.append("AND vp.enabled = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.userId != -1) {
            pst.setInt(++i, this.userId);
        }
        if (this.includeEnabledOnly) {
            pst.setBoolean(++i, true);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public int checkForDuplicates(int id) {
        int result = 0;
        for (Viewpoint viewpoint : this) {
            if (viewpoint.getVpUserId() != id) continue;
            ++result;
        }
        return result;
    }
}

