/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class ViewpointPermission
extends GenericBean {
    private int id = -1;
    private int viewpointId = -1;
    private int permissionId = -1;
    private boolean add = false;
    private boolean view = false;
    private boolean edit = false;
    private boolean delete = false;

    public ViewpointPermission() {
    }

    public ViewpointPermission(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ViewpointPermission(Connection db, int thisId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM viewpoint_permission vp WHERE vp.vp_permission_id = ? ");
        pst.setInt(1, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("ViewpointPermission record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setViewpointId(int tmp) {
        this.viewpointId = tmp;
    }

    public void setViewpointId(String tmp) {
        this.viewpointId = Integer.parseInt(tmp);
    }

    public void setPermissionId(int tmp) {
        this.permissionId = tmp;
    }

    public void setPermissionId(String tmp) {
        this.permissionId = Integer.parseInt(tmp);
    }

    public void setAdd(boolean tmp) {
        this.add = tmp;
    }

    public void setAdd(String tmp) {
        this.add = DatabaseUtils.parseBoolean(tmp);
    }

    public void setView(boolean tmp) {
        this.view = tmp;
    }

    public void setView(String tmp) {
        this.view = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEdit(boolean tmp) {
        this.edit = tmp;
    }

    public void setEdit(String tmp) {
        this.edit = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDelete(boolean tmp) {
        this.delete = tmp;
    }

    public void setDelete(String tmp) {
        this.delete = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getViewpointId() {
        return this.viewpointId;
    }

    public int getPermissionId() {
        return this.permissionId;
    }

    public boolean getAdd() {
        return this.add;
    }

    public boolean getView() {
        return this.view;
    }

    public boolean getEdit() {
        return this.edit;
    }

    public boolean getDelete() {
        return this.delete;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("vp_permission_id");
        this.viewpointId = rs.getInt("viewpoint_id");
        this.permissionId = rs.getInt("permission_id");
        this.view = rs.getBoolean("viewpoint_view");
        this.add = rs.getBoolean("viewpoint_add");
        this.edit = rs.getBoolean("viewpoint_edit");
        this.delete = rs.getBoolean("viewpoint_delete");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "viewpoint_per_vp_permission_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO viewpoint_permission (" + (this.id > -1 ? "vp_permission_id, " : "") + "viewpoint_id, permission_id, viewpoint_view, " + "viewpoint_add, viewpoint_edit, viewpoint_delete) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.viewpointId);
        pst.setInt(++i, this.permissionId);
        pst.setBoolean(++i, this.view);
        pst.setBoolean(++i, this.add);
        pst.setBoolean(++i, this.edit);
        pst.setBoolean(++i, this.delete);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "viewpoint_per_vp_permission_seq", this.id);
        return true;
    }
}

