/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.jobs;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.CFSDatabaseReader;
import org.aspcfs.apps.transfer.reader.cfsdatabasereader.PropertyMapList;
import org.aspcfs.apps.transfer.writer.CFSXMLWriter;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.SiteUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.StatefulJob;

public class BackupCentricJob
implements StatefulJob {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        ConnectionPool cp = null;
        Connection db = null;
        Map config = null;
        try {
            schedulerContext = context.getScheduler().getContext();
            ApplicationPrefs prefs = (ApplicationPrefs)schedulerContext.get((Object)"ApplicationPrefs");
            cp = (ConnectionPool)schedulerContext.get((Object)"ConnectionPool");
            config = prefs.getPrefs();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("BackupJob-> Starting system backup...");
            }
            SiteList siteList = SiteUtils.getSiteList(prefs, cp);
            for (Site thisSite : siteList) {
                db = cp.getConnection(thisSite.getConnectionElement());
                String objectMappings = null;
                String backupXML = null;
                if (config.containsKey("WEB-INF")) {
                    objectMappings = (String)config.get("WEB-INF") + "cfs-import-mappings.xml";
                    backupXML = (String)config.get("WEB-INF") + "cfs-backup-data.xml";
                }
                CFSDatabaseReader reader = new CFSDatabaseReader();
                ArrayList modules = new ArrayList();
                PropertyMapList mappings = new PropertyMapList(objectMappings, modules);
                CFSXMLWriter writer = new CFSXMLWriter();
                writer.setFilename(backupXML);
                reader.executeJob(db, writer);
                cp.free(db);
                db = null;
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            if (cp != null && db != null) {
                cp.free(db);
            }
        }
    }
}

