/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.jobs;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.modules.website.base.WebPageAccessLog;
import org.aspcfs.modules.website.base.WebProductAccessLog;
import org.aspcfs.modules.website.base.WebProductEmailLog;
import org.aspcfs.utils.SiteUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.StatefulJob;

public class LoggerJob
implements StatefulJob {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        ConnectionPool cp = null;
        Connection db = null;
        try {
            schedulerContext = context.getScheduler().getContext();
            ApplicationPrefs prefs = (ApplicationPrefs)schedulerContext.get((Object)"ApplicationPrefs");
            cp = (ConnectionPool)schedulerContext.get((Object)"ConnectionPool");
            Hashtable systemStatusList = (Hashtable)schedulerContext.get((Object)"SystemStatus");
            SiteList siteList = SiteUtils.getSiteList(prefs, cp);
            for (Site thisSite : siteList) {
                Vector webProductEmailLogList;
                Vector webProductAccessLogList;
                SystemStatus thisSystem = (SystemStatus)systemStatusList.get(thisSite.getConnectionElement().getUrl());
                if (thisSite == null) continue;
                db = cp.getConnection(thisSite.getConnectionElement());
                Vector webPageAccessLogList = (Vector)schedulerContext.get((Object)"webPageAccessLog");
                if (webPageAccessLogList.size() > 0) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("LoggerJob-> Logging site access at " + new Timestamp(Calendar.getInstance().getTimeInMillis()).toString());
                    }
                    Iterator itr = webPageAccessLogList.iterator();
                    PreparedStatement pst = WebPageAccessLog.prepareInsert(db);
                    while (itr.hasNext()) {
                        WebPageAccessLog webPageAccessLog = (WebPageAccessLog)((Object)itr.next());
                        webPageAccessLog.insert(db);
                        itr.remove();
                    }
                    WebPageAccessLog.closeInsert(pst);
                }
                if ((webProductAccessLogList = (Vector)schedulerContext.get((Object)"webProductAccessLog")).size() > 0) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("LoggerJob-> Logging product access at " + new Timestamp(Calendar.getInstance().getTimeInMillis()).toString());
                    }
                    Iterator itr = webProductAccessLogList.iterator();
                    PreparedStatement pst = WebProductAccessLog.prepareInsert(db);
                    while (itr.hasNext()) {
                        WebProductAccessLog webProductAccessLog = (WebProductAccessLog)((Object)itr.next());
                        webProductAccessLog.insertData(pst);
                        itr.remove();
                    }
                    WebProductAccessLog.closeInsert(pst);
                }
                if ((webProductEmailLogList = (Vector)schedulerContext.get((Object)"webProductEmailLog")).size() > 0) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("LoggerJob-> Logging product email access at " + new Timestamp(Calendar.getInstance().getTimeInMillis()).toString());
                    }
                    Iterator itr = webProductEmailLogList.iterator();
                    PreparedStatement pst = WebProductEmailLog.prepareInsert(db);
                    while (itr.hasNext()) {
                        WebProductEmailLog webProductEmailLog = (WebProductEmailLog)((Object)itr.next());
                        webProductEmailLog.insertData(pst);
                        itr.remove();
                    }
                    WebProductEmailLog.closeInsert(pst);
                }
                cp.free(db);
                db = null;
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            if (cp != null && db != null) {
                cp.free(db);
            }
        }
    }
}

