/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.jobs;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import org.aspcfs.apps.notifier.Notifier;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.SiteUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.StatefulJob;

public class NotifierJob
implements StatefulJob {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        ConnectionPool cp = null;
        Connection db = null;
        try {
            schedulerContext = context.getScheduler().getContext();
            ApplicationPrefs prefs = (ApplicationPrefs)schedulerContext.get((Object)"ApplicationPrefs");
            cp = (ConnectionPool)schedulerContext.get((Object)"ConnectionPool");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("NotifierJob-> Checking for notifications...");
            }
            SiteList siteList = SiteUtils.getSiteList(prefs, cp);
            Notifier notifier = new Notifier();
            notifier.setConfig(prefs.getPrefs());
            for (Site thisSite : siteList) {
                db = cp.getConnection(thisSite.getConnectionElement());
                notifier.buildOpportunityAlerts(db, thisSite);
                cp.renew(db);
                notifier.buildCommunications(db, thisSite, cp);
                cp.renew(db);
                notifier.buildCallAlerts(db, thisSite);
                cp.free(db);
                db = null;
            }
            notifier = null;
            if (cp == null) return;
            if (db == null) return;
        }
        catch (Exception e) {
            try {
                throw new JobExecutionException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (cp == null || db == null) throw throwable;
                cp.free(db);
                throw throwable;
            }
        }
        cp.free(db);
        return;
    }
}

