/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.admin.jobs;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.util.Hashtable;
import org.aspcfs.apps.users.task.ProcessUserCleanup;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.SiteUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.StatefulJob;

public class UserCleanupJob
implements StatefulJob {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        ConnectionPool cp = null;
        Connection db = null;
        try {
            schedulerContext = context.getScheduler().getContext();
            ApplicationPrefs prefs = (ApplicationPrefs)schedulerContext.get((Object)"ApplicationPrefs");
            cp = (ConnectionPool)schedulerContext.get((Object)"ConnectionPool");
            Hashtable systemStatusList = (Hashtable)schedulerContext.get((Object)"SystemStatus");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("UserCleanupJob-> Cleaning up removed users...");
            }
            SiteList siteList = SiteUtils.getSiteList(prefs, cp);
            for (Site thisSite : siteList) {
                SystemStatus thisSystem = (SystemStatus)systemStatusList.get(thisSite.getConnectionElement().getUrl());
                db = cp.getConnection(thisSite.getConnectionElement());
                ProcessUserCleanup userCleanup = new ProcessUserCleanup(db, thisSystem);
                userCleanup = null;
                cp.free(db);
                db = null;
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            if (cp != null && db != null) {
                cp.free(db);
            }
        }
    }
}

