/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.assets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.assets.base.AssetMaterial;
import org.aspcfs.modules.assets.base.AssetMaterialList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;

public class Asset
extends GenericBean {
    private int id = -1;
    private int contractId = -1;
    private String serviceContractNumber = null;
    private int orgId = -1;
    private Timestamp dateListed = null;
    private String assetTag = null;
    private int status = -1;
    private String location = null;
    private int level1 = -1;
    private int level2 = -1;
    private int level3 = -1;
    private String serialNumber = null;
    private String modelVersion = null;
    private String description = null;
    private Timestamp expirationDate = null;
    private String inclusions = null;
    private String exclusions = null;
    private Timestamp purchaseDate = null;
    private double purchaseCost = -1.0;
    private String poNumber = null;
    private String purchasedFrom = null;
    private int contactId = -1;
    private String notes = null;
    private int responseTime = -1;
    private int telephoneResponseModel = -1;
    private int onsiteResponseModel = -1;
    private int emailResponseModel = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private boolean override = false;
    private String dateListedTimeZone = null;
    private String expirationDateTimeZone = null;
    private String purchaseDateTimeZone = null;
    private String statusName = null;
    private Timestamp trashedDate = null;
    private int parentId = -1;
    private boolean buildMaterials = false;
    private AssetMaterialList materials = new AssetMaterialList();
    private boolean buildCompleteHierarchy = false;
    private AssetList childList = null;
    private AssetList parentList = null;
    private boolean buildCompleteParentList = false;
    private boolean includeMe = false;
    private boolean buildChildList = false;
    private int vendorCode = -1;
    private int manufacturerCode = -1;

    public Asset() {
        this.errors.clear();
    }

    public Asset(Connection db, String tmpId) throws SQLException {
        this.errors.clear();
        this.queryRecord(db, Integer.parseInt(tmpId));
    }

    public Asset(ResultSet rs) throws SQLException {
        this.errors.clear();
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setContractId(int tmp) {
        this.contractId = tmp;
    }

    public void setContractId(String tmp) {
        this.contractId = Integer.parseInt(tmp);
    }

    public void setServiceContractNumber(String tmp) {
        this.serviceContractNumber = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setDateListed(Timestamp tmp) {
        this.dateListed = tmp;
    }

    public void setDateListed(String tmp) {
        this.dateListed = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setAssetTag(String tmp) {
        this.assetTag = tmp;
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setLocation(String tmp) {
        this.location = tmp;
    }

    public void setLevel1(int tmp) {
        this.level1 = tmp;
    }

    public void setLevel1(String tmp) {
        this.level1 = Integer.parseInt(tmp);
    }

    public void setLevel2(int tmp) {
        this.level2 = tmp;
    }

    public void setLevel2(String tmp) {
        this.level2 = Integer.parseInt(tmp);
    }

    public void setLevel3(int tmp) {
        this.level3 = tmp;
    }

    public void setLevel3(String tmp) {
        this.level3 = Integer.parseInt(tmp);
    }

    public void setSerialNumber(String tmp) {
        this.serialNumber = tmp;
    }

    public void setModelVersion(String tmp) {
        this.modelVersion = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setExpirationDate(String tmp) {
        this.expirationDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setInclusions(String tmp) {
        this.inclusions = tmp;
    }

    public void setExclusions(String tmp) {
        this.exclusions = tmp;
    }

    public void setPurchaseDate(Timestamp tmp) {
        this.purchaseDate = tmp;
    }

    public void setPurchaseDate(String tmp) {
        this.purchaseDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setPurchaseCost(String tmp) {
        this.purchaseCost = Double.parseDouble(tmp);
    }

    public void setPurchaseCost(double tmp) {
        this.purchaseCost = tmp;
    }

    public void setPoNumber(String tmp) {
        this.poNumber = tmp;
    }

    public void setPurchasedFrom(String tmp) {
        this.purchasedFrom = tmp;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setResponseTime(int tmp) {
        this.responseTime = tmp;
    }

    public void setResponseTime(String tmp) {
        this.responseTime = Integer.parseInt(tmp);
    }

    public void setTelephoneResponseModel(int tmp) {
        this.telephoneResponseModel = tmp;
    }

    public void setTelephoneResponseModel(String tmp) {
        this.telephoneResponseModel = Integer.parseInt(tmp);
    }

    public void setOnsiteResponseModel(int tmp) {
        this.onsiteResponseModel = tmp;
    }

    public void setOnsiteResponseModel(String tmp) {
        this.onsiteResponseModel = Integer.parseInt(tmp);
    }

    public void setEmailResponseModel(int tmp) {
        this.emailResponseModel = tmp;
    }

    public void setEmailResponseModel(String tmp) {
        this.emailResponseModel = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDateListedTimeZone(String tmp) {
        this.dateListedTimeZone = tmp;
    }

    public void setExpirationDateTimeZone(String tmp) {
        this.expirationDateTimeZone = tmp;
    }

    public void setPurchaseDateTimeZone(String tmp) {
        this.purchaseDateTimeZone = tmp;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public void setVendorCode(int tmp) {
        this.vendorCode = tmp;
    }

    public void setVendorCode(String tmp) {
        this.vendorCode = Integer.parseInt(tmp);
    }

    public void setManufacturerCode(int tmp) {
        this.manufacturerCode = tmp;
    }

    public void setManufacturerCode(String tmp) {
        this.manufacturerCode = Integer.parseInt(tmp);
    }

    public String getDateListedTimeZone() {
        return this.dateListedTimeZone;
    }

    public String getExpirationDateTimeZone() {
        return this.expirationDateTimeZone;
    }

    public String getPurchaseDateTimeZone() {
        return this.purchaseDateTimeZone;
    }

    public int getId() {
        return this.id;
    }

    public int getContractId() {
        return this.contractId;
    }

    public String getServiceContractNumber() {
        return this.serviceContractNumber;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public Timestamp getDateListed() {
        return this.dateListed;
    }

    public String getAssetTag() {
        return this.assetTag;
    }

    public int getStatus() {
        return this.status;
    }

    public String getLocation() {
        return this.location;
    }

    public int getLevel1() {
        return this.level1;
    }

    public int getLevel2() {
        return this.level2;
    }

    public int getLevel3() {
        return this.level3;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public String getInclusions() {
        return this.inclusions;
    }

    public String getExclusions() {
        return this.exclusions;
    }

    public Timestamp getPurchaseDate() {
        return this.purchaseDate;
    }

    public double getPurchaseCost() {
        return this.purchaseCost;
    }

    public String getPoNumber() {
        return this.poNumber;
    }

    public String getPurchasedFrom() {
        return this.purchasedFrom;
    }

    public int getContactId() {
        return this.contactId;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getResponseTime() {
        return this.responseTime;
    }

    public int getTelephoneResponseModel() {
        return this.telephoneResponseModel;
    }

    public int getOnsiteResponseModel() {
        return this.onsiteResponseModel;
    }

    public int getEmailResponseModel() {
        return this.emailResponseModel;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getVendorCode() {
        return this.vendorCode;
    }

    public int getManufacturerCode() {
        return this.manufacturerCode;
    }

    public boolean getOverride() {
        return this.override;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public void setStatusName(String tmp) {
        this.statusName = tmp;
    }

    public boolean getBuildMaterials() {
        return this.buildMaterials;
    }

    public void setBuildMaterials(boolean tmp) {
        this.buildMaterials = tmp;
    }

    public void setBuildMaterials(String tmp) {
        this.buildMaterials = DatabaseUtils.parseBoolean(tmp);
    }

    public AssetMaterialList getMaterials() {
        return this.materials;
    }

    public void setMaterials(AssetMaterialList tmp) {
        this.materials = tmp;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public boolean getBuildCompleteHierarchy() {
        return this.buildCompleteHierarchy;
    }

    public void setBuildCompleteHierarchy(boolean tmp) {
        this.buildCompleteHierarchy = tmp;
    }

    public void setBuildCompleteHierarchy(String tmp) {
        this.buildCompleteHierarchy = DatabaseUtils.parseBoolean(tmp);
    }

    public AssetList getChildList() {
        return this.childList;
    }

    public void setChildList(AssetList tmp) {
        this.childList = tmp;
    }

    public AssetList getParentList() {
        return this.parentList;
    }

    public void setParentList(AssetList tmp) {
        this.parentList = tmp;
    }

    public boolean getBuildCompleteParentList() {
        return this.buildCompleteParentList;
    }

    public void setBuildCompleteParentList(boolean tmp) {
        this.buildCompleteParentList = tmp;
    }

    public void setBuildCompleteParentList(String tmp) {
        this.buildCompleteParentList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeMe() {
        return this.includeMe;
    }

    public void setIncludeMe(boolean tmp) {
        this.includeMe = tmp;
    }

    public void setIncludeMe(String tmp) {
        this.includeMe = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildChildList() {
        return this.buildChildList;
    }

    public void setBuildChildList(boolean tmp) {
        this.buildChildList = tmp;
    }

    public void setBuildChildList(String tmp) {
        this.buildChildList = DatabaseUtils.parseBoolean(tmp);
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("dateListed");
        thisList.add("expirationDate");
        thisList.add("purchaseDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("purchaseCost");
        return thisList;
    }

    public void queryRecord(Connection db, int tmpAssetId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT a.*, sc.contract_number AS service_contract_number, las.description as status_name FROM asset a LEFT JOIN service_contract sc ON (a.contract_id = sc.contract_id) LEFT JOIN lookup_asset_status las ON (a.status = las.code) WHERE a.asset_id = ? ");
        pst.setInt(1, tmpAssetId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.buildMaterials) {
            this.buildMaterials(db);
        }
        if (this.buildChildList) {
            this.buildChildren(db);
        }
        if (this.buildCompleteHierarchy) {
            this.buildCompleteHierarchy(db);
        }
        if (this.buildCompleteParentList) {
            AssetList temp = this.buildCompleteParentList(db);
        }
    }

    public void buildChildren(Connection db) throws SQLException {
        this.childList = new AssetList();
        this.childList.setParentId(this.getId());
        this.childList.buildList(db);
    }

    public void buildCompleteHierarchy(Connection db) throws SQLException {
        this.childList = new AssetList();
        this.childList.setBuildCompleteHierarchy(this.getBuildCompleteHierarchy());
        this.childList.setParentId(this.getId());
        this.childList.buildList(db);
    }

    public AssetList buildCompleteParentList(Connection db) throws SQLException {
        if (this.parentId != -1) {
            this.parentList = new AssetList();
            Asset parent = new Asset();
            parent.setBuildCompleteParentList(true);
            parent.queryRecord(db, this.getParentId());
            AssetList tempList = parent.getParentList();
            if (tempList != null && tempList.size() > 0) {
                this.parentList.addAll(tempList);
            }
            this.parentList.add(parent);
        }
        if (this.includeMe) {
            if (this.parentList == null) {
                this.parentList = new AssetList();
            }
            this.parentList.add(this);
        }
        return this.parentList;
    }

    public void buildMaterials(Connection db) throws SQLException {
        if (this.materials == null) {
            this.materials = new AssetMaterialList();
        }
        this.materials.setAssetId(this.getId());
        this.materials.buildList(db);
    }

    public boolean insert(Connection db) throws SQLException {
        PreparedStatement pst = null;
        this.id = DatabaseUtils.getNextSeq(db, "asset_asset_id_seq");
        pst = db.prepareStatement("INSERT INTO asset (" + (this.id > -1 ? "asset_id, " : "") + "account_id," + "contract_id," + "parent_id, " + "date_listed," + "date_listed_timezone," + "asset_tag," + "status," + "location," + "level1," + "level2," + "level3," + "serial_number," + "model_version," + "description," + "expiration_date," + "expiration_date_timezone," + "inclusions," + "exclusions," + "purchase_date," + "purchase_date_timezone," + "purchase_cost," + "po_number," + "purchased_from," + "contact_id," + "notes," + "response_time," + "telephone_service_model," + "onsite_service_model," + "email_service_model," + "enteredby," + "modifiedby, " + "trashed_date, " + "vendor_code, " + "manufacturer_code )" + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.orgId);
        DatabaseUtils.setInt(pst, ++i, this.contractId);
        DatabaseUtils.setInt(pst, ++i, this.getParentId());
        DatabaseUtils.setTimestamp(pst, ++i, this.dateListed);
        pst.setString(++i, this.getDateListedTimeZone());
        pst.setString(++i, this.assetTag);
        DatabaseUtils.setInt(pst, ++i, this.status);
        pst.setString(++i, this.location);
        DatabaseUtils.setInt(pst, ++i, this.level1);
        DatabaseUtils.setInt(pst, ++i, this.level2);
        DatabaseUtils.setInt(pst, ++i, this.level3);
        pst.setString(++i, this.serialNumber);
        pst.setString(++i, this.modelVersion);
        pst.setString(++i, this.description);
        DatabaseUtils.setTimestamp(pst, ++i, this.expirationDate);
        pst.setString(++i, this.expirationDateTimeZone);
        pst.setString(++i, this.inclusions);
        pst.setString(++i, this.exclusions);
        DatabaseUtils.setTimestamp(pst, ++i, this.purchaseDate);
        pst.setString(++i, this.purchaseDateTimeZone);
        pst.setDouble(++i, this.purchaseCost);
        pst.setString(++i, this.poNumber);
        pst.setString(++i, this.purchasedFrom);
        DatabaseUtils.setInt(pst, ++i, this.contactId);
        pst.setString(++i, this.notes);
        DatabaseUtils.setInt(pst, ++i, this.responseTime);
        DatabaseUtils.setInt(pst, ++i, this.telephoneResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.onsiteResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.emailResponseModel);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
        DatabaseUtils.setInt(pst, ++i, this.vendorCode);
        DatabaseUtils.setInt(pst, ++i, this.manufacturerCode);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "asset_asset_id_seq", this.id);
        pst.close();
        if (this.materials != null && this.materials.size() > 0) {
            this.parseMaterials(db);
        }
        return true;
    }

    public boolean parseMaterials(Connection db) throws SQLException {
        AssetMaterialList oldList = new AssetMaterialList();
        oldList.setAssetId(this.getId());
        oldList.buildList(db);
        if (oldList.size() > 0) {
            HashMap oldMap = oldList.createMapOfElements();
            Iterator<Object> iter = null;
            if (this.materials != null) {
                iter = this.materials.iterator();
                while (iter.hasNext()) {
                    AssetMaterial material = (AssetMaterial)((Object)iter.next());
                    if (oldMap.get(new Integer(material.getCode())) == null) continue;
                    AssetMaterial oldMaterial = (AssetMaterial)((Object)oldMap.get(new Integer(material.getCode())));
                    if (oldMaterial.getQuantity() != material.getQuantity()) {
                        material.setId(oldMaterial.getId());
                    } else {
                        iter.remove();
                    }
                    oldMap.remove(new Integer(material.getCode()));
                }
            }
            iter = oldMap.keySet().iterator();
            while (iter.hasNext()) {
                AssetMaterial toRemove = (AssetMaterial)((Object)oldMap.get((Integer)iter.next()));
                toRemove.delete(db);
            }
        }
        if (this.materials != null) {
            this.materials.setAssetId(this.getId());
            this.materials.parseElements(db);
        }
        this.materials = new AssetMaterialList();
        this.materials.setAssetId(this.getId());
        this.materials.buildList(db);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE asset SET contract_id = ? , parent_id = ? , date_listed = ? , date_listed_timezone = ? , asset_tag = ? , status = ? , location = ? , level1 = ? , level2 = ? , level3 = ? , serial_number = ? , model_version = ? , description = ? , expiration_date = ? , expiration_date_timezone = ? , inclusions = ? , exclusions = ? , purchase_date = ? , purchase_date_timezone = ? , purchase_cost = ? , po_number = ? , purchased_from = ? , contact_id = ? , notes = ? , response_time = ? , telephone_service_model = ? , onsite_service_model = ? , email_service_model = ?, trashed_date = ?, vendor_code = ? , manufacturer_code = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE asset_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.contractId);
        DatabaseUtils.setInt(pst, ++i, this.getParentId());
        DatabaseUtils.setTimestamp(pst, ++i, this.dateListed);
        pst.setString(++i, this.dateListedTimeZone);
        pst.setString(++i, this.assetTag);
        DatabaseUtils.setInt(pst, ++i, this.status);
        pst.setString(++i, this.location);
        DatabaseUtils.setInt(pst, ++i, this.level1);
        DatabaseUtils.setInt(pst, ++i, this.level2);
        DatabaseUtils.setInt(pst, ++i, this.level3);
        pst.setString(++i, this.serialNumber);
        pst.setString(++i, this.modelVersion);
        pst.setString(++i, this.description);
        DatabaseUtils.setTimestamp(pst, ++i, this.expirationDate);
        pst.setString(++i, this.expirationDateTimeZone);
        pst.setString(++i, this.inclusions);
        pst.setString(++i, this.exclusions);
        DatabaseUtils.setTimestamp(pst, ++i, this.purchaseDate);
        pst.setString(++i, this.purchaseDateTimeZone);
        pst.setDouble(++i, this.purchaseCost);
        pst.setString(++i, this.poNumber);
        pst.setString(++i, this.purchasedFrom);
        DatabaseUtils.setInt(pst, ++i, this.contactId);
        pst.setString(++i, this.notes);
        DatabaseUtils.setInt(pst, ++i, this.responseTime);
        DatabaseUtils.setInt(pst, ++i, this.telephoneResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.onsiteResponseModel);
        DatabaseUtils.setInt(pst, ++i, this.emailResponseModel);
        DatabaseUtils.setTimestamp(pst, ++i, this.trashedDate);
        DatabaseUtils.setInt(pst, ++i, this.vendorCode);
        DatabaseUtils.setInt(pst, ++i, this.manufacturerCode);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        this.parseMaterials(db);
        return resultCount;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE asset SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE asset_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            pst.setInt(++i, tmpUserId);
            pst.setInt(++i, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
            this.buildCompleteHierarchy(db);
            this.childList.updateStatus(db, toTrash, tmpUserId);
            ContactHistory.trash(db, 8, this.getId(), !toTrash);
            TicketList ticketList = new TicketList();
            ticketList.setAssetId(this.getId());
            if (!toTrash) {
                ticketList.setIncludeOnlyTrashed(true);
            }
            ticketList.buildList(db);
            ticketList.updateStatus(db, toTrash, tmpUserId);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        try {
            Dependency ticDependency = new Dependency();
            ticDependency.setName("tickets");
            ticDependency.setCount(TicketList.retrieveRecordCount(db, 209041110, this.getId()));
            ticDependency.setCanDelete(false);
            dependencyList.add(ticDependency);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Asset Id not specified.");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            TicketList ticketList = new TicketList();
            ticketList.setAssetId(this.getId());
            ticketList.setIncludeOnlyTrashed(true);
            ticketList.buildList(db);
            ticketList.delete(db, baseFilePath);
            ticketList = null;
            ticketList = new TicketList();
            ticketList.setAssetId(this.getId());
            ticketList.setIncludeOnlyTrashed(false);
            ticketList.buildList(db);
            ticketList.delete(db, baseFilePath);
            ticketList = null;
            ContactHistory.deleteObject(db, 8, this.getId());
            this.materials = null;
            this.buildMaterials(db);
            if (this.materials != null && this.materials.size() > 0) {
                this.materials.delete(db);
            }
            this.buildChildren(db);
            this.getChildList().delete(db, baseFilePath);
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE FROM asset WHERE asset_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("asset_id");
        this.orgId = DatabaseUtils.getInt(rs, "account_id");
        this.contractId = DatabaseUtils.getInt(rs, "contract_id");
        this.dateListed = rs.getTimestamp("date_listed");
        this.assetTag = rs.getString("asset_tag");
        this.status = DatabaseUtils.getInt(rs, "status");
        this.location = rs.getString("location");
        this.level1 = DatabaseUtils.getInt(rs, "level1");
        this.level2 = DatabaseUtils.getInt(rs, "level2");
        this.level3 = DatabaseUtils.getInt(rs, "level3");
        this.serialNumber = rs.getString("serial_number");
        this.modelVersion = rs.getString("model_version");
        this.description = rs.getString("description");
        this.expirationDate = rs.getTimestamp("expiration_date");
        this.inclusions = rs.getString("inclusions");
        this.exclusions = rs.getString("exclusions");
        this.purchaseDate = rs.getTimestamp("purchase_date");
        this.poNumber = rs.getString("po_number");
        this.purchasedFrom = rs.getString("purchased_from");
        this.contactId = DatabaseUtils.getInt(rs, "contact_id");
        this.notes = rs.getString("notes");
        this.responseTime = DatabaseUtils.getInt(rs, "response_time");
        this.telephoneResponseModel = DatabaseUtils.getInt(rs, "telephone_service_model");
        this.onsiteResponseModel = DatabaseUtils.getInt(rs, "onsite_service_model");
        this.emailResponseModel = DatabaseUtils.getInt(rs, "email_service_model");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.purchaseCost = rs.getDouble("purchase_cost");
        this.dateListedTimeZone = rs.getString("date_listed_timezone");
        this.expirationDateTimeZone = rs.getString("expiration_date_timezone");
        this.purchaseDateTimeZone = rs.getString("purchase_date_timezone");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.setParentId(DatabaseUtils.getInt(rs, "parent_id"));
        this.vendorCode = DatabaseUtils.getInt(rs, "vendor_code");
        this.manufacturerCode = DatabaseUtils.getInt(rs, "manufacturer_code");
        this.serviceContractNumber = rs.getString("service_contract_number");
        this.statusName = rs.getString("status_name");
    }

    public String toString() {
        return this.getSerialNumber();
    }
}

