/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.assets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.assets.base.Asset;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class AssetList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int parentId = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int serviceContractId = -1;
    private String serviceContractNumber = null;
    private int enteredBy = -1;
    private String serialNumber = null;
    private boolean allAssets = true;
    private boolean skipParentIdRequirement = false;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private boolean buildCompleteHierarchy = false;

    public AssetList() {
    }

    public AssetList(Connection db) throws SQLException {
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setServiceContractId(int tmp) {
        this.serviceContractId = tmp;
    }

    public void setServiceContractId(String tmp) {
        this.serviceContractId = Integer.parseInt(tmp);
    }

    public void setServiceContractNumber(String tmp) {
        this.serviceContractNumber = tmp;
    }

    public void setSerialNumber(String tmp) {
        this.serialNumber = tmp;
    }

    public void setAllAssets(boolean tmp) {
        this.allAssets = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getServiceContractId() {
        return this.serviceContractId;
    }

    public String getServiceContractNumber() {
        return this.serviceContractNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean getAllAssets() {
        return this.allAssets;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public boolean getBuildCompleteHierarchy() {
        return this.buildCompleteHierarchy;
    }

    public void setBuildCompleteHierarchy(boolean tmp) {
        this.buildCompleteHierarchy = tmp;
    }

    public void setBuildCompleteHierarchy(String tmp) {
        this.buildCompleteHierarchy = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getSkipParentIdRequirement() {
        return this.skipParentIdRequirement;
    }

    public void setSkipParentIdRequirement(boolean tmp) {
        this.skipParentIdRequirement = tmp;
    }

    public void setSkipParentIdRequirement(String tmp) {
        this.skipParentIdRequirement = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Asset thisAsset = this.getObject(rs);
            this.add(thisAsset);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.buildCompleteHierarchy) {
            for (Asset asset : this) {
                asset.setBuildCompleteHierarchy(true);
                asset.buildCompleteHierarchy(db);
                if (asset.getChildList() == null) continue;
                this.addAll(asset.getChildList());
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM asset a LEFT JOIN service_contract sc ON (a.contract_id = sc.contract_id) LEFT JOIN lookup_asset_status las ON (a.status = las.code) WHERE asset_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("a.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY a.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("a.*, sc.contract_number AS service_contract_number, las.description AS status_name FROM asset a LEFT JOIN service_contract sc ON (a.contract_id = sc.contract_id) LEFT JOIN lookup_asset_status las ON (a.status = las.code) WHERE asset_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.parentId > -1) {
            sqlFilter.append("AND a.parent_id = ? ");
        } else if (!this.skipParentIdRequirement) {
            sqlFilter.append("AND a.parent_id IS NULL ");
        }
        if (this.enteredBy > -1) {
            sqlFilter.append("AND a.enteredby = ? ");
        }
        if (this.id > -1) {
            sqlFilter.append("AND a.asset_id = ? ");
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND a.account_id = ? ");
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND a.contact_id = ? ");
        }
        if (this.serviceContractId > -1) {
            sqlFilter.append("AND (a.contract_id = ? ");
            sqlFilter.append(this.allAssets ? "OR a.contract_id IS NULL)" : ")");
        } else {
            sqlFilter.append(this.allAssets ? " " : "AND a.contract_id IS NOT NULL ");
        }
        if (this.serialNumber != null) {
            if (this.serialNumber.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(a.serial_number) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(a.serial_number) = ? ");
            }
        }
        if (this.serviceContractNumber != null) {
            if (this.serviceContractNumber.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(sc.contract_number) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(sc.contract_number) = ? ");
            }
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND a.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND a.trashed_date = ? ");
        } else {
            sqlFilter.append("AND a.trashed_date IS NULL ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.parentId > -1) {
            DatabaseUtils.setInt(pst, ++i, this.parentId);
        }
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.serviceContractId > -1) {
            pst.setInt(++i, this.serviceContractId);
        }
        if (this.serialNumber != null) {
            pst.setString(++i, this.serialNumber.toLowerCase());
        }
        if (this.serviceContractNumber != null) {
            pst.setString(++i, this.serviceContractNumber.toLowerCase());
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        return i;
    }

    public Asset getObject(ResultSet rs) throws SQLException {
        Asset thisAsset = new Asset(rs);
        return thisAsset;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM asset a WHERE asset_id > 0 AND trashed_date IS NULL ");
        if (moduleId == 1) {
            sql.append("AND a.account_id = ?");
        }
        if (moduleId == 209041109) {
            sql.append("AND a.contract_id = ?");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
        }
        if (moduleId == 209041109) {
            pst.setInt(1, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        for (Asset tmpAsset : this) {
            tmpAsset.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }

    public void delete(Connection db, String baseFilePath) throws SQLException {
        for (Asset thisAsset : this) {
            thisAsset = new Asset(db, String.valueOf(thisAsset.getId()));
            if (this.getId() == -1) continue;
            thisAsset.delete(db, baseFilePath);
        }
    }
}

