/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.assets.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.utils.DatabaseUtils;

public class AssetMaterial
extends GenericBean {
    private int id = -1;
    private int assetId = -1;
    private int code = -1;
    private double quantity = 0.0;
    private Timestamp entered = null;
    private boolean canDelete = false;

    public AssetMaterial() {
    }

    public AssetMaterial(Connection db, String tmpId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(tmpId));
    }

    public AssetMaterial(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT amm.*  FROM asset_materials_map amm LEFT JOIN lookup_asset_materials lam ON (amm.code = lam.code) WHERE amm.map_id = ? ");
        pst.setInt(1, id);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("map_id");
        this.assetId = rs.getInt("asset_id");
        this.code = rs.getInt("code");
        this.quantity = rs.getDouble("quantity");
        this.entered = rs.getTimestamp("entered");
    }

    public boolean parse(Connection db) throws SQLException {
        if (this.canDelete && this.getId() > -1) {
            return this.delete(db);
        }
        PreparedStatement pst = null;
        Object rs = null;
        int i = 0;
        if (this.getId() > -1) {
            pst = db.prepareStatement("UPDATE asset_materials_map SET quantity = ? WHERE map_id = ? ");
            pst.setDouble(++i, this.quantity);
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            pst.close();
        } else {
            this.id = DatabaseUtils.getNextSeq(db, "asset_materials_map_map_id_seq");
            pst = db.prepareStatement("INSERT INTO asset_materials_map (" + (this.id > -1 ? "map_id," : "") + " asset_id, code, quantity) " + " VALUES (" + (this.getId() > -1 ? "?," : "") + "?,?,?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getAssetId());
            pst.setInt(++i, this.getCode());
            pst.setDouble(++i, this.getQuantity());
            pst.execute();
            pst.close();
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM asset_materials_map WHERE map_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean deleteAssetMaterials(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM asset_materials_map WHERE asset_id = ? ");
        pst.setInt(1, this.getAssetId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean setElement(String codeAndQuantity) {
        if (codeAndQuantity == null || "".equals(codeAndQuantity) || ",".equals(codeAndQuantity)) {
            return false;
        }
        String[] tmp = codeAndQuantity.split(",");
        this.code = Integer.parseInt(tmp[0]);
        this.quantity = Double.parseDouble(tmp[1]);
        return true;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("entered");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("quantity");
        return thisList;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int tmp) {
        this.assetId = tmp;
    }

    public void setAssetId(String tmp) {
        this.assetId = Integer.parseInt(tmp);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int tmp) {
        this.code = tmp;
    }

    public void setCode(String tmp) {
        this.code = Integer.parseInt(tmp);
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double tmp) {
        this.quantity = tmp;
    }

    public void setQuantity(String tmp) {
        this.quantity = Double.parseDouble(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean tmp) {
        this.canDelete = tmp;
    }

    public void setCanDelete(String tmp) {
        this.canDelete = DatabaseUtils.parseBoolean(tmp);
    }
}

