/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.assets.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.modules.assets.base.AssetMaterial;
import org.aspcfs.utils.web.PagedListInfo;

public class AssetMaterialList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int assetId = -1;
    private int code = -1;
    private double quantity = 0.0;
    private int qtyGT = -1;
    private int qtyEquals = -1;
    public static final String tableName = "lookup_asset_materials";
    public static final String uniqueField = "code";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public AssetMaterialList() {
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public AssetMaterialList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM asset_materials_map amm LEFT JOIN lookup_asset_materials lam ON (amm.code = lam.code) WHERE map_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("amm.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY amm.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("amm.* FROM asset_materials_map amm LEFT JOIN lookup_asset_materials lam ON (amm.code = lam.code) WHERE map_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            AssetMaterial thisAssetMaterial = new AssetMaterial(rs);
            this.add(thisAssetMaterial);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id > -1) {
            sqlFilter.append("AND amm.map_id = ? ");
        }
        if (this.assetId > -1) {
            sqlFilter.append("AND amm.asset_id = ? ");
        }
        if (this.code > -1) {
            sqlFilter.append("AND amm.code = ? ");
        }
        if (this.qtyGT == 1) {
            sqlFilter.append("AND amm.quantity >= ? ");
        } else if (this.qtyGT == 0) {
            sqlFilter.append("AND amm.quantity <= ? ");
        }
        if (this.qtyEquals == 1) {
            sqlFilter.append("AND amm.quantity = ? ");
        } else if (this.qtyEquals == 0) {
            sqlFilter.append("AND amm.quantity <> ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.assetId > -1) {
            pst.setInt(++i, this.assetId);
        }
        if (this.code > -1) {
            pst.setInt(++i, this.code);
        }
        if (this.qtyGT != -1) {
            pst.setDouble(++i, this.quantity);
        }
        if (this.qtyEquals != -1) {
            pst.setDouble(++i, this.quantity);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static HashMap getQuantityMap(String materials) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        StringTokenizer str = new StringTokenizer(materials, "|");
        while (str.hasMoreTokens()) {
            String tmp = str.nextToken();
            if (tmp == null || "".equals(tmp.trim())) continue;
            StringTokenizer str2 = new StringTokenizer(tmp, ",");
            Integer code = new Integer(str2.nextToken());
            map.put(code, str2.nextToken());
        }
        return map;
    }

    public void setElements(String materials) {
        StringTokenizer str = new StringTokenizer(materials, "|");
        while (str.hasMoreTokens()) {
            AssetMaterial material = new AssetMaterial();
            material.setAssetId(this.getAssetId());
            String temp = str.nextToken();
            if (temp == null || "".equals(temp)) continue;
            material.setElement(temp);
            this.add(material);
        }
    }

    public boolean delete(Connection db) throws SQLException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            AssetMaterial material = (AssetMaterial)((Object)iter.next());
            material.delete(db);
            iter.remove();
        }
        return true;
    }

    public void setElementsDeletable(boolean canDelete) {
        for (AssetMaterial material : this) {
            material.setCanDelete(canDelete);
        }
    }

    public HashMap createMapOfElements() {
        HashMap<Integer, AssetMaterial> map = new HashMap<Integer, AssetMaterial>();
        for (AssetMaterial material : this) {
            map.put(new Integer(material.getCode()), material);
        }
        return map;
    }

    public void parseElements(Connection db) throws SQLException {
        for (AssetMaterial material : this) {
            if (material.getAssetId() == -1) {
                material.setAssetId(this.getAssetId());
            }
            material.parse(db);
        }
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int tmp) {
        this.assetId = tmp;
    }

    public void setAssetId(String tmp) {
        this.assetId = Integer.parseInt(tmp);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int tmp) {
        this.code = tmp;
    }

    public void setCode(String tmp) {
        this.code = Integer.parseInt(tmp);
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double tmp) {
        this.quantity = tmp;
    }

    public void setQuantity(String tmp) {
        this.quantity = Double.parseDouble(tmp);
    }

    public int getQtyGT() {
        return this.qtyGT;
    }

    public void setQtyGT(int tmp) {
        this.qtyGT = tmp;
    }

    public void setQtyGT(String tmp) {
        this.qtyGT = Integer.parseInt(tmp);
    }

    public int getQtyEquals() {
        return this.qtyEquals;
    }

    public void setQtyEquals(int tmp) {
        this.qtyEquals = tmp;
    }

    public void setQtyEquals(String tmp) {
        this.qtyEquals = Integer.parseInt(tmp);
    }
}

