/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.StateSelect;

public class Address {
    protected boolean isContact = false;
    protected boolean isOrder = false;
    private int id = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int orderId = -1;
    private String streetAddressLine1 = "";
    private String streetAddressLine2 = "";
    private String streetAddressLine3 = "";
    private String streetAddressLine4 = "";
    private String city = null;
    private String state = null;
    private String otherState = null;
    private String zip = null;
    private String country = null;
    private String county = null;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private int type = -1;
    private String typeName = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private Date entered = null;
    private Date modified = null;
    private boolean primaryAddress = false;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = Integer.parseInt(orgId);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setStreetAddressLine3(String streetAddressLine3) {
        this.streetAddressLine3 = streetAddressLine3;
    }

    public void setStreetAddressLine4(String streetAddressLine4) {
        this.streetAddressLine4 = streetAddressLine4;
    }

    public void setOtherState(String tmp) {
        if (tmp != null) {
            this.otherState = tmp.length() == 0 ? null : tmp;
        }
    }

    public void setPrimaryAddress(boolean tmp) {
        this.primaryAddress = tmp;
    }

    public void setPrimaryAddress(String tmp) {
        this.primaryAddress = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getPrimaryAddress() {
        return this.primaryAddress;
    }

    public String getOtherState() {
        return this.otherState;
    }

    public String getStreetAddressLine3() {
        return this.streetAddressLine3;
    }

    public String getStreetAddressLine4() {
        return this.streetAddressLine4;
    }

    public int getContactId() {
        return this.contactId;
    }

    public String getCounty() {
        return this.county;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setStreetAddressLine1(String tmp) {
        this.streetAddressLine1 = tmp;
    }

    public void setStreetAddressLine2(String tmp) {
        this.streetAddressLine2 = tmp;
    }

    public void setCity(String tmp) {
        this.city = tmp;
    }

    public void setState(String tmp) {
        if (tmp != null) {
            this.state = tmp.length() == 0 ? null : tmp;
        }
    }

    public void setZip(String tmp) {
        this.zip = tmp;
    }

    public void setCountry(String tmp) {
        this.country = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public Timestamp getEntered() {
        return (Timestamp)this.entered;
    }

    public Timestamp getModified() {
        return (Timestamp)this.modified;
    }

    public String getStreetAddressLine1() {
        return this.streetAddressLine1;
    }

    public String getStreetAddressLine2() {
        return this.streetAddressLine2;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        StateSelect stateSelect = new StateSelect(this.country);
        if (stateSelect.hasCountry(this.country)) {
            return this.state;
        }
        if ("-1".equals(this.otherState)) {
            return "";
        }
        return this.otherState;
    }

    public String getCityState() {
        if (!(this.getCity() == null || this.getState() == null || this.getCity().equals("") || this.getState().equals("") || "-1".equals(this.getState()))) {
            return this.getCity() + ", " + this.getState();
        }
        if (!(this.getCity() != null && !"".equals(this.getCity()) || this.getState() == null || "".equals(this.getState()) || "-1".equals(this.getState()))) {
            return this.getState();
        }
        if ((this.getState() == null || "".equals(this.getState()) || "-1".equals(this.getState())) && this.getCity() != null && !"".equals(this.getCity())) {
            return this.getCity();
        }
        return "";
    }

    public String getZip() {
        return this.zip;
    }

    public String getCountry() {
        if (this.country == null || "-1".equals(this.country)) {
            return "";
        }
        return this.country;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setOrderId(String tmp) {
        this.orderId = Integer.parseInt(tmp);
    }

    public int getOrderId() {
        return this.orderId;
    }

    public boolean isValid() {
        if (this.type == -1) {
            return false;
        }
        return this.streetAddressLine1 != null && !this.streetAddressLine1.trim().equals("") || this.streetAddressLine2 != null && !this.streetAddressLine2.trim().equals("") || this.streetAddressLine3 != null && !this.streetAddressLine3.trim().equals("") || this.streetAddressLine4 != null && !this.streetAddressLine4.trim().equals("") || this.city != null && !this.city.trim().equals("") || this.state != null && !this.state.trim().equals("") && !"-1".equals(this.state) || this.zip != null && !this.zip.trim().equals("") || this.county != null && !this.county.trim().equals("") || this.latitude != 0.0 || this.longitude != 0.0;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEntered(Date tmp) {
        this.entered = tmp;
    }

    public void setModified(Date tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        try {
            this.latitude = Double.parseDouble(latitude);
        }
        catch (Exception e) {
            this.latitude = 0.0;
        }
    }

    public void setLongitude(String longitude) {
        try {
            this.longitude = Double.parseDouble(longitude);
        }
        catch (Exception e) {
            this.longitude = 0.0;
        }
    }

    public String toString() {
        StringBuffer thisAddress = new StringBuffer();
        if (this.getStreetAddressLine1() != null && !this.getStreetAddressLine1().trim().equals("")) {
            thisAddress.append(this.getStreetAddressLine1().trim() + "\r\n");
        }
        if (this.getStreetAddressLine2() != null && !this.getStreetAddressLine2().trim().equals("")) {
            thisAddress.append(this.getStreetAddressLine2().trim() + "\r\n");
        }
        if (this.getStreetAddressLine3() != null && !this.getStreetAddressLine3().trim().equals("")) {
            thisAddress.append(this.getStreetAddressLine3().trim() + "\r\n");
        }
        if (this.getStreetAddressLine4() != null && !this.getStreetAddressLine4().trim().equals("")) {
            thisAddress.append(this.getStreetAddressLine4().trim() + "\r\n");
        }
        if (!this.getCityState().trim().equals("")) {
            thisAddress.append(this.getCityState().trim() + "\r\n");
        }
        if (this.getZip() != null && !this.getZip().trim().equals("")) {
            thisAddress.append(this.getZip().trim() + "\r\n");
        }
        if (this.getCountry() != null && !this.getCountry().trim().equals("")) {
            thisAddress.append(this.getCountry().trim() + "\r\n");
        }
        if (this.getCounty() != null && !this.getCounty().trim().equals("")) {
            thisAddress.append("County: " + this.getCounty().trim() + "\r\n");
        }
        if (this.getLatitude() != 0.0) {
            thisAddress.append("Latitude: " + this.getLatitude() + "\r\n");
        }
        if (this.getLongitude() != 0.0) {
            thisAddress.append("Longitude: " + this.getLongitude() + "\r\n");
        }
        return thisAddress.toString();
    }

    public Locale getLocale() {
        if ("UNITED STATES".equals(this.country)) {
            return Locale.US;
        }
        if ("CANADA".equals(this.country)) {
            return Locale.CANADA;
        }
        if ("UNITED KINGDOM".equals(this.country)) {
            return Locale.UK;
        }
        return null;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("address_id"));
        if (this.isOrder) {
            this.setContactId(rs.getInt("contact_id"));
            if (rs.wasNull()) {
                this.setContactId(-1);
            }
        } else if (!this.isContact) {
            this.setOrgId(rs.getInt("org_id"));
            if (rs.wasNull()) {
                this.setOrgId(-1);
            }
        } else {
            this.setContactId(rs.getInt("contact_id"));
            if (rs.wasNull()) {
                this.setContactId(-1);
            }
        }
        this.setType(rs.getInt("address_type"));
        if (rs.wasNull()) {
            this.setType(-1);
        }
        this.setStreetAddressLine1(rs.getString("addrline1"));
        this.setStreetAddressLine2(rs.getString("addrline2"));
        this.setStreetAddressLine3(rs.getString("addrline3"));
        this.setStreetAddressLine4(rs.getString("addrline4"));
        this.setCity(rs.getString("city"));
        this.setState(rs.getString("state"));
        this.setOtherState(this.state);
        this.setZip(rs.getString("postalcode"));
        this.setCountry(rs.getString("country"));
        this.setCounty(rs.getString("county"));
        this.setLatitude(rs.getDouble("latitude"));
        this.setLongitude(rs.getDouble("longitude"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setEnteredBy(rs.getInt("enteredby"));
        if (this.getEnteredBy() == -1) {
            this.setEnteredBy(0);
        }
        this.setModified(rs.getTimestamp("modified"));
        this.setModifiedBy(rs.getInt("modifiedby"));
        if (this.getModifiedBy() == -1) {
            this.setModifiedBy(0);
        }
        this.setPrimaryAddress(rs.getBoolean("primary_address"));
        this.setTypeName(rs.getString("description"));
    }

    public void buildRecord(HttpServletRequest request, int parseItem) {
        String action;
        this.setType(request.getParameter("address" + parseItem + "type"));
        if (request.getParameter("address" + parseItem + "id") != null) {
            this.setId(request.getParameter("address" + parseItem + "id"));
        }
        String buffer = null;
        buffer = request.getParameter("address" + parseItem + "line1");
        if (buffer != null && !"".equals(buffer.trim())) {
            this.setStreetAddressLine1(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "line2")) != null && !"".equals(buffer.trim())) {
            this.setStreetAddressLine2(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "line3")) != null && !"".equals(buffer.trim())) {
            this.setStreetAddressLine3(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "line4")) != null && !"".equals(buffer.trim())) {
            this.setStreetAddressLine4(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "city")) != null && !"".equals(buffer.trim())) {
            this.setCity(buffer);
        }
        this.setCountry(request.getParameter("address" + parseItem + "country"));
        buffer = request.getParameter("address" + parseItem + "state");
        if (buffer != null && !"".equals(buffer.trim())) {
            this.setState(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "otherState")) != null && !"".equals(buffer.trim())) {
            this.setOtherState(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "zip")) != null && !"".equals(buffer.trim())) {
            this.setZip(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "county")) != null && !"".equals(buffer.trim())) {
            this.setCounty(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "latitude")) != null && !"".equals(buffer.trim())) {
            this.setLatitude(buffer);
        }
        if ((buffer = request.getParameter("address" + parseItem + "longitude")) != null && !"".equals(buffer.trim())) {
            this.setLongitude(buffer);
        }
        if (request.getParameter("address" + parseItem + "delete") != null && (action = request.getParameter("address" + parseItem + "delete").toLowerCase()).equals("on")) {
            this.setEnabled(false);
        }
        if (request.getParameter("addressprimary") != null) {
            String tmp = request.getParameter("addressprimary");
            if (Integer.parseInt(tmp) == parseItem) {
                this.setPrimaryAddress(true);
            } else {
                this.setPrimaryAddress(false);
            }
        }
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("enteredBy");
        thisList.add("modifiedBy");
        return thisList;
    }
}

