/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.base.Address;
import org.aspcfs.utils.web.PagedListInfo;

public class AddressList
extends Vector {
    protected PagedListInfo pagedListInfo = null;
    protected int orgId = -1;
    protected int type = -1;
    protected int contactId = -1;
    protected int orderId = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setOrderId(int tmp) {
        this.orderId = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public Address getAddress(String thisType) {
        for (Address thisAddress : this) {
            if (!thisType.equals(thisAddress.getTypeName())) continue;
            return thisAddress;
        }
        return new Address();
    }

    public Address getPrimaryAddress() {
        Iterator i = this.iterator();
        Address thisAddress = null;
        while (i.hasNext() && !(thisAddress = (Address)i.next()).getPrimaryAddress()) {
        }
        return thisAddress;
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND org_id = ? ");
        }
        if (this.type != -1) {
            sqlFilter.append("AND address_type = ? ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND contact_id = ? ");
        }
        if (this.orderId != -1) {
            sqlFilter.append("AND order_id = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.type != -1) {
            pst.setInt(++i, this.type);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.orderId != -1) {
            pst.setInt(++i, this.orderId);
        }
        return i;
    }

    public String getCountries() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Address thisAddress = (Address)iter.next();
            if (thisAddress.getCountry() == null) continue;
            result.append(thisAddress.getCountry() + (iter.hasNext() ? "," : ""));
        }
        return result.toString();
    }

    public HashMap getSelectedStatesHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Address thisAddress : this) {
            if (thisAddress.getCountry() == null) continue;
            map.put(thisAddress.getCountry(), thisAddress.getState());
        }
        return map;
    }
}

