/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftList;
import org.aspcfs.utils.DatabaseUtils;

public class Category
extends GenericBean {
    private int id = -1;
    private int categoryLevel = -1;
    private int parentCode = -1;
    private String description = "";
    private boolean enabled = true;
    private int level = -1;
    private int siteId = -1;
    private TicketCategoryDraftList shortChildList = new TicketCategoryDraftList();
    private String tableName = null;

    public Category() {
    }

    public Category(String tableName) {
        this.tableName = tableName;
    }

    public Category(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Category(Connection db, int id, String tableName) throws SQLException {
        if (id < 0) {
            throw new SQLException("Category not specified");
        }
        this.tableName = tableName;
        String sql = "SELECT c.* FROM " + tableName + " c " + "WHERE c.id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Category record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryLevel(int tmp) {
        this.categoryLevel = tmp;
    }

    public void setCategoryLevel(String tmp) {
        this.categoryLevel = Integer.parseInt(tmp);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLevel(String level) {
        this.level = Integer.parseInt(level);
    }

    public void setParentCode(int tmp) {
        this.parentCode = tmp;
    }

    public void setParentCode(String tmp) {
        this.parentCode = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setShortChildList(TicketCategoryDraftList shortChildList) {
        this.shortChildList = shortChildList;
    }

    public TicketCategoryDraftList getShortChildList() {
        return this.shortChildList;
    }

    public int getLevel() {
        return this.level;
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryLevel() {
        return this.categoryLevel;
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.tableName == null) {
            throw new SQLException("Category table not specified");
        }
        StringBuffer sql = new StringBuffer();
        try {
            this.id = DatabaseUtils.getNextSeq(db, this.tableName + "_id_seq");
            db.setAutoCommit(false);
            sql.append("INSERT INTO " + this.tableName + " " + "(" + (this.id > -1 ? "id, " : "") + "cat_level, parent_cat_code, description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled, site_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCategoryLevel());
            if (this.parentCode > 0) {
                pst.setInt(++i, this.getParentCode());
            } else {
                pst.setInt(++i, 0);
            }
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getLevel());
            pst.setBoolean(++i, this.getEnabled());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, this.tableName + "_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.tableName == null) {
            throw new SQLException("Category table not specified");
        }
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE " + this.tableName + " " + "SET description = ?, cat_level = ?, parent_cat_code = ?, " + DatabaseUtils.addQuotes(db, "level") + " = ?, enabled = ? " + "WHERE id = ? ");
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getCategoryLevel());
            pst.setInt(++i, this.getParentCode());
            pst.setInt(++i, this.getLevel());
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.categoryLevel = rs.getInt("cat_level");
        this.parentCode = rs.getInt("parent_cat_code");
        this.description = rs.getString("description");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
    }
}

