/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.StateSelect;

public class CustomField
extends GenericBean
implements Cloneable {
    public static final int TEXT = 1;
    public static final int SELECT = 2;
    public static final int TEXTAREA = 3;
    public static final int CHECKBOX = 4;
    public static final int BUTTON = 5;
    public static final int LABEL = 6;
    public static final int LINK = 7;
    public static final int DATE = 8;
    public static final int INTEGER = 9;
    public static final int FLOAT = 10;
    public static final int PERCENT = 11;
    public static final int CURRENCY = 12;
    public static final int EMAIL = 13;
    public static final int URL = 14;
    public static final int PHONE = 15;
    public static final int ROWLIST = 16;
    public static final int HIDDEN = 17;
    public static final int DISPLAYTEXT = 18;
    public static final int DISPLAYROWLIST = 20;
    public static final int LOOKUP_USERID = 21;
    public static final int HTMLAREA = 22;
    public static final int STATE_SELECT = 23;
    private int id = -1;
    private int groupId = -1;
    private String name = null;
    private String additionalText = null;
    private int level = -1;
    private int type = -1;
    private int validationType = -1;
    private boolean required = false;
    private Hashtable parameters = new Hashtable();
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean enabled = true;
    private String error = null;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int recordId = -1;
    private int selectedItemId = -1;
    private String enteredValue = null;
    private int enteredNumber = 0;
    private double enteredDouble = 0.0;
    private Object elementData = null;
    private String lookupList = null;
    private String listName = null;
    private String listItemName = null;
    private String jsEvent = null;
    private String onChange = null;
    private String display = null;
    private String lengthVar = null;
    private int maxRowItems = 0;
    private String delimiter = "\r\n";
    private boolean textAsCode = false;
    private boolean isStatic = false;
    private boolean validateData = false;

    public CustomField() {
    }

    public CustomField(Connection db, int thisId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM custom_field_info cf WHERE cf.field_id = ? ");
        pst.setInt(1, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getType() == 2) {
            this.buildElementData(db);
        }
    }

    public CustomField(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public boolean getValidateData() {
        return this.validateData;
    }

    public void setValidateData(boolean tmp) {
        this.validateData = tmp;
    }

    public void setValidateData(String tmp) {
        this.validateData = DatabaseUtils.parseBoolean(tmp);
    }

    public void setElementData(Object elementData) {
        this.elementData = elementData;
    }

    public CustomField(ResultSet rs, boolean populated) throws SQLException {
        if (populated) {
            this.buildPopulatedRecord(rs);
        }
        this.buildRecord(rs);
    }

    public void setTextAsCode(boolean textAsCode) {
        this.textAsCode = textAsCode;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public String getLengthVar() {
        return this.lengthVar;
    }

    public void setLengthVar(String lengthVar) {
        this.lengthVar = lengthVar;
    }

    public void setParameter(String parameterName, String value) {
        this.parameters.put(parameterName, value);
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public void setListItemName(String listItemName) {
        this.listItemName = listItemName;
    }

    public String getListItemName() {
        return this.listItemName;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean getTextAsCode() {
        return this.textAsCode;
    }

    public void setTextAsCode(String textAsCode) {
        this.textAsCode = textAsCode.equalsIgnoreCase("ON");
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public void setMaxRowItems(int maxRowItems) {
        this.maxRowItems = maxRowItems;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getListName() {
        return this.listName;
    }

    public int getMaxRowItems() {
        if (this.maxRowItems == 0) {
            try {
                return ((ArrayList)this.elementData).size();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.maxRowItems;
    }

    public void setMaxRowItems(String maxRowItems) {
        if (maxRowItems != null) {
            this.maxRowItems = Integer.parseInt(maxRowItems);
        }
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getDisplayHtml() {
        return StringUtils.toHtml(this.display);
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setAdditionalText(String additionalText) {
        this.additionalText = additionalText;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        block15: {
            try {
                this.type = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                if (tmp.equalsIgnoreCase("text")) {
                    this.type = 1;
                }
                if (tmp.equalsIgnoreCase("select")) {
                    this.type = 2;
                }
                if (tmp.equalsIgnoreCase("checkbox")) {
                    this.type = 4;
                }
                if (tmp.equalsIgnoreCase("textarea")) {
                    this.type = 3;
                }
                if (tmp.equalsIgnoreCase("htmlarea")) {
                    this.type = 22;
                }
                if (tmp.equalsIgnoreCase("rowlist")) {
                    this.type = 16;
                }
                if (tmp.equalsIgnoreCase("hidden")) {
                    this.type = 17;
                }
                if (tmp.equalsIgnoreCase("displaytext")) {
                    this.type = 18;
                }
                if (tmp.equalsIgnoreCase("lookupuserid")) {
                    this.type = 21;
                }
                if (tmp.equalsIgnoreCase("displayrowlist")) {
                    this.type = 20;
                }
                if (tmp.equalsIgnoreCase("button")) {
                    this.type = 5;
                }
                if (tmp.equalsIgnoreCase("label")) {
                    this.type = 6;
                }
                if (tmp.equalsIgnoreCase("link")) {
                    this.type = 7;
                }
                if (!tmp.equalsIgnoreCase("stateselect")) break block15;
                this.type = 23;
            }
        }
    }

    public void setValidationType(int tmp) {
        this.validationType = tmp;
    }

    public void setValidationType(String tmp) {
        this.validationType = Integer.parseInt(tmp);
    }

    public void setRequired(boolean tmp) {
        this.required = tmp;
    }

    public void setRequired(String tmp) {
        this.required = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DateUtils.parseTimestampString(tmp);
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DateUtils.parseTimestampString(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setError(String tmp) {
        this.error = tmp;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setRecordId(int tmp) {
        this.recordId = tmp;
    }

    public void setRecordId(String tmp) {
        this.recordId = Integer.parseInt(tmp);
    }

    public void setSelectedItemId(int tmp) {
        this.selectedItemId = tmp;
    }

    public void setSelectedItemId(String tmp) {
        if (tmp != null) {
            this.selectedItemId = tmp.equalsIgnoreCase("true") ? 1 : (tmp.equalsIgnoreCase("false") ? 0 : Integer.parseInt(tmp));
        }
    }

    public void setEnteredValue(String tmp) {
        this.enteredValue = tmp != null ? tmp.trim() : null;
    }

    public void setEnteredNumber(int tmp) {
        this.enteredNumber = tmp;
    }

    public void setEnteredDouble(double tmp) {
        this.enteredDouble = tmp;
    }

    public void setMaxLength(String tmp) {
        if (tmp != null && !tmp.equals("")) {
            this.parameters.put("maxlength", tmp);
        }
    }

    public boolean buildLookupList(Connection db, ActionContext context) throws SQLException {
        this.elementData = new LookupList();
        if (this.lookupList != null && !this.lookupList.equals("")) {
            ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
            this.elementData = ((SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl())).getLookupList(db, this.lookupList);
        }
        return true;
    }

    public void setParameters(ActionContext context) {
        String newValue = null;
        if (context.getRequest().getParameter("cf" + this.id) != null) {
            newValue = context.getRequest().getParameter("cf" + this.id);
        } else if (context.getRequest().getAttribute("cf" + this.id) != null) {
            newValue = (String)context.getRequest().getAttribute("cf" + this.id);
        }
        if (newValue != null) {
            newValue = newValue.trim();
            switch (this.type) {
                case 2: {
                    this.selectedItemId = Integer.parseInt(newValue);
                    this.enteredValue = ((LookupList)this.elementData).getSelectedValue(this.selectedItemId);
                    break;
                }
                case 4: {
                    if ("ON".equalsIgnoreCase(newValue)) {
                        this.selectedItemId = 1;
                        this.enteredValue = "Yes";
                        break;
                    }
                    this.selectedItemId = 0;
                    this.enteredValue = "No";
                    break;
                }
                case 23: {
                    if ("-1".equals(newValue)) {
                        this.enteredValue = "--";
                        break;
                    }
                    this.enteredValue = newValue;
                    break;
                }
                default: {
                    this.enteredValue = newValue;
                    break;
                }
            }
        } else if (this.enabled && this.type == 4) {
            this.selectedItemId = 0;
            this.enteredValue = "No";
        }
    }

    public void setParameters(String param) {
        StringTokenizer st = new StringTokenizer(param, "^");
        while (st.hasMoreTokens()) {
            StringTokenizer kv = new StringTokenizer(st.nextToken(), "|");
            if (!kv.hasMoreTokens()) continue;
            this.parameters.put(kv.nextToken(), kv.nextToken());
        }
    }

    public void setJsEvent(String jsEvent) {
        this.jsEvent = jsEvent;
    }

    public void setIsStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setLookupList(String tmp) {
        this.lookupList = tmp;
    }

    public void setLookupListText(String tmp) {
        this.elementData = new LookupList();
        int count = 0;
        StringTokenizer st = new StringTokenizer(tmp, this.delimiter);
        while (st.hasMoreTokens()) {
            String listField = st.nextToken();
            if (listField.trim().equals("")) continue;
            ++count;
            LookupElement thisElement = new LookupElement();
            thisElement.setDescription(listField.trim());
            if (this.textAsCode) {
                thisElement.setCode(Integer.parseInt(thisElement.getDescription()));
            } else {
                thisElement.setCode(count);
            }
            thisElement.setLevel(count);
            thisElement.setDefaultItem(false);
            ((LookupList)this.elementData).add(thisElement);
        }
    }

    public double getEnteredDouble() {
        return this.enteredDouble;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public String getLookupList() {
        return this.lookupList;
    }

    public String getLookupListText() {
        StringBuffer sb = new StringBuffer();
        if (this.elementData != null) {
            Iterator i = ((LookupList)this.elementData).iterator();
            while (i.hasNext()) {
                LookupElement thisElement = (LookupElement)i.next();
                sb.append(thisElement.getDescription());
                if (!i.hasNext()) continue;
                sb.append(this.delimiter);
            }
        }
        return sb.toString();
    }

    public int getId() {
        return this.id;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public String getNameHtml() {
        return StringUtils.toHtml(this.name);
    }

    public int getLevel() {
        return this.level;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.getTypeString(this.type, true);
    }

    public int getValidationType() {
        return this.validationType;
    }

    public boolean getRequired() {
        return this.required;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getError() {
        return this.error;
    }

    public int getSelectedItemId() {
        return this.selectedItemId;
    }

    public String getEnteredValue() {
        return this.enteredValue;
    }

    public Object getElementData() {
        return this.elementData;
    }

    public CustomField duplicate() throws CloneNotSupportedException {
        return (CustomField)this.clone();
    }

    public boolean getLengthRequired() {
        switch (this.type) {
            case 1: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean getLookupListRequired() {
        switch (this.type) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String getParameter(String tmp) {
        if (this.parameters.containsKey(tmp.toLowerCase())) {
            return (String)this.parameters.get(tmp.toLowerCase());
        }
        return "";
    }

    public String getValueHtml() {
        return this.getValueHtml(true);
    }

    public String getValueHtml(boolean enableLinks) {
        if (this.type != 2 && (this.enteredValue == null || this.enteredValue.equals(""))) {
            return StringUtils.toHtml(this.enteredValue);
        }
        switch (this.type) {
            case 14: {
                if (enableLinks) {
                    return "<a href=\"" + (this.enteredValue.indexOf(":") > -1 ? "" : "http://") + this.enteredValue + "\" target=\"_new\">" + this.enteredValue + "</a>";
                }
                return StringUtils.toHtml(this.enteredValue);
            }
            case 13: {
                if (enableLinks && this.enteredValue.indexOf("@") > 0) {
                    return "<a href=\"mailto:" + this.enteredValue + "\">" + this.enteredValue + "</a>";
                }
                return StringUtils.toHtml(this.enteredValue);
            }
            case 2: {
                if (this.elementData != null) {
                    return StringUtils.toHtml(((LookupList)this.elementData).getSelectedValue(this.selectedItemId));
                }
                return StringUtils.toHtml(this.enteredValue);
            }
            case 4: {
                return this.selectedItemId == 1 ? "Yes" : "No";
            }
            case 12: {
                try {
                    double thisAmount = Double.parseDouble(this.enteredValue);
                    NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.US);
                    return numberFormatter.format(thisAmount);
                }
                catch (Exception e) {
                    return StringUtils.toHtml(this.enteredValue);
                }
            }
            case 11: {
                return StringUtils.toHtml(this.enteredValue) + "%";
            }
        }
        return StringUtils.toHtml(this.enteredValue);
    }

    public String getRowListElement(int index, boolean editable) {
        String hiddenElementName = this.name + index + "id";
        String textElementName = this.name + index + "text";
        Object tmpResult = null;
        String maxlength = this.getParameter("maxlength");
        String size = "";
        if (!maxlength.equals("")) {
            size = Integer.parseInt(maxlength) > 40 ? "40" : maxlength;
        }
        tmpResult = ((ArrayList)this.elementData).size() >= index ? ((ArrayList)this.elementData).get(index - 1) : new Object();
        int rowElementId = -1;
        try {
            rowElementId = Integer.parseInt(ObjectUtils.getParam(tmpResult, "id"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (editable) {
            return "<input type=\"hidden\" name=\"" + hiddenElementName + "\" value=\"" + rowElementId + "\">\n<input type=\"text\" name=\"" + textElementName + "\" " + (maxlength.equals("") ? "" : "maxlength=\"" + maxlength + "\" ") + (size.equals("") ? "" : "size=\"" + size + "\" ") + " value=\"" + StringUtils.toHtmlValue(ObjectUtils.getParam(tmpResult, "description")) + "\"> ";
        }
        return StringUtils.toHtmlValue(ObjectUtils.getParam(tmpResult, "description"));
    }

    public String getHtmlElement(SystemStatus thisSystem) {
        String elementName = "";
        elementName = this.id > -1 ? "cf" + this.id : this.name;
        String language = System.getProperty("LANGUAGE");
        String country = System.getProperty("COUNTRY");
        switch (this.type) {
            case 3: {
                return "<textarea cols=\"50\" rows=\"4\" name=\"" + elementName + "\">" + StringUtils.toString(this.enteredValue) + "</textarea>";
            }
            case 22: {
                return "<textarea cols=\"50\" rows=\"4\" name=\"" + elementName + "\">" + StringUtils.fromHtmlValue(this.enteredValue) + "</textarea>";
            }
            case 2: {
                if (!((LookupList)this.elementData).containsKey(-1)) {
                    if (thisSystem != null) {
                        ((LookupList)this.elementData).addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
                    } else {
                        ((LookupList)this.elementData).addItem(-1, "-- None --");
                    }
                }
                LookupList tmpList = (LookupList)this.elementData;
                tmpList.setJsEvent(this.getOnChange() != null ? " onchange=\"" + this.getOnChange() + "\"" : "");
                return tmpList.getHtmlSelect(elementName, this.selectedItemId);
            }
            case 5: {
                return "<input type=\"button\" name=\"" + elementName + "\" value=\"" + this.display + "\" " + (this.jsEvent != null ? " onClick=\"" + this.jsEvent + "\"" : "") + (this.enabled ? "" : " disabled") + ">";
            }
            case 4: {
                return "<input type=\"checkbox\" name=\"" + elementName + "\" value=\"ON\" " + (this.selectedItemId == 1 ? "checked" : "") + ">";
            }
            case 8: {
                return "<input type=\"text\" name=\"" + elementName + "\" size=\"10\" value=\"" + StringUtils.toHtmlValue(this.enteredValue) + "\"> " + "<a href=\"javascript:popCalendar('details', '" + elementName + "','" + language + "','" + country + "');\">" + "<img src=\"images/icons/stock_form-date-field-16.gif\" " + "border=\"0\" align=\"absmiddle\" height=\"16\" width=\"16\"/></a>";
            }
            case 11: {
                return "<input type=\"text\" name=\"" + elementName + "\" size=\"8\" value=\"" + StringUtils.toHtmlValue(this.enteredValue) + "\"> " + "%";
            }
            case 17: {
                return "<input type=\"hidden\" name=\"" + elementName + "\" value=\"" + StringUtils.toHtmlValue(this.enteredValue) + "\">";
            }
            case 18: {
                return StringUtils.toHtmlValue(this.enteredValue);
            }
            case 6: {
                return this.getDisplayHtml();
            }
            case 7: {
                return "<a href=\"" + this.jsEvent + "\" >" + this.display + "</a>";
            }
            case 23: {
                StateSelect stateSelect = new StateSelect(thisSystem, "UNITED STATES");
                return stateSelect.getHtmlSelect(elementName, "UNITED STATES", StringUtils.toHtmlValue(this.enteredValue));
            }
        }
        String maxlength = this.getParameter("maxlength");
        String size = "";
        if (!maxlength.equals("")) {
            size = Integer.parseInt(maxlength) > 40 ? "40" : maxlength;
        }
        return "<input type=\"text\" name=\"" + elementName + "\" " + (maxlength.equals("") ? "" : "maxlength=\"" + maxlength + "\" ") + (size.equals("") ? "" : "size=\"" + size + "\" ") + "value=\"" + StringUtils.toHtmlValue(this.enteredValue) + "\">";
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, null);
    }

    public String getHtmlSelect(String selectName, String jsEvent) {
        HtmlSelect dataTypes = new HtmlSelect();
        dataTypes.addItem(1, this.getTypeString(1, false));
        dataTypes.addItem(3, this.getTypeString(3, false));
        dataTypes.addItem(2, this.getTypeString(2, false));
        dataTypes.addItem(8, this.getTypeString(8, false));
        dataTypes.addItem(9, this.getTypeString(9, false));
        dataTypes.addItem(10, this.getTypeString(10, false));
        dataTypes.addItem(11, this.getTypeString(11, false));
        dataTypes.addItem(12, this.getTypeString(12, false));
        dataTypes.addItem(4, this.getTypeString(4, false));
        dataTypes.addItem(13, this.getTypeString(13, false));
        dataTypes.addItem(14, this.getTypeString(14, false));
        dataTypes.addItem(15, this.getTypeString(15, false));
        dataTypes.addItem(23, this.getTypeString(23, false));
        if (this.type == -1) {
            this.type = 1;
        }
        dataTypes.setJsEvent(jsEvent);
        return dataTypes.getHtml(selectName, this.type);
    }

    public String getTypeString(int dataType, boolean dynamic) {
        switch (dataType) {
            case 1: {
                if (this.getParameter("maxlength") == null || this.getParameter("maxlength").equals("") || !dynamic) {
                    return "Text (up to 255 characters)";
                }
                return "Text (" + this.getParameter("maxlength") + ")";
            }
            case 3: {
                return "Text Area (unlimited)";
            }
            case 2: {
                return "Lookup List";
            }
            case 4: {
                return "Check Box";
            }
            case 8: {
                return "Date";
            }
            case 9: {
                return "Number";
            }
            case 10: {
                return "Decimal Number";
            }
            case 11: {
                return "Percent";
            }
            case 12: {
                return "Currency";
            }
            case 13: {
                return "Email Address";
            }
            case 14: {
                return "URL";
            }
            case 15: {
                return "Phone Number";
            }
            case 23: {
                return "US State List";
            }
        }
        return "";
    }

    public boolean hasDisplay() {
        return this.display != null && !"".equals(this.display);
    }

    public void buildResources(Connection db) throws SQLException {
        if (this.recordId > -1) {
            PreparedStatement pst = db.prepareStatement("SELECT * FROM custom_field_data WHERE record_id = ? AND field_id = ? ");
            pst.setInt(1, this.recordId);
            pst.setInt(2, this.id);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.buildPopulatedRecord(rs);
            }
            rs.close();
            pst.close();
        }
        this.buildElementData(db);
    }

    public void buildElementData(Connection db) throws SQLException {
        if (this.type == 2) {
            this.elementData = new LookupList(db, "custom_field_lookup", this.id);
        }
    }

    public int insert(Connection db) throws SQLException {
        int result = 1;
        if (!this.isValid()) {
            return -1;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO custom_field_data (record_id, field_id, selected_item_id, entered_value, entered_number, ");
        sql.append("entered_float ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ");
        sql.append("?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.recordId);
        pst.setInt(++i, this.id);
        pst.setInt(++i, this.selectedItemId);
        pst.setString(++i, this.enteredValue);
        pst.setInt(++i, this.enteredNumber);
        pst.setDouble(++i, this.enteredDouble);
        pst.execute();
        pst.close();
        return result;
    }

    public int updateLevel(Connection db) throws SQLException {
        if (this.id < 0) {
            return 0;
        }
        int result = 1;
        String sql = "UPDATE custom_field_info SET " + DatabaseUtils.addQuotes(db, "level") + " = ?, group_id = ? " + "WHERE field_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.level);
        pst.setInt(++i, this.groupId);
        pst.setInt(++i, this.id);
        result = pst.executeUpdate();
        pst.close();
        return result;
    }

    public boolean insertField(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "custom_field_info_field_id_seq");
            String sql = "INSERT INTO custom_field_info (" + (this.id > -1 ? "field_id, " : "") + "group_id, field_name, field_type, required, parameters, additional_text ) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.groupId);
            pst.setString(++i, this.name);
            pst.setInt(++i, this.type);
            pst.setBoolean(++i, this.required);
            pst.setString(++i, this.getParameterData());
            pst.setString(++i, this.additionalText);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "custom_field_info_field_id_seq", this.id);
            if (this.type == 2 && this.elementData != null && this.elementData instanceof LookupList) {
                this.insertLookupList(db);
            }
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            result = false;
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean insertLookupList(Connection db) throws SQLException {
        if (this.elementData == null || !(this.elementData instanceof LookupList)) {
            return false;
        }
        for (LookupElement thisElement : (LookupList)this.elementData) {
            thisElement.setTableName("custom_field_lookup");
            thisElement.setFieldId(this.id);
            thisElement.setDefaultItem(false);
            thisElement.setEnabled(true);
            thisElement.insert(db);
        }
        return true;
    }

    public boolean updateField(Connection db) throws SQLException {
        if (this.id == -1) {
            return false;
        }
        String sql = "UPDATE custom_field_info SET field_name = ?, field_type = ?, required = ?, parameters = ?, additional_text = ? WHERE group_id = ? AND field_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setString(++i, this.getName());
        pst.setInt(++i, this.type);
        pst.setBoolean(++i, this.required);
        pst.setString(++i, this.getParameterData());
        pst.setString(++i, this.additionalText);
        pst.setInt(++i, this.getGroupId());
        pst.setInt(++i, this.getId());
        pst.execute();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CustomField-> Updating CustomField");
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("           -> Name: " + this.getName());
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("           -> Type: " + this.getTypeString());
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("           -> Parameters: " + this.getParameterData());
        }
        pst.close();
        return true;
    }

    public boolean deleteField(Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CustomField-> deleteField: " + this.id + " group: " + this.groupId);
        }
        boolean result = false;
        if (this.groupId == -1 || this.id == -1) {
            return result;
        }
        try {
            db.setAutoCommit(false);
            String sql = "DELETE FROM custom_field_data WHERE field_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            if (this.type == 2) {
                sql = "DELETE FROM custom_field_lookup WHERE field_id = ? ";
                pst = db.prepareStatement(sql);
                pst.setInt(1, this.id);
                pst.execute();
                pst.close();
            }
            sql = "DELETE FROM custom_field_info WHERE field_id = ? ";
            pst = db.prepareStatement(sql);
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            db.commit();
            result = true;
        }
        catch (SQLException e) {
            result = false;
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    private boolean isValid() {
        if (this.recordId == -1) {
            this.error = "Form record id error";
        }
        if (this.type == -1) {
            this.error = "Form field type error";
        }
        if (this.getRequired() && (this.getEnteredValue() == null || this.getEnteredValue().equals(""))) {
            this.error = this.getName() + ": Required field";
        }
        if (this.type == 2 && this.getRequired() && this.getSelectedItemId() == -1) {
            this.error = "Required field";
        }
        if ((this.error == null || this.error.equals("")) && this.getEnteredValue() != null && !this.getEnteredValue().equals("")) {
            if (this.type == 9) {
                try {
                    int testNumber;
                    this.enteredNumber = testNumber = Integer.parseInt(this.getEnteredValue());
                    this.enteredDouble = Double.parseDouble("" + testNumber);
                }
                catch (Exception e) {
                    this.error = "Value should be a whole number";
                }
            }
            if (this.type == 10) {
                try {
                    double testNumber;
                    this.enteredDouble = testNumber = Double.parseDouble(this.getEnteredValue());
                }
                catch (Exception e) {
                    this.error = "Value should be a number";
                }
            }
            if (this.type == 11) {
                try {
                    double testNumber;
                    this.enteredDouble = testNumber = Double.parseDouble(this.getEnteredValue());
                }
                catch (Exception e) {
                    this.error = "Value should be a number";
                }
            }
            if (this.type == 12) {
                try {
                    String testString = StringUtils.replace(this.getEnteredValue(), ",", "");
                    testString = StringUtils.replace(testString, "$", "");
                    double testNumber = Double.parseDouble(testString);
                    this.setEnteredValue(testString);
                    this.enteredDouble = testNumber;
                }
                catch (Exception e) {
                    this.error = "Value should be a number";
                }
            }
            if (this.type == 8) {
                try {
                    String[] sep = null;
                    if (this.getEnteredValue().indexOf("/") != -1) {
                        sep = this.getEnteredValue().split("/");
                    } else if (this.getEnteredValue().indexOf("-") != -1) {
                        sep = this.getEnteredValue().split("-");
                    } else if (this.getEnteredValue().indexOf(".") != -1) {
                        sep = this.getEnteredValue().split(".");
                    }
                    if (sep == null) {
                        throw new ParseException("invalid date", 0);
                    }
                    if (sep.length != 3) {
                        throw new ParseException("invalid date", 0);
                    }
                    int md1 = -1;
                    int md2 = -1;
                    int year = -1;
                    md1 = Integer.parseInt(sep[0]);
                    md2 = Integer.parseInt(sep[1]);
                    year = Integer.parseInt(sep[2]);
                }
                catch (ParseException e) {
                    this.error = "Value should be a valid date";
                }
            }
            if (this.type == 13 && (this.getEnteredValue().indexOf("@") < 1 || this.getEnteredValue().indexOf(" ") > -1 || this.getEnteredValue().indexOf(".") < 0)) {
                this.error = "Email address format error";
            }
            if (this.type == 14 && this.getEnteredValue().indexOf(".") < 0) {
                this.error = "URL format error";
            }
        }
        if (System.getProperty("DEBUG") != null && this.error != null) {
            System.out.println("CustomField-> isValid Error: " + this.error);
        }
        return this.error == null;
    }

    public String getParameterData() {
        StringBuffer parameterData = new StringBuffer();
        Iterator params = this.parameters.keySet().iterator();
        while (params.hasNext()) {
            String key = (String)params.next();
            parameterData.append(key + "|" + (String)this.parameters.get(key));
            if (!params.hasNext()) continue;
            parameterData.append("^");
        }
        return parameterData.toString();
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.groupId = rs.getInt("group_id");
        this.id = rs.getInt("field_id");
        this.name = rs.getString("field_name");
        this.level = rs.getInt("level");
        this.type = rs.getInt("field_type");
        this.validationType = rs.getInt("validation_type");
        this.required = rs.getBoolean("required");
        String param = rs.getString("parameters");
        this.startDate = rs.getTimestamp("start_date");
        this.endDate = rs.getTimestamp("end_date");
        this.modified = this.entered = rs.getTimestamp("entered");
        this.enabled = rs.getBoolean("enabled");
        this.additionalText = rs.getString("additional_text");
        this.setParameters(param);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("CustomField::groupId " + this.groupId);
        str.append("\nCustomField::id " + this.id);
        str.append("\nCustomField::name " + this.name);
        str.append("\nCustomField::level " + this.level);
        str.append("\nCustomField::enteredValue " + this.enteredValue);
        str.append("\nCustomField::enteredNumber " + this.enteredNumber);
        str.append("\nCustomField::enteredDouble " + this.enteredDouble);
        str.append("\nCustomField::selectedItemId " + this.selectedItemId);
        str.append("\nCustomField::type " + this.type);
        str.append("\nCustomField::validationType " + this.validationType);
        str.append("\nCustomField::required " + this.required);
        str.append("\nCustomField::startDate " + this.startDate);
        str.append("\nCustomField::endDate " + this.endDate);
        str.append("\nCustomField::entered " + this.entered);
        str.append("\nCustomField::enabled " + this.enabled);
        str.append("\nCustomField::additionalText " + this.additionalText);
        return str.toString();
    }

    private void buildPopulatedRecord(ResultSet rs) throws SQLException {
        this.selectedItemId = rs.getInt("selected_item_id");
        this.enteredValue = rs.getString("entered_value");
    }

    public static int locateIdByName(Connection db, String name) throws SQLException {
        int id = -1;
        PreparedStatement pst = db.prepareStatement("SELECT field_id FROM custom_field_info cf WHERE cf.field_name = ? ");
        pst.setString(1, name);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            id = rs.getInt("field_id");
        }
        rs.close();
        pst.close();
        return id;
    }

    public void parseTemplateText(SystemStatus thisSystem) {
        Template template;
        if (this.display != null) {
            template = new Template(this.display);
            template.populateSystemVariables(thisSystem);
            this.display = template.getParsedText();
        }
        if (this.additionalText != null) {
            template = new Template(this.additionalText);
            template.populateSystemVariables(thisSystem);
            this.additionalText = template.getParsedText();
        }
    }
}

