/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionStepList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class CustomFieldCategory
extends ArrayList {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected HashMap errors = new HashMap();
    protected HashMap warnings = new HashMap();
    protected boolean onlyWarnings = false;
    private int id = -1;
    private int moduleId = -1;
    private String name = null;
    private String description = null;
    private int level = -1;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private boolean defaultItem = false;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = false;
    private boolean allowMultipleRecords = false;
    private boolean readOnly = false;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int recordId = -1;
    private int includeEnabled = -1;
    private int includeScheduled = -1;
    private boolean buildResources = false;
    private boolean canNotContinue = false;
    private int numberOfRecords = -1;

    public boolean getOnlyWarnings() {
        return this.onlyWarnings;
    }

    public void setOnlyWarnings(boolean tmp) {
        this.onlyWarnings = tmp;
    }

    public void setOnlyWarnings(String tmp) {
        this.onlyWarnings = DatabaseUtils.parseBoolean(tmp);
    }

    public void setNumberOfRecords(int tmp) {
        this.numberOfRecords = tmp;
    }

    public void setNumberOfRecords(String tmp) {
        this.numberOfRecords = Integer.parseInt(tmp);
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public CustomFieldCategory() {
    }

    public CustomFieldCategory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public CustomFieldCategory(Connection db, int categoryId) throws SQLException {
        PreparedStatement pst = db.prepareStatement(" SELECT  cfc.module_id as module_id, cfc.category_id as category_id, cfc.category_name as category_name, cfc." + DatabaseUtils.addQuotes(db, "level") + " AS " + DatabaseUtils.addQuotes(db, "level") + ",  " + " cfc.description as description, cfc.start_date as start_date, cfc.end_date as end_date, " + " cfc.default_item as default_item, cfc.entered as entered, cfc.enabled as enabled, " + " cfc.multiple_records as multiple_records, cfc.read_only as read_only " + "FROM custom_field_category cfc " + "WHERE cfc.category_id = ? ");
        pst.setInt(1, categoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setModuleId(int tmp) {
        this.moduleId = tmp;
    }

    public void setModuleId(String tmp) {
        this.moduleId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DateUtils.parseTimestampString(tmp);
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DateUtils.parseTimestampString(tmp);
    }

    public void setDefaultItem(boolean tmp) {
        this.defaultItem = tmp;
    }

    public void setDefaultItem(String tmp) {
        this.defaultItem = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setRecordId(int tmp) {
        this.recordId = tmp;
    }

    public void setIncludeEnabled(int tmp) {
        this.includeEnabled = tmp;
    }

    public void setIncludeScheduled(int tmp) {
        this.includeScheduled = tmp;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public void setParameters(ActionContext context) {
        for (CustomFieldGroup thisGroup : this) {
            thisGroup.setParameters(context);
        }
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public void setCanNotContinue(boolean tmp) {
        this.canNotContinue = tmp;
    }

    public void setCanNotContinue(String tmp) {
        this.canNotContinue = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getCanNotContinue() {
        return this.canNotContinue;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getId() {
        return this.id;
    }

    public void setAllowMultipleRecords(boolean tmp) {
        this.allowMultipleRecords = tmp;
    }

    public void setAllowMultipleRecords(String tmp) {
        this.allowMultipleRecords = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public boolean getAllowMultipleRecords() {
        return this.allowMultipleRecords;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setReadOnly(String tmp) {
        this.readOnly = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLevel() {
        return this.level;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedDateTimeString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public CustomFieldGroup getGroup(int tmp) {
        for (CustomFieldGroup thisGroup : this) {
            if (thisGroup.getId() != tmp) continue;
            return thisGroup;
        }
        return new CustomFieldGroup();
    }

    public String getFieldValue(int fieldId) {
        for (CustomFieldGroup thisGroup : this) {
            for (CustomField thisField : thisGroup) {
                if (thisField.getId() != fieldId) continue;
                return thisField.getEnteredValue();
            }
        }
        return null;
    }

    public String getFirstFieldValue() {
        for (CustomFieldGroup thisGroup : this) {
            Iterator fields = thisGroup.iterator();
            if (!fields.hasNext()) continue;
            CustomField thisField = (CustomField)fields.next();
            return thisField.getEnteredValue();
        }
        return null;
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (CustomFieldGroup thisGroup : this) {
            Iterator fields = thisGroup.iterator();
            if (!fields.hasNext()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public boolean hasField(int fieldId) {
        for (CustomFieldGroup thisGroup : this) {
            for (CustomField thisField : thisGroup) {
                if (thisField.getId() != fieldId) continue;
                return true;
            }
        }
        return false;
    }

    public void buildResources(Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CustomFieldCategory-> buildResources");
        }
        this.clear();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM custom_field_group cfg WHERE cfg.category_id = " + this.id + " ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", group_id, group_name ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            CustomFieldGroup thisGroup = new CustomFieldGroup(rs);
            this.add(thisGroup);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (CustomFieldGroup thisGroup : this) {
                thisGroup.setLinkModuleId(this.linkModuleId);
                thisGroup.setLinkItemId(this.linkItemId);
                thisGroup.setRecordId(this.recordId);
                thisGroup.setIncludeEnabled(this.includeEnabled);
                thisGroup.setIncludeScheduled(this.includeScheduled);
                thisGroup.setBuildResources(this.buildResources);
                thisGroup.buildResources(db);
            }
        }
    }

    public void buildRecordId(Connection db) throws SQLException {
        String sql = "SELECT record_id FROM custom_field_record WHERE link_module_id = ? AND link_item_id = ? AND category_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, this.linkModuleId);
        pst.setInt(2, this.linkItemId);
        pst.setInt(3, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.recordId = rs.getInt("record_id");
        }
        rs.close();
        pst.close();
    }

    public int update(Connection db) throws SQLException {
        int resultId = -1;
        try {
            int catResult = 1;
            db.setAutoCommit(false);
            Statement st = db.createStatement();
            st.executeUpdate("UPDATE custom_field_record SET modifiedBy = " + this.modifiedBy + ", " + "modified = CURRENT_TIMESTAMP " + "WHERE link_module_id = " + this.linkModuleId + " " + "AND link_item_id = " + this.linkItemId + " " + "AND record_id = " + this.recordId + " ");
            st.executeUpdate("DELETE FROM custom_field_data WHERE record_id = " + this.recordId + " ");
            st.close();
            if (!this.getCanNotContinue()) {
                catResult = this.insertGroup(db, -1);
            }
            if (catResult == 1) {
                db.commit();
                resultId = 1;
            } else {
                db.rollback();
                resultId = catResult;
            }
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultId;
    }

    public int insertGroup(Connection db, int recordId) throws SQLException {
        int catResult = 1;
        for (CustomFieldGroup thisGroup : this) {
            int groupResult;
            if (recordId != -1) {
                thisGroup.setRecordId(recordId);
            }
            if ((groupResult = thisGroup.insert(db)) == 1) continue;
            catResult = groupResult;
        }
        return catResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Connection db) throws SQLException {
        if (!this.allowMultipleRecords) {
            CustomFieldCategory customFieldCategory = this;
            synchronized (customFieldCategory) {
                this.buildRecordId(db);
                if (this.recordId > -1) {
                    return -1;
                }
                return this.doInsert(db);
            }
        }
        return this.doInsert(db);
    }

    private int doInsert(Connection db) throws SQLException {
        int resultId = -1;
        try {
            int catResult = 1;
            db.setAutoCommit(false);
            CustomFieldRecord thisRecord = new CustomFieldRecord();
            thisRecord.setLinkModuleId(this.linkModuleId);
            thisRecord.setLinkItemId(this.linkItemId);
            thisRecord.setCategoryId(this.id);
            thisRecord.setEnteredBy(this.enteredBy);
            thisRecord.setModifiedBy(this.modifiedBy);
            thisRecord.insert(db);
            this.setRecordId(thisRecord.getId());
            if (!this.getCanNotContinue()) {
                catResult = this.insertGroup(db, thisRecord.getId());
            }
            if (catResult == 1) {
                db.commit();
                resultId = 1;
            } else {
                db.rollback();
                resultId = catResult;
            }
        }
        catch (Exception e) {
            db.rollback();
            this.setRecordId(-1);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        if (this.getRecordId() != -1) {
            this.update(db);
        }
        return resultId;
    }

    public boolean insertCategory(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "custom_field_ca_category_id_seq");
        sql.append("INSERT INTO custom_field_category ");
        sql.append("(module_id, category_name, description, ");
        sql.append("multiple_records, read_only, ");
        if (this.id > -1) {
            sql.append("category_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enabled ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?,");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getModuleId());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getAllowMultipleRecords());
        pst.setBoolean(++i, this.getReadOnly());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        pst.setBoolean(++i, this.getEnabled());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "custom_field_ca_category_id_seq", this.id);
        return true;
    }

    public boolean toggleEnabled(Connection db) throws SQLException {
        if (this.id == -1) {
            return false;
        }
        String sql = "UPDATE custom_field_category SET enabled = ? WHERE category_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setBoolean(++i, !this.getEnabled());
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        this.enabled = !this.enabled;
        return true;
    }

    public boolean updateCategory(Connection db) throws SQLException {
        if (this.id == -1) {
            return false;
        }
        String sql = "UPDATE custom_field_category SET category_name = ?, description = ?, enabled = ?, multiple_records = ?, read_only = ? WHERE module_id = ? AND category_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getEnabled());
        pst.setBoolean(++i, this.getAllowMultipleRecords());
        pst.setBoolean(++i, this.getReadOnly());
        pst.setInt(++i, this.getModuleId());
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean deleteCategory(Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CustomFieldCategory-> Delete Category: Mod(" + this.moduleId + ") Cat " + this.id);
        }
        if (this.moduleId == -1 || this.id == -1) {
            System.out.println("CustomFieldCategory-> Form Error");
            return false;
        }
        try {
            db.setAutoCommit(false);
            ActionStepList stepList = new ActionStepList();
            stepList.setCategoryId(this.getId());
            stepList.buildList(db);
            stepList.resetFolderInformation(db);
            CustomFieldRecord thisRecord = new CustomFieldRecord();
            thisRecord.setLinkModuleId(this.moduleId);
            thisRecord.setCategoryId(this.id);
            thisRecord.delete(db);
            CustomFieldGroup thisGroup = new CustomFieldGroup();
            thisGroup.setLinkModuleId(this.linkModuleId);
            thisGroup.setCategoryId(this.id);
            thisGroup.delete(db);
            String sql = "DELETE FROM custom_field_category WHERE module_id = ? AND category_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            int i = 0;
            pst.setInt(++i, this.moduleId);
            pst.setInt(++i, this.id);
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.moduleId = rs.getInt("module_id");
        this.id = rs.getInt("category_id");
        this.name = rs.getString("category_name");
        this.level = rs.getInt("level");
        this.description = rs.getString("description");
        this.startDate = rs.getTimestamp("start_date");
        this.endDate = rs.getTimestamp("end_date");
        this.defaultItem = rs.getBoolean("default_item");
        this.modified = this.entered = rs.getTimestamp("entered");
        this.enabled = rs.getBoolean("enabled");
        this.allowMultipleRecords = rs.getBoolean("multiple_records");
        this.readOnly = rs.getBoolean("read_only");
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.includeScheduled == 1) {
            sqlFilter.append("AND CURRENT_TIMESTAMP > cfg.start_date AND (CURRENT_TIMESTAMP < cfg.end_date OR cfg.end_date IS NULL) ");
        } else if (this.includeScheduled == 0) {
            sqlFilter.append("AND (CURRENT_TIMESTAMP < cfg.start_date OR (CURRENT_TIMESTAMP > cfg.end_date AND cfg.end_date IS NOT NULL)) ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND cfg.enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        return i;
    }

    public ArrayList getFormFieldIds() {
        ArrayList<Integer> a = new ArrayList<Integer>();
        for (CustomFieldGroup thisGroup : this) {
            Iterator fields = thisGroup.iterator();
            if (!fields.hasNext()) continue;
            while (fields.hasNext()) {
                CustomField thisField = (CustomField)fields.next();
                a.add(new Integer(thisField.getId()));
            }
        }
        return a;
    }

    public static int getIdFromName(Connection db, int moduleId, String categoryName) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement(" SELECT category_id  FROM custom_field_category  WHERE module_id = ?  AND category_name = ?  AND category_id IN  (SELECT max(category_id)  FROM custom_field_category  WHERE module_id = ?  AND category_name = ?) ");
        pst.setInt(1, moduleId);
        pst.setString(2, categoryName);
        pst.setInt(3, moduleId);
        pst.setString(4, categoryName);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = rs.getInt("category_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public static int getIdFromRecord(Connection db, int recordId) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement(" SELECT category_id FROM custom_field_record WHERE record_id = ?");
        pst.setInt(1, recordId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = rs.getInt("category_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public void determineNumberOfRecords(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        CustomFieldRecordList recordList = new CustomFieldRecordList();
        recordList.setLinkModuleId(linkModuleId);
        recordList.setLinkItemId(linkItemId);
        recordList.setCategoryId(this.getId());
        recordList.buildList(db);
        this.numberOfRecords = recordList.size();
    }

    public boolean hasMultipleRecords(Connection db) throws SQLException {
        boolean hasMultiple = false;
        if (this.getId() == -1) {
            throw new SQLException("Custom Field Category ID not specified");
        }
        if (this.getModuleId() == -1) {
            throw new SQLException("Module ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT link_item_id, count (record_id) AS records FROM custom_field_record WHERE link_module_id = ? AND category_id = ? GROUP BY link_item_id ");
        pst.setInt(1, this.getModuleId());
        pst.setInt(2, this.getId());
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            if (rs.getInt("records") <= 1) continue;
            hasMultiple = true;
        }
        rs.close();
        pst.close();
        return hasMultiple;
    }

    public static ArrayList getModules(Connection db) throws SQLException {
        ArrayList<String> modules = new ArrayList<String>();
        PreparedStatement pst = db.prepareStatement("SELECT category_id FROM module_field_categorylink ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            modules.add(String.valueOf(rs.getInt("category_id")));
        }
        rs.close();
        pst.close();
        return modules;
    }
}

