/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomFieldCategoryList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int linkModuleId = -1;
    private int includeEnabled = -1;
    private int includeScheduled = -1;
    private boolean buildResources = false;
    private boolean allSelectOption = false;
    private String jsEvent = null;
    private int linkItemId = -1;
    private boolean buildTotalNumOfRecords = false;

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setBuildTotalNumOfRecords(boolean tmp) {
        this.buildTotalNumOfRecords = tmp;
    }

    public void setBuildTotalNumOfRecords(String tmp) {
        this.buildTotalNumOfRecords = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildTotalNumOfRecords() {
        return this.buildTotalNumOfRecords;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setIncludeEnabled(int tmp) {
        this.includeEnabled = tmp;
    }

    public void setIncludeScheduled(int tmp) {
        this.includeScheduled = tmp;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setAllSelectOption(boolean allSelectOption) {
        this.allSelectOption = allSelectOption;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getIncludeEnabled() {
        return this.includeEnabled;
    }

    public int getIncludeScheduled() {
        return this.includeScheduled;
    }

    public boolean getAllSelectOption() {
        return this.allSelectOption;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getDefaultCategoryId() {
        int tmpDefault = -1;
        int count = 0;
        for (CustomFieldCategory thisCategory : this) {
            if (++count == 1) {
                tmpDefault = thisCategory.getId();
            }
            if (!thisCategory.getDefaultItem()) continue;
            return thisCategory.getId();
        }
        return tmpDefault;
    }

    public CustomFieldCategory getDefaultCategory() {
        for (CustomFieldCategory thisCategory : this) {
            if (!thisCategory.getDefaultItem()) continue;
            return thisCategory;
        }
        return new CustomFieldCategory();
    }

    public CustomFieldCategory getCategory(int tmp) {
        for (CustomFieldCategory thisCategory : this) {
            if (thisCategory.getId() != tmp) continue;
            return thisCategory;
        }
        return new CustomFieldCategory();
    }

    public String getHtmlSelect(String selectName, String defaultKey) {
        return this.getHtmlSelect(selectName, Integer.parseInt(defaultKey));
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect thisSelect = new HtmlSelect();
        if (this.allSelectOption) {
            thisSelect.addItem(0, "All Folders");
        }
        for (CustomFieldCategory thisCategory : this) {
            thisSelect.addItem(thisCategory.getId(), thisCategory.getName());
        }
        if (this.jsEvent != null) {
            thisSelect.setJsEvent(this.jsEvent);
        }
        return thisSelect.getHtml(selectName, defaultKey);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM custom_field_category cfc, module_field_categorylink mfc WHERE cfc.module_id = mfc.category_id AND cfc.module_id = ? ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("cfc." + DatabaseUtils.addQuotes(db, "level") + ", cfc.category_name, cfc.category_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY cfc." + DatabaseUtils.addQuotes(db, "level") + ", cfc.category_name, cfc.category_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" cfc.module_id as module_id, cfc.category_id as category_id, cfc.category_name as category_name, cfc." + DatabaseUtils.addQuotes(db, "level") + " as " + DatabaseUtils.addQuotes(db, "level") + ",  " + " cfc.description as description, cfc.start_date as start_date, cfc.end_date as end_date, " + " cfc.default_item as default_item, cfc.entered as entered, cfc.enabled as enabled, " + " cfc.multiple_records as multiple_records, cfc.read_only as read_only " + " FROM custom_field_category cfc, module_field_categorylink mfc " + " WHERE cfc.module_id = mfc.category_id AND cfc.module_id = ? ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CustomFieldCategory thisCategory = new CustomFieldCategory(rs);
            this.add(thisCategory);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (CustomFieldCategory thisCategory : this) {
                thisCategory.setLinkModuleId(this.linkModuleId);
                thisCategory.setIncludeEnabled(this.includeEnabled);
                thisCategory.setIncludeScheduled(this.includeScheduled);
                thisCategory.setBuildResources(this.buildResources);
                thisCategory.buildResources(db);
            }
        }
        if (this.buildTotalNumOfRecords && this.linkItemId != -1) {
            for (CustomFieldCategory thisCategory : this) {
                thisCategory.determineNumberOfRecords(db, this.linkModuleId, this.linkItemId);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.includeScheduled == 1) {
            sqlFilter.append("AND CURRENT_TIMESTAMP > cfc.start_date AND (CURRENT_TIMESTAMP < cfc.end_date OR cfc.end_date IS NULL) ");
        } else if (this.includeScheduled == 0) {
            sqlFilter.append("AND (CURRENT_TIMESTAMP < cfc.start_date OR (CURRENT_TIMESTAMP > cfc.end_date AND cfc.end_date IS NOT NULL)) ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND cfc.enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        pst.setInt(++i, this.linkModuleId);
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        return i;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

