/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.base.CustomFieldData;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomFieldDataList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int fieldId = -1;
    private int recordId = -1;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int categoryId = -1;

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int tmp) {
        this.fieldId = tmp;
    }

    public void setFieldId(String tmp) {
        this.fieldId = Integer.parseInt(tmp);
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setRecordId(int tmp) {
        this.recordId = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM custom_field_data cfd WHERE cfd.record_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("record_id", "field_id");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY record_id, field_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("cfd.* FROM custom_field_data cfd WHERE cfd.record_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CustomFieldData thisField = new CustomFieldData(rs);
            this.add(thisField);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.fieldId > -1) {
            sqlFilter.append("AND cfd.field_id = ? ");
        }
        if (this.recordId > -1) {
            sqlFilter.append("AND cfd.record_id = ? ");
        }
        if (this.linkModuleId > -1 && this.linkItemId > -1 && this.categoryId > -1) {
            sqlFilter.append("AND cfd.record_id IN (SELECT record_id FROM custom_field_record WHERE link_module_id = ? AND link_item_id = ? AND category_id = ? ) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.fieldId > -1) {
            pst.setInt(++i, this.fieldId);
        }
        if (this.recordId > -1) {
            pst.setInt(++i, this.recordId);
        }
        if (this.linkModuleId > -1 && this.linkItemId > -1 && this.categoryId > -1) {
            pst.setInt(++i, this.linkModuleId);
            pst.setInt(++i, this.linkItemId);
            pst.setInt(++i, this.categoryId);
        }
        return i;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

