/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class CustomFieldGroup
extends ArrayList {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected boolean onlyWarnings = false;
    protected HashMap errors = new HashMap();
    protected HashMap warnings = new HashMap();
    private int id = -1;
    private int categoryId = -1;
    private String name = null;
    private String description = null;
    private int level = -1;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean enabled = false;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int recordId = -1;
    private int includeEnabled = -1;
    private int includeScheduled = -1;
    private boolean buildResources = false;

    public CustomFieldGroup() {
    }

    public CustomFieldGroup(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public CustomFieldGroup(Connection db, int thisId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM custom_field_group cfg WHERE cfg.group_id = ? ");
        pst.setInt(1, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setGroupId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DateUtils.parseTimestampString(tmp);
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DateUtils.parseTimestampString(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "false".equalsIgnoreCase(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setRecordId(int tmp) {
        this.recordId = tmp;
    }

    public void setIncludeEnabled(int tmp) {
        this.includeEnabled = tmp;
    }

    public void setIncludeScheduled(int tmp) {
        this.includeScheduled = tmp;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setParameters(ActionContext context) {
        for (CustomField thisField : this) {
            thisField.setParameters(context);
        }
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLevel() {
        return this.level;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public boolean getOnlyWarnings() {
        return this.onlyWarnings;
    }

    public void setOnlyWarnings(boolean tmp) {
        this.onlyWarnings = tmp;
    }

    public void setOnlyWarnings(String tmp) {
        this.onlyWarnings = DatabaseUtils.parseBoolean(tmp);
    }

    public CustomField getField(int tmp) {
        for (CustomField thisField : this) {
            if (thisField.getId() != tmp) continue;
            return thisField;
        }
        return new CustomField();
    }

    public void buildResources(Connection db) throws SQLException {
        this.clear();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM custom_field_info cfi WHERE cfi.group_id = " + this.id + " ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", field_id, field_name ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            CustomField thisField = new CustomField(rs);
            thisField.setLinkModuleId(this.linkModuleId);
            thisField.setLinkItemId(this.linkItemId);
            thisField.setRecordId(this.recordId);
            this.add(thisField);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (CustomField thisField : this) {
                thisField.buildResources(db);
            }
        }
    }

    public int insert(Connection db) throws SQLException {
        int result = 1;
        for (CustomField thisField : this) {
            thisField.setRecordId(this.recordId);
            int fieldResult = thisField.insert(db);
            if (fieldResult == 1) continue;
            result = fieldResult;
        }
        return result;
    }

    public boolean insertGroup(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.level = this.retrieveNextLevel(db);
        this.id = DatabaseUtils.getNextSeq(db, "custom_field_group_group_id_seq");
        sql.append("INSERT INTO custom_field_group ");
        sql.append("(category_id, group_name, ");
        if (this.id > -1) {
            sql.append("group_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("description, " + DatabaseUtils.addQuotes(db, "level") + " ) ");
        sql.append("VALUES (?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getCategoryId());
        pst.setString(++i, this.getName());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.level);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "custom_field_group_group_id_seq", this.id);
        return true;
    }

    public boolean updateGroup(Connection db) throws SQLException {
        if (this.id == -1) {
            return false;
        }
        String sql = "UPDATE custom_field_group SET group_name = ?, description = ? WHERE category_id = ? AND group_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getCategoryId());
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int updateLevel(Connection db) throws SQLException {
        int result = 1;
        String sql = "UPDATE custom_field_group SET " + DatabaseUtils.addQuotes(db, "level") + " = ? " + "WHERE group_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getLevel());
        pst.setInt(++i, this.getId());
        result = pst.executeUpdate();
        pst.close();
        return result;
    }

    public boolean deleteGroup(Connection db) throws SQLException {
        boolean result = false;
        if (this.id == -1) {
            return result;
        }
        try {
            db.setAutoCommit(false);
            String sql = "DELETE FROM custom_field_data WHERE field_id IN (SELECT field_id FROM custom_field_info WHERE group_id = ?) ";
            PreparedStatement pst = db.prepareStatement(sql);
            int i = 0;
            pst.setInt(++i, this.id);
            pst.execute();
            pst.close();
            sql = "DELETE FROM custom_field_lookup WHERE field_id IN (SELECT field_id FROM custom_field_info WHERE group_id = ?) ";
            pst = db.prepareStatement(sql);
            i = 0;
            pst.setInt(++i, this.id);
            pst.execute();
            pst.close();
            sql = "DELETE FROM custom_field_info WHERE group_id = ? ";
            pst = db.prepareStatement(sql);
            i = 0;
            pst.setInt(++i, this.id);
            pst.execute();
            pst.close();
            sql = "DELETE FROM custom_field_group WHERE group_id = ? ";
            pst = db.prepareStatement(sql);
            i = 0;
            pst.setInt(++i, this.id);
            pst.execute();
            pst.close();
            db.commit();
            result = true;
        }
        catch (SQLException e) {
            result = false;
            System.out.println(e.toString());
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public void delete(Connection db) throws SQLException {
        String sql = "DELETE FROM custom_field_lookup WHERE field_id IN (SELECT field_id FROM custom_field_info WHERE group_id IN (SELECT group_id FROM custom_field_group WHERE category_id = ?)) ";
        PreparedStatement pst = db.prepareStatement(sql);
        int i = 0;
        pst.setInt(++i, this.categoryId);
        pst.executeUpdate();
        pst.close();
        sql = "DELETE FROM custom_field_info WHERE group_id IN (SELECT group_id FROM custom_field_group WHERE category_id = ?) ";
        pst = db.prepareStatement(sql);
        i = 0;
        pst.setInt(++i, this.categoryId);
        pst.executeUpdate();
        pst.close();
        sql = "DELETE FROM custom_field_group WHERE category_id = ? ";
        pst = db.prepareStatement(sql);
        i = 0;
        pst.setInt(++i, this.categoryId);
        pst.executeUpdate();
        pst.close();
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.categoryId = rs.getInt("category_id");
        this.id = rs.getInt("group_id");
        this.name = rs.getString("group_name");
        this.level = rs.getInt("level");
        this.description = rs.getString("description");
        this.startDate = rs.getTimestamp("start_date");
        this.endDate = rs.getTimestamp("end_date");
        this.modified = this.entered = rs.getTimestamp("entered");
        this.enabled = rs.getBoolean("enabled");
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.includeScheduled == 1) {
            sqlFilter.append("AND CURRENT_TIMESTAMP > cfi.start_date AND (CURRENT_TIMESTAMP < cfi.end_date OR cfi.end_date IS NULL) ");
        } else if (this.includeScheduled == 0) {
            sqlFilter.append("AND (CURRENT_TIMESTAMP < cfi.start_date OR (CURRENT_TIMESTAMP > cfi.end_date AND cfi.end_date IS NOT NULL)) ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND cfi.enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        return i;
    }

    private int retrieveNextLevel(Connection db) throws SQLException {
        int returnLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") as " + DatabaseUtils.addQuotes(db, "level") + " " + "FROM custom_field_group " + "WHERE category_id = ? ");
        pst.setInt(1, this.categoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            returnLevel = rs.getInt("level");
            if (rs.wasNull()) {
                returnLevel = 0;
            }
        }
        rs.close();
        pst.close();
        return ++returnLevel;
    }
}

