/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class CustomFieldRecord {
    private int id = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = false;
    private CustomField fieldData = null;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int categoryId = -1;

    public CustomFieldRecord() {
    }

    public CustomFieldRecord(Connection db, int recordId) throws SQLException {
        String sql = "SELECT * FROM custom_field_record cfr WHERE record_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, recordId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public CustomFieldRecord(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public int getId() {
        return this.id;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedDateTimeString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public CustomField getFieldData() {
        return this.fieldData;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "custom_field_reco_record_id_seq");
        sql.append("INSERT INTO custom_field_record (link_module_id, link_item_id, category_id, ");
        if (this.id > -1) {
            sql.append("record_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?,");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.linkModuleId);
        pst.setInt(++i, this.linkItemId);
        pst.setInt(++i, this.categoryId);
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "custom_field_reco_record_id_seq", this.id);
    }

    public boolean delete(Connection db) throws SQLException {
        int i = 0;
        StringBuffer sql = new StringBuffer();
        int accountMapId = ActionPlan.getMapIdGivenConstantId(db, 42420034);
        sql.append("UPDATE action_item_work SET link_item_id = NULL WHERE link_item_id = ? AND link_module_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getId());
        pst.setInt(++i, accountMapId);
        pst.executeUpdate();
        pst.close();
        sql.setLength(0);
        sql.append("DELETE FROM custom_field_data WHERE record_id IN (SELECT record_id FROM custom_field_record WHERE link_module_id = ? ");
        if (this.categoryId > -1) {
            sql.append("AND category_id = ? ");
        }
        if (this.linkItemId > -1) {
            sql.append("AND link_item_id = ? ");
        }
        if (this.id > -1) {
            sql.append("AND record_id = ? ");
        }
        sql.append(") ");
        pst = db.prepareStatement(sql.toString());
        i = 0;
        pst.setInt(++i, this.linkModuleId);
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.linkItemId > -1) {
            pst.setInt(++i, this.linkItemId);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.executeUpdate();
        pst.close();
        sql.setLength(0);
        sql.append("DELETE FROM custom_field_record WHERE link_module_id = ? ");
        if (this.categoryId > -1) {
            sql.append("AND category_id = ? ");
        }
        if (this.linkItemId > -1) {
            sql.append("AND link_item_id = ? ");
        }
        if (this.id > -1) {
            sql.append("AND record_id = ? ");
        }
        pst = db.prepareStatement(sql.toString());
        i = 0;
        pst.setInt(++i, this.linkModuleId);
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.linkItemId > -1) {
            pst.setInt(++i, this.linkItemId);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.executeUpdate();
        pst.close();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CustomFieldRecord-> Delete Complete");
        }
        return true;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.linkModuleId = rs.getInt("link_module_id");
        this.linkItemId = rs.getInt("link_item_id");
        this.categoryId = rs.getInt("category_id");
        this.id = rs.getInt("record_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
    }

    public void buildColumns(Connection db, CustomFieldCategory thisCategory) throws SQLException {
        String sql = (DatabaseUtils.getType(db) == 3 ? "SELECT * FROM ( " : "") + "SELECT " + (DatabaseUtils.getType(db) == 2 ? "TOP 1 " : "") + (DatabaseUtils.getType(db) == 5 ? "TOP (1) " : "") + (DatabaseUtils.getType(db) == 4 ? "FIRST 1 " : "") + "cfi.* " + "FROM custom_field_info cfi " + "WHERE cfi.group_id IN " + " (SELECT " + (DatabaseUtils.getType(db) == 2 ? "TOP 1 " : "") + (DatabaseUtils.getType(db) == 5 ? "TOP (1) " : "") + (DatabaseUtils.getType(db) == 4 ? "FIRST 1 " : "") + "    group_id " + "  FROM custom_field_group " + "  WHERE category_id = ? " + "  AND enabled = ? " + "  ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", group_id, group_name " + (DatabaseUtils.getType(db) == 9 ? "ROWS 1 TO 1 " : "") + (DatabaseUtils.getType(db) == 1 ? "LIMIT 1 " : "") + (DatabaseUtils.getType(db) == 7 ? "LIMIT 1 " : "") + " ) " + "AND enabled = ? " + "ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", field_id, field_name " + (DatabaseUtils.getType(db) == 9 ? "ROWS 1 TO 1 " : "") + (DatabaseUtils.getType(db) == 1 ? "LIMIT 1 " : "") + (DatabaseUtils.getType(db) == 7 ? "LIMIT 1 " : "") + (DatabaseUtils.getType(db) == 6 ? "FETCH FIRST 1 ROWS ONLY " : "") + (DatabaseUtils.getType(db) == 3 ? ") WHERE ROWNUM <= 1 " : "");
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, thisCategory.getId());
        pst.setBoolean(2, true);
        pst.setBoolean(3, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.fieldData = new CustomField(rs);
            this.fieldData.setRecordId(this.id);
            this.fieldData.buildResources(db);
        }
        rs.close();
        pst.close();
    }

    public boolean deleteData(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement(" DELETE FROM custom_field_data  WHERE record_id = ? ");
        pst.setInt(1, this.getId());
        pst.executeUpdate();
        pst.close();
        return true;
    }
}

