/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.utils.web.PagedListInfo;

public class CustomFieldRecordList
extends ArrayList {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private PagedListInfo pagedListInfo = null;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int categoryId = -1;
    private int includeEnabled = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM custom_field_record cfr WHERE cfr.link_module_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("entered", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY entered DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("cfr.* FROM custom_field_record cfr WHERE cfr.link_module_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CustomFieldRecord thisRecord = new CustomFieldRecord(rs);
            this.add(thisRecord);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND cfr.link_module_id = ? ");
        }
        if (this.linkItemId > -1) {
            sqlFilter.append("AND cfr.link_item_id = ? ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND cfr.enabled = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND cfr.category_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.linkItemId > -1) {
            pst.setInt(++i, this.linkItemId);
        }
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        return i;
    }

    public void delete(Connection db) throws SQLException {
        for (CustomFieldRecord thisRecord : this) {
            thisRecord.delete(db);
        }
    }

    public void buildRecordColumns(Connection db, CustomFieldCategory thisCategory) throws SQLException {
        for (CustomFieldRecord thisRecord : this) {
            thisRecord.buildColumns(db, thisCategory);
        }
    }

    public static int retrieveRecordCount(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) as foldercount FROM custom_field_record cfr WHERE cfr.link_module_id = ? and cfr.link_item_id = ?");
        pst.setInt(1, linkModuleId);
        pst.setInt(2, linkItemId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("foldercount");
        }
        rs.close();
        pst.close();
        return count;
    }
}

