/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.Dependency;

public class DependencyList
extends ArrayList {
    private String title = null;
    private SystemStatus systemStatus = null;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean canDelete() {
        Iterator thisList = this.iterator();
        boolean canDelete = true;
        while (thisList.hasNext()) {
            Dependency thisDependency = (Dependency)((Object)thisList.next());
            if (thisDependency.getCanDelete() || thisDependency.getCount() <= 0) continue;
            canDelete = false;
        }
        return canDelete;
    }

    public String getHtmlString() {
        boolean canDelete = true;
        Iterator i = this.iterator();
        StringBuffer html = new StringBuffer();
        html.append("<br />");
        int count = 0;
        while (i.hasNext()) {
            Dependency thisDependency = (Dependency)((Object)i.next());
            if (thisDependency.getCount() <= 0) continue;
            ++count;
            html.append("&nbsp;&nbsp;");
            if (thisDependency.getCanDelete()) {
                html.append("- ");
            } else {
                html.append("- ");
                canDelete = false;
            }
            if (this.systemStatus != null) {
                html.append(this.systemStatus.getLabel("dependency." + thisDependency.getName()) + " (" + thisDependency.getCount() + ")");
            }
            html.append("<br />");
        }
        if (count == 0 && this.systemStatus != null) {
            html.append("&nbsp;&nbsp;" + this.systemStatus.getLabel("dependency.noDependencyForAction") + "<br />");
        }
        if (canDelete || this.systemStatus != null) {
            // empty if block
        }
        return html.toString();
    }

    public int getDependencyCount(String name) {
        Iterator iterator = this.iterator();
        int result = 0;
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)((Object)iterator.next());
            if (!dependency.getName().equals(name)) continue;
            result = dependency.getCount();
            break;
        }
        return result;
    }
}

