/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.base.EmailAddress;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class EmailAddressList
extends Vector {
    protected PagedListInfo pagedListInfo = null;
    protected int orgId = -1;
    protected int type = -1;
    protected int contactId = -1;
    protected String username = null;

    protected void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmailAddress(String thisType) {
        for (EmailAddress thisAddress : this) {
            if (!thisType.equals(thisAddress.getTypeName())) continue;
            return thisAddress.getEmail();
        }
        return "";
    }

    public String getEmailAddress(int thisItem) {
        if (thisItem - 1 > -1 && thisItem <= this.size()) {
            EmailAddress thisAddress = (EmailAddress)((Object)this.get(thisItem - 1));
            return thisAddress.getEmail();
        }
        return "";
    }

    public String getPrimaryEmailAddress() {
        Iterator i = this.iterator();
        EmailAddress thisAddress = null;
        while (i.hasNext() && !(thisAddress = (EmailAddress)((Object)i.next())).getPrimaryEmail()) {
        }
        return thisAddress == null ? "" : thisAddress.getEmail();
    }

    public int getEmailAddressTypeId(int thisItem) {
        if (thisItem - 1 > -1 && thisItem <= this.size()) {
            EmailAddress thisAddress = (EmailAddress)((Object)this.get(thisItem - 1));
            return thisAddress.getType();
        }
        return -1;
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND org_id = ? ");
        }
        if (this.type != -1) {
            sqlFilter.append("AND emailaddress_type = ? ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND contact_id = ? ");
        }
        if (this.username != null) {
            sqlFilter.append("AND contact_id IN (SELECT contact_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE lower(username) = ?) ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.type != -1) {
            pst.setInt(++i, this.type);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.username != null) {
            pst.setString(++i, this.username.toLowerCase());
        }
        return i;
    }

    public String getConcatenatedList() {
        StringBuffer result = new StringBuffer("");
        Iterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            EmailAddress email = (EmailAddress)((Object)iterator.next());
            if (i > 0) {
                result.append(", ");
            }
            result.append(email.getEmail());
            ++i;
        }
        return result.toString();
    }
}

