/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.Filter;

public class FilterList
extends ArrayList {
    private static final String[] CONTACT_FILTERS = new String[]{"all", "employees", "mycontacts", "accountcontacts", "myprojects"};
    private static final String[] ACCOUNT_FILTERS = new String[]{"all", "my", "disabled"};
    private static final String[] ASSET_FILTERS = new String[]{"allassets", "undercontract"};
    private int source = 2;

    public FilterList() {
    }

    public FilterList(SystemStatus thisSystem, HttpServletRequest request) {
        this.build(thisSystem, request);
    }

    public void setSource(int source) {
        this.source = source;
    }

    public int getSource() {
        return this.source;
    }

    public String getDisplayName(SystemStatus thisSystem, String name) {
        switch (this.source) {
            case 2: {
                if (name.equals("all")) {
                    return thisSystem.getLabel("actionList.allContacts");
                }
                if (name.equals("employees")) {
                    return thisSystem.getLabel("employees.employees");
                }
                if (name.equals("mycontacts")) {
                    return thisSystem.getLabel("contact.myContacts");
                }
                if (name.equals("accountcontacts")) {
                    return thisSystem.getLabel("documents.team.accountContacts");
                }
                if (name.equals("myprojects")) {
                    return thisSystem.getLabel("contacts.myProjects");
                }
            }
            case 1: {
                if (name.equals("all")) {
                    return thisSystem.getLabel("accounts.all.accounts");
                }
                if (name.equals("my")) {
                    return thisSystem.getLabel("accounts.my.accounts");
                }
                if (name.equals("disabled")) {
                    return thisSystem.getLabel("accounts.disabledAccounts");
                }
            }
            case 209041110: {
                if (name.equals("allassets")) {
                    return thisSystem.getLabel("accounts.allAssets");
                }
                if (!name.equals("undercontract")) break;
                return thisSystem.getLabel("accounts.assetsUnderContract");
            }
        }
        return thisSystem.getLabel("calendar.none.4dashes");
    }

    public void build(SystemStatus thisSystem, HttpServletRequest request) {
        String filters = request.getParameter("filters");
        if (filters != null && !"".equals(filters)) {
            StringTokenizer st = new StringTokenizer(filters, "|");
            while (st.hasMoreTokens()) {
                String value = st.nextToken();
                this.add(new Filter(value, this.getDisplayName(thisSystem, value)));
            }
        } else {
            this.buildDefaultFilters(thisSystem);
        }
    }

    public void buildDefaultFilters(SystemStatus thisSystem) {
        switch (this.source) {
            case 2: {
                for (int i = 0; i < Array.getLength(CONTACT_FILTERS); ++i) {
                    this.add(new Filter(CONTACT_FILTERS[i], this.getDisplayName(thisSystem, CONTACT_FILTERS[i])));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < Array.getLength(ACCOUNT_FILTERS); ++i) {
                    this.add(new Filter(ACCOUNT_FILTERS[i], this.getDisplayName(thisSystem, ACCOUNT_FILTERS[i])));
                }
                break;
            }
            case 209041110: {
                for (int i = 0; i < Array.getLength(ASSET_FILTERS); ++i) {
                    this.add(new Filter(ASSET_FILTERS[i], this.getDisplayName(thisSystem, ASSET_FILTERS[i])));
                }
                break;
            }
        }
    }

    public String getFirstFilter(String selectedFilter) {
        Filter thisFilter;
        if ((selectedFilter == null || selectedFilter.equals("")) && (thisFilter = (Filter)this.get(0)) != null) {
            return thisFilter.getValue();
        }
        return selectedFilter;
    }
}

