/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.util.Calendar;
import java.util.Hashtable;
import org.aspcfs.utils.DatabaseUtils;

public class GraphSummaryList
extends Hashtable {
    int id = -1;
    boolean isValid = false;
    String lastFileName = null;
    Hashtable values = new Hashtable();
    int size = -1;
    boolean isFutureDateRange = false;
    public static final int MONTH_RANGE = 0;
    public static final int DATE_RANGE = 1;
    public static final int YEAR_RANGE = 2;
    public static final int WEEK_RANGE = 3;
    public static final int TEN_DAY_RANGE = 4;

    public GraphSummaryList() {
        String[] valKeys = this.getRange(12);
        Double initialVal = new Double(0.0);
        for (int i = 0; i < 12; ++i) {
            this.values.put(valKeys[i], initialVal);
        }
    }

    public GraphSummaryList(int range, int type, boolean inFuture) {
        this.isFutureDateRange = inFuture;
        this.setSize(range);
        String[] valKeys = new String[range];
        if (type == 0) {
            valKeys = this.getMonthRange(range);
        } else if (type != 2) {
            if (type == 3) {
                valKeys = this.getWeekRange(range);
            } else if (type == 1) {
                valKeys = this.getDayRange(range);
            } else if (type == 4) {
                valKeys = this.getTenDayRange(range);
            }
        }
        Double initialVal = new Double(0.0);
        for (int i = 0; i < range; ++i) {
            this.values.put(valKeys[i], initialVal);
        }
    }

    public void setLastFileName(String lastFileName) {
        this.lastFileName = lastFileName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setValue(String yearMonth, Double val) {
        if (!this.values.containsKey(yearMonth)) {
            this.values.put(yearMonth, val);
        } else {
            this.addToValue(yearMonth, val);
        }
    }

    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getLastFileName() {
        return this.lastFileName;
    }

    public int getId() {
        return this.id;
    }

    public Double getValue(String which) {
        if (!this.values.containsKey(which)) {
            return new Double(0.0);
        }
        return (Double)this.values.get(which);
    }

    public String[] getRange(int size) {
        String[] valKeys = new String[size];
        Calendar rightNow = Calendar.getInstance();
        int day = rightNow.get(5);
        int year = rightNow.get(1);
        int month = rightNow.get(2);
        for (int x = 0; x < size; ++x) {
            valKeys[x] = String.valueOf(year) + String.valueOf(month);
            rightNow.add(2, 1);
            year = rightNow.get(1);
            month = rightNow.get(2);
        }
        return valKeys;
    }

    public String[] getMonthRange(int size) {
        String[] valKeys = new String[size];
        Calendar rightNow = Calendar.getInstance();
        int year = rightNow.get(1);
        int month = rightNow.get(2);
        for (int x = 0; x < size; ++x) {
            valKeys[x] = String.valueOf(year) + String.valueOf(month);
            if (this.isFutureDateRange) {
                rightNow.add(2, 1);
            } else {
                rightNow.add(2, -1);
            }
            year = rightNow.get(1);
            month = rightNow.get(2);
        }
        return valKeys;
    }

    public String[] getTenDayRange(int size) {
        String[] valKeys = new String[size];
        Calendar rightNow = Calendar.getInstance();
        int day = rightNow.get(5);
        int year = rightNow.get(1);
        int month = rightNow.get(2);
        for (int x = 0; x < size; ++x) {
            valKeys[x] = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
            if (day <= 10) {
                if (this.isFutureDateRange) {
                    rightNow.add(5, 10 - rightNow.get(5));
                } else {
                    rightNow.add(5, -rightNow.get(5));
                }
            } else if (day <= 20 && day > 10) {
                if (this.isFutureDateRange) {
                    rightNow.add(5, 20 - rightNow.get(5));
                } else {
                    rightNow.add(5, -(rightNow.get(5) - 10));
                }
            } else if (day <= 31 && day > 20) {
                if (this.isFutureDateRange) {
                    rightNow.add(5, this.getDaysInMonth(rightNow.get(2), rightNow.get(1)) - rightNow.get(5));
                } else {
                    rightNow.add(5, -(rightNow.get(5) - 20));
                }
            }
            year = rightNow.get(1);
            month = rightNow.get(2);
            day = rightNow.get(5);
        }
        return valKeys;
    }

    public String[] getWeekRange(int size) {
        String[] valKeys = new String[size];
        Calendar rightNow = Calendar.getInstance();
        rightNow.add(5, -(rightNow.get(7) - rightNow.getFirstDayOfWeek()));
        int day = rightNow.get(5);
        int year = rightNow.get(1);
        int month = rightNow.get(2);
        for (int x = 0; x < size; ++x) {
            valKeys[x] = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
            if (this.isFutureDateRange) {
                rightNow.add(3, 1);
            } else {
                rightNow.add(3, -1);
            }
            rightNow.add(5, -(rightNow.get(7) - rightNow.getFirstDayOfWeek()));
            year = rightNow.get(1);
            month = rightNow.get(2);
            day = rightNow.get(5);
        }
        return valKeys;
    }

    public String[] getDayRange(int size) {
        String[] valKeys = new String[size];
        Calendar rightNow = Calendar.getInstance();
        int day = rightNow.get(5);
        int year = rightNow.get(1);
        int month = rightNow.get(2);
        for (int x = 0; x < size; ++x) {
            valKeys[x] = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
            if (this.isFutureDateRange) {
                rightNow.add(5, 1);
            } else {
                rightNow.add(5, -1);
            }
            year = rightNow.get(1);
            month = rightNow.get(2);
            day = rightNow.get(5);
        }
        return valKeys;
    }

    public String[] getYearRange(int size, int y) {
        String[] valKeys = new String[size];
        Calendar rightNow = Calendar.getInstance();
        rightNow.set(1, y);
        int year = rightNow.get(1);
        int month = 0;
        for (int x = 0; x < size; ++x) {
            valKeys[x] = String.valueOf(year) + String.valueOf(month);
            ++month;
        }
        return valKeys;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public void addToValue(String which, Double val) {
        Double tempValue = (Double)this.values.get(which);
        tempValue = new Double(tempValue + val);
        this.values.put(which, tempValue);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int tmp) {
        this.size = tmp;
    }

    public void setSize(String tmp) {
        this.size = Integer.parseInt(tmp);
    }

    public boolean getIsFutureDateRange() {
        return this.isFutureDateRange;
    }

    public void setIsFutureDateRange(boolean tmp) {
        this.isFutureDateRange = tmp;
    }

    public void setIsFutureDateRange(String tmp) {
        this.isFutureDateRange = DatabaseUtils.parseBoolean(tmp);
    }

    public int getDaysInMonth(int month, int year) {
        switch (month) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return Math.IEEEremainder(year, 4.0) == 0.0 ? 29 : 28;
            }
        }
        return 31;
    }

    public Hashtable getValues() {
        return this.values;
    }

    public void setValues(Hashtable tmp) {
        this.values = tmp;
    }
}

