/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.netapps.base.ContractExpiration;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.utils.DatabaseUtils;

public class Import
extends GenericBean {
    public static final int UNPROCESSED = 1;
    public static final int QUEUED = 2;
    public static final int RUNNING = 3;
    public static final int FAILED = 4;
    public static final int CANCELED = 5;
    public static final int PROCESSED_UNAPPROVED = 6;
    public static final int PROCESSED_APPROVED = 7;
    public static final int DELETED = 8;
    public static final int CUSTOM = 7;
    public static final int EXCEL_CSV = 8;
    public static final int ACT = 9;
    public static final int OUTLOOK_CSV = 10;
    public static final double IMPORT_FILE_VERSION = 1.0;
    public static final double ERROR_FILE_VERSION = 1.1;
    private int id = -1;
    private int type = -1;
    private int sourceType = -1;
    private int fileType = 8;
    private int totalImportedRecords = 0;
    private int totalFailedRecords = 0;
    private int statusId = 1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int siteId = -1;
    private int rating = -1;
    private String name = null;
    private String description = null;
    private String source = null;
    private String comments = null;
    private String recordDelimiter = "line";
    private String columnDelimiter = ",";
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean buildFileDetails = false;
    private FileItem file = null;
    private SystemStatus systemStatus = null;

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public Import() {
    }

    public Import(Connection db, int importId) throws SQLException {
        if (importId == -1) {
            throw new SQLException("Import ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT m.import_id, m." + DatabaseUtils.addQuotes(db, "type") + ", m.name, m.description, m.source_type, m.source, " + "m.record_delimiter, m.column_delimiter, m.total_imported_records, m.total_failed_records, " + "m.status_id, m.file_type, m.entered, m.enteredby, m.modified, m.modifiedby, m.site_id, m.rating, m.comments " + "FROM import m " + "WHERE m.import_id = ? ");
        int i = 0;
        pst.setInt(++i, importId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Import ID not found");
        }
        if (this.buildFileDetails) {
            this.file = new FileItem(db, this.id, this.type);
            this.file.buildVersionList(db);
        }
    }

    public Import(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setSourceType(int tmp) {
        this.sourceType = tmp;
    }

    public void setSourceType(String tmp) {
        this.sourceType = Integer.parseInt(tmp);
    }

    public void setTotalImportedRecords(int tmp) {
        this.totalImportedRecords = tmp;
    }

    public void setTotalImportedRecords(String tmp) {
        this.totalImportedRecords = Integer.parseInt(tmp);
    }

    public void setTotalFailedRecords(int tmp) {
        this.totalFailedRecords = tmp;
    }

    public void setTotalFailedRecords(String tmp) {
        this.totalFailedRecords = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setSource(String tmp) {
        this.source = tmp;
    }

    public void setRecordDelimiter(String tmp) {
        this.recordDelimiter = tmp;
    }

    public void setColumnDelimiter(String tmp) {
        this.columnDelimiter = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setFileType(int tmp) {
        this.fileType = tmp;
    }

    public void setFileType(String tmp) {
        this.fileType = Integer.parseInt(tmp);
    }

    public void setBuildFileDetails(boolean tmp) {
        this.buildFileDetails = tmp;
    }

    public void setBuildFileDetails(String tmp) {
        this.buildFileDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFile(FileItem tmp) {
        this.file = tmp;
    }

    public FileItem getFile() {
        return this.file;
    }

    public boolean getBuildFileDetails() {
        return this.buildFileDetails;
    }

    public int getFileType() {
        return this.fileType;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getTotalImportedRecords() {
        return this.totalImportedRecords;
    }

    public int getTotalFailedRecords() {
        return this.totalFailedRecords;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getStatusString() {
        String tmp = null;
        switch (this.statusId) {
            case 1: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.pending") : "Import Pending";
                break;
            }
            case 2: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.queued") : "Queued";
                break;
            }
            case 3: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.running") : "Running";
                break;
            }
            case 4: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.failed") : "Failed";
                break;
            }
            case 5: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.cancelled") : "Cancelled";
                break;
            }
            case 6: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.pendingApproval") : "Pending Approval";
                break;
            }
            case 7: {
                tmp = this.systemStatus != null ? this.systemStatus.getLabel("contact.import.status.approved") : "Approved";
                break;
            }
        }
        return tmp;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSource() {
        return this.source;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int tmp) {
        this.rating = tmp;
    }

    public void setRating(String tmp) {
        this.rating = Integer.parseInt(tmp);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String tmp) {
        this.comments = tmp;
    }

    public void incrementTotalImportedRecords() {
        ++this.totalImportedRecords;
    }

    public void incrementTotalFailedRecords() {
        ++this.totalFailedRecords;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void buildFileDetails(Connection db) throws SQLException {
        this.file = new FileItem(db, this.id, this.type);
        this.file.buildVersionList(db);
    }

    public boolean canDelete() {
        return this.statusId != 3 && this.statusId < 7;
    }

    public boolean isRunning() {
        return this.statusId == 3;
    }

    public boolean hasBeenProcessed() {
        return this.statusId == 7 || this.statusId == 6;
    }

    public boolean canProcess() {
        return this.statusId == 1;
    }

    public boolean canApprove() {
        return this.statusId == 6;
    }

    public boolean canModify() {
        return this.statusId == 1;
    }

    public String getColumnDelimiter() {
        if (this.columnDelimiter == null) {
            switch (this.fileType) {
                case 9: {
                    break;
                }
                case 8: {
                    this.columnDelimiter = ",";
                    break;
                }
                case 10: {
                    break;
                }
            }
        }
        return this.columnDelimiter;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void updateRecordCounts(ImportManager manager) {
        Object tmp;
        if (manager != null && (tmp = manager.getImport(this.getId())) != null) {
            Import activeImport = (Import)((Object)tmp);
            this.setTotalImportedRecords(activeImport.getTotalImportedRecords());
            this.setTotalFailedRecords(activeImport.getTotalFailedRecords());
            if (activeImport.getStatusId() == 2) {
                this.setStatusId(2);
            }
        }
    }

    public int updateStatus(Connection db, int status) throws SQLException {
        int count = 0;
        boolean commit = true;
        int previousStatus = this.getStatusId();
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE import SET status_id = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, status);
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            this.statusId = status;
            if (previousStatus == 6 && status == 7) {
                if (this.type == 33020041 || this.type == 33020043 || this.type == 324200544) {
                    Contact.updateImportStatus(db, this.getId(), 7);
                    if (this.type == 33020043) {
                        Organization.updateImportStatus(db, this.getId(), 7);
                    }
                }
                if (this.type == 33020045) {
                    ProductCatalog.updateImportStatus(db, this.getId(), 7);
                    ProductCategory.updateImportStatus(db, this.getId(), 7);
                }
                if (this.type == 917200409) {
                    ContractExpiration.updateImportStatus(db, this.getId(), 7);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public int recordResults(Connection db) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE import SET status_id = ?, total_imported_records = ?, total_failed_records = ?, modified = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, this.statusId);
            pst.setInt(++i, this.totalImportedRecords);
            pst.setInt(++i, this.totalFailedRecords);
            pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public boolean insert(Connection db) throws SQLException {
        String sql = null;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "import_import_id_seq");
            sql = "INSERT INTO import (" + (this.id > -1 ? "import_id, " : "") + "" + DatabaseUtils.addQuotes(db, "type") + ", name, description, file_type, source_type, rating, comments, record_delimiter, column_delimiter, status_id, enteredby, modifiedby, site_id, modified) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, " + (this.getModified() != null ? "?" : DatabaseUtils.getCurrentTimestamp(db)) + ") ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getType());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getFileType());
            DatabaseUtils.setInt(pst, ++i, this.getSourceType());
            DatabaseUtils.setInt(pst, ++i, this.getRating());
            pst.setString(++i, this.getComments());
            pst.setString(++i, this.getRecordDelimiter());
            pst.setString(++i, this.getColumnDelimiter());
            pst.setInt(++i, this.getStatusId());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "import_import_id_seq", this.id);
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("import_id");
        this.type = rs.getInt("type");
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.sourceType = DatabaseUtils.getInt(rs, "source_type");
        this.source = rs.getString("source");
        this.recordDelimiter = rs.getString("record_delimiter");
        this.columnDelimiter = rs.getString("column_delimiter");
        this.totalImportedRecords = rs.getInt("total_imported_records");
        this.totalFailedRecords = rs.getInt("total_failed_records");
        this.statusId = rs.getInt("status_id");
        this.fileType = rs.getInt("file_type");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.rating = DatabaseUtils.getInt(rs, "rating");
        this.comments = rs.getString("comments");
    }
}

