/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.Import;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ImportList
extends ArrayList {
    public static final String tableName = "import";
    public static final String uniqueField = "import_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int enteredBy = -1;
    private String enteredIdRange = null;
    private boolean controlledHierarchyOnly = false;
    private PagedListInfo pagedListInfo = null;
    private ImportManager manager = null;
    private int type = -1;
    private int ignoreStatusId = 8;
    private SystemStatus systemStatus = null;
    private int siteId = -1;
    private boolean includeImportsApplicableToAllSites = false;
    private boolean buildFileDetails = true;

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setManager(ImportManager tmp) {
        this.manager = tmp;
    }

    public ImportManager getManager() {
        return this.manager;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setIgnoreStatusId(int tmp) {
        this.ignoreStatusId = tmp;
    }

    public void setIgnoreStatusId(String tmp) {
        this.ignoreStatusId = Integer.parseInt(tmp);
    }

    public int getIgnoreStatusId() {
        return this.ignoreStatusId;
    }

    public boolean getBuildFileDetails() {
        return this.buildFileDetails;
    }

    public void setBuildFileDetails(boolean tmp) {
        this.buildFileDetails = tmp;
    }

    public void setBuildFileDetails(String tmp) {
        this.buildFileDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public void setControlledHierarchyOnly(boolean tmp) {
        this.controlledHierarchyOnly = tmp;
    }

    public void setControlledHierarchyOnly(String tmp) {
        this.controlledHierarchyOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getControlledHierarchyOnly() {
        return this.controlledHierarchyOnly;
    }

    public void setEnteredIdRange(String tmp) {
        this.enteredIdRange = tmp;
    }

    public String getEnteredIdRange() {
        return this.enteredIdRange;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getType() {
        return this.type;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setIncludeImportsApplicableToAllSites(boolean tmp) {
        this.includeImportsApplicableToAllSites = tmp;
    }

    public void setIncludeImportsApplicableToAllSites(String tmp) {
        this.includeImportsApplicableToAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public boolean getIncludeImportsApplicableToAllSites() {
        return this.includeImportsApplicableToAllSites;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM import m WHERE m.import_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND m.entered > ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("m.entered", "DESC");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY m.entered DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("m.import_id, m." + DatabaseUtils.addQuotes(db, "type") + ", m.name, m.description, m.source_type, m.source, " + "m.record_delimiter, m.column_delimiter, m.total_imported_records, m.total_failed_records, " + "m.status_id, m.file_type, m.entered, m.enteredby, m.modified, m.modifiedby, m.site_id, m.rating, m.comments " + "FROM import m " + "WHERE m.import_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Import thisImport = new Import(rs);
            thisImport.setSystemStatus(this.systemStatus);
            this.add(thisImport);
        }
        rs.close();
        pst.close();
        for (Import thisImport : this) {
            if (this.buildFileDetails) {
                thisImport.buildFileDetails(db);
            }
            if (this.manager == null) continue;
            Object activeImport = this.manager.getImport(thisImport.getId());
            if (!thisImport.isRunning() || activeImport != null) continue;
            thisImport.updateStatus(db, 4);
        }
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.ignoreStatusId != -1) {
            sqlFilter.append("AND m.status_id != ? ");
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND m.enteredby = ? ");
        }
        if (this.controlledHierarchyOnly) {
            sqlFilter.append("AND m.enteredby IN (" + this.enteredIdRange + ") ");
        }
        if (this.type != -1) {
            sqlFilter.append("AND m." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        }
        if (this.siteId != -1) {
            sqlFilter.append("AND ");
            if (this.includeImportsApplicableToAllSites) {
                sqlFilter.append(" ( ");
            }
            sqlFilter.append("m.site_id = ? ");
            if (this.includeImportsApplicableToAllSites) {
                sqlFilter.append("OR m.site_id IS NULL ) ");
            }
        }
        if (this.siteId == -1 && this.includeImportsApplicableToAllSites) {
            sqlFilter.append("AND m.site_id IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND m.entered > ? ");
            }
            sqlFilter.append("AND m.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND m.modified > ? ");
            sqlFilter.append("AND m.entered < ? ");
            sqlFilter.append("AND m.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.ignoreStatusId != -1) {
            pst.setInt(++i, this.ignoreStatusId);
        }
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.type != -1) {
            pst.setInt(++i, this.type);
        }
        if (this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void updateRecordCounts() {
        Iterator i = this.iterator();
        if (this.manager != null) {
            while (i.hasNext()) {
                Import thisImport = (Import)((Object)i.next());
                Object tmpObj = this.manager.getImport(thisImport.getId());
                if (tmpObj == null) continue;
                Import activeImport = (Import)((Object)tmpObj);
                thisImport.setTotalImportedRecords(activeImport.getTotalImportedRecords());
                thisImport.setTotalFailedRecords(activeImport.getTotalFailedRecords());
                if (activeImport.getStatusId() == 2) {
                    thisImport.setStatusId(2);
                }
                if (activeImport.getStatusId() != 3) continue;
                thisImport.setStatusId(3);
            }
        }
    }
}

