/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.EmailAddress;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.modules.base.TextMessageAddress;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.SSLMessage;

public class Notification
extends Thread {
    public static final int EMAIL = 1;
    public static final int FAX = 2;
    public static final int LETTER = 3;
    public static final int EMAILFAX = 4;
    public static final int EMAILLETTER = 5;
    public static final int EMAILFAXLETTER = 6;
    public static final int IM = 7;
    public static final int SSL = 8;
    public static final int BROADCAST = 9;
    public static final String EMAIL_TEXT = "Email";
    public static final String FAX_TEXT = "Fax";
    public static final String LETTER_TEXT = "Letter";
    public static final String EMAILFAX_TEXT = "Email first, try Fax";
    public static final String EMAILLETTER_TEXT = "Email first, then Letter";
    public static final String EMAILFAXLETTER_TEXT = "Email first, try Fax, then Letter";
    public static final String IM_TEXT = "Instant Message";
    public static final String SSL_TEXT = "SSL Message";
    public static final String lf = System.getProperty("line.separator");
    String faxLogEntry = null;
    Contact contact = null;
    private int id = -1;
    private String databaseName = null;
    private String emailToNotify = null;
    private int userToNotify = -1;
    private int contactToNotify = -1;
    private String module = null;
    private int itemId = -1;
    private Timestamp itemModified = null;
    private String from = null;
    private String subject = null;
    private int messageIdToSend = -1;
    private String messageToSend = null;
    private int type = -1;
    private String typeText = null;
    private String host = "127.0.0.1";
    private int port = -1;
    private String siteCode = null;
    private Timestamp attempt = null;
    private int result = 0;
    private String status = "";
    private String errorMessage = null;
    private Connection connection = null;
    private Object context = null;
    private FileItemList fileAttachments = null;
    private long size = 0L;
    private String bcc = null;
    private String cc = null;
    private int campaignType = -1;

    public Notification() {
    }

    public Notification(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Notification(int thisType) {
        this.setType(thisType);
    }

    public Notification(int thisType, ActionContext context) {
        this.setType(thisType);
        this.context = context;
    }

    public void setUserToNotify(int tmp) {
        this.userToNotify = tmp;
    }

    public void setUserToNotify(String tmp) {
        this.userToNotify = Integer.parseInt(tmp);
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setAttempt(String tmp) {
        this.attempt = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setResult(String tmp) {
        this.result = Integer.parseInt(tmp);
    }

    public void setContactToNotify(int tmp) {
        this.contactToNotify = tmp;
    }

    public void setEmailToNotify(String tmp) {
        this.emailToNotify = tmp;
    }

    public void setDatabaseName(String tmp) {
        this.databaseName = tmp;
    }

    public void setModule(String tmp) {
        this.module = tmp;
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemModified(Timestamp tmp) {
        this.itemModified = tmp;
    }

    public void setMessageIdToSend(int tmp) {
        this.messageIdToSend = tmp;
    }

    public void setMessageToSend(String tmp) {
        this.messageToSend = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
        switch (this.type) {
            case 1: {
                this.setTypeText(EMAIL_TEXT);
                break;
            }
            case 2: {
                this.setTypeText(FAX_TEXT);
                break;
            }
            case 3: {
                this.setTypeText(LETTER_TEXT);
                break;
            }
            case 4: {
                this.setTypeText(EMAILFAX_TEXT);
                break;
            }
            case 5: {
                this.setTypeText(EMAILLETTER_TEXT);
                break;
            }
            case 6: {
                this.setTypeText(EMAILFAXLETTER_TEXT);
                break;
            }
            case 7: {
                this.setTypeText(IM_TEXT);
                break;
            }
            case 8: {
                this.setTypeText(SSL_TEXT);
                break;
            }
        }
    }

    public void setTypeText(String tmp) {
        this.typeText = tmp;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setFrom(String tmp) {
        this.from = tmp;
    }

    public void setSiteCode(String tmp) {
        this.siteCode = tmp;
    }

    public void setPort(int tmp) {
        this.port = tmp;
    }

    public void setHost(String tmp) {
        this.host = tmp;
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public void setFileAttachments(FileItemList tmp) {
        this.fileAttachments = tmp;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public Timestamp getAttempt() {
        return this.attempt;
    }

    public int getResult() {
        return this.result;
    }

    public String getStatus() {
        return this.status;
    }

    public int getType() {
        return this.type;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFaxLogEntry() {
        return this.faxLogEntry;
    }

    public Contact getContact() {
        return this.contact;
    }

    public FileItemList getFileAttachments() {
        return this.fileAttachments;
    }

    public long getSize() {
        return this.size;
    }

    public int getUserToNotify() {
        return this.userToNotify;
    }

    public String getModule() {
        return this.module;
    }

    public int getItemId() {
        return this.itemId;
    }

    public Timestamp getItemModified() {
        return this.itemModified;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessageToSend() {
        return this.messageToSend;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String tmp) {
        this.bcc = tmp;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String tmp) {
        this.cc = tmp;
    }

    public void setCampaignType(int tmp) {
        this.campaignType = tmp;
    }

    public void setCampaignType(String tmp) {
        this.campaignType = Integer.parseInt(tmp);
    }

    public int getCampaignType() {
        return this.campaignType;
    }

    public boolean isNew(Connection db) {
        int resultCheck = -1;
        try {
            String sql = "SELECT * FROM notification WHERE notify_user = " + (this.userToNotify > -1 ? this.userToNotify : this.contactToNotify) + " " + "AND " + DatabaseUtils.addQuotes(db, "module") + " = ? " + "AND item_id = " + this.itemId + " " + "AND item_modified = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setString(++i, this.module);
            if (this.itemModified == null) {
                pst.setNull(++i, 91);
            } else {
                pst.setTimestamp(++i, this.itemModified);
            }
            ResultSet rs = pst.executeQuery();
            resultCheck = rs.next() ? 1 : 0;
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            this.errorMessage = e.toString();
            ++this.result;
        }
        return resultCheck == 0;
    }

    public boolean hasErrors() {
        return this.result > 0;
    }

    public void insertNotification(Connection db) {
        try {
            this.id = DatabaseUtils.getNextSeq(db, "notification_notification_i_seq");
            String sql = "INSERT INTO notification (" + (this.id > -1 ? "notification_id, " : "") + "notify_user, " + DatabaseUtils.addQuotes(db, "module") + ", item_id, item_modified, notify_type, subject, " + DatabaseUtils.addQuotes(db, "message") + ", result, errorMessage) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.userToNotify > -1) {
                pst.setInt(++i, this.userToNotify);
            } else {
                pst.setInt(++i, this.contactToNotify);
            }
            pst.setString(++i, this.module);
            pst.setInt(++i, this.itemId);
            if (this.itemModified == null) {
                pst.setNull(++i, 91);
            } else {
                pst.setTimestamp(++i, this.itemModified);
            }
            pst.setString(++i, this.typeText);
            pst.setString(++i, this.subject);
            pst.setString(++i, this.messageToSend);
            pst.setInt(++i, this.result);
            pst.setString(++i, this.errorMessage);
            pst.executeUpdate();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "notification_notification_i_seq", this.id);
        }
        catch (SQLException e) {
            this.errorMessage = e.toString();
            ++this.result;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean notifyAddress() {
        if (this.type <= -1) {
            System.out.println("Notification-> Type not set");
            return false;
        }
        try {
            if (this.type == 1) {
                if (this.emailToNotify == null || "".equals(this.emailToNotify.trim())) {
                    this.result = 2;
                    return false;
                }
                System.out.println("Notification-> notifyAddress: " + this.emailToNotify);
                SMTPMessage mail = new SMTPMessage();
                mail.setHost(this.host);
                mail.setFrom(this.from);
                if (this.from != null && !this.from.equals("")) {
                    mail.addReplyTo(this.from);
                }
                mail.setType("text/html");
                mail.addTo(this.emailToNotify);
                mail.setSubject(this.subject);
                mail.setBody(this.messageToSend);
                mail.setAttachments(this.fileAttachments);
                if (mail.send() != 2) return true;
                System.out.println("Send error: " + mail.getErrorMsg() + "<br><br>");
                System.err.println("ReportBuilder Error: Report could not be sent");
                System.err.println(mail.getErrorMsg());
                return true;
            }
            if (this.type == 7) {
                return true;
            }
            if (this.type == 2) {
                return true;
            }
            if (this.type != 8) return true;
            return true;
        }
        catch (Exception e) {
            this.result = 2;
            this.errorMessage = e.toString();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyUser(Connection db) {
        if (this.type > -1) {
            try {
                User thisUser = new User();
                thisUser.setBuildContact(true);
                thisUser.setBuildContactDetails(true);
                thisUser.buildRecord(db, this.userToNotify);
                if (this.type == 1) {
                    System.out.println("Notification-> notifyUser: " + thisUser.getContact().getPrimaryEmailAddress());
                    SMTPMessage mail = new SMTPMessage();
                    mail.setHost(this.host);
                    mail.setFrom(this.from);
                    if (this.from != null && !this.from.equals("")) {
                        mail.addReplyTo(this.from);
                    }
                    mail.setType("text/html");
                    mail.addTo(thisUser.getContact().getPrimaryEmailAddress());
                    mail.setSubject(this.subject);
                    mail.setBody(this.messageToSend);
                    mail.setAttachments(this.fileAttachments);
                    if (mail.send() == 2) {
                        System.out.println("Send error: " + mail.getErrorMsg() + "<br><br>");
                        System.err.println("ReportBuilder Error: Report could not be sent");
                        System.err.println(mail.getErrorMsg());
                        return;
                    } else {
                        this.insertNotification(db);
                    }
                    return;
                }
                if (this.type != 7 && this.type != 2 && this.type != 8) return;
            }
            catch (Exception e) {
                this.result = 2;
                this.errorMessage = e.toString();
            }
            return;
        }
        System.out.println("Notification-> Type not set");
        {
            // empty if block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyContact(Connection db) {
        if (this.type > -1) {
            try {
                Contact thisContact = new Contact(db, String.valueOf(this.contactToNotify));
                if (this.type == 6) {
                    this.type = "".equals(thisContact.getPrimaryEmailAddress()) && thisContact.getPhoneNumber("Business Fax").equals("") && thisContact.getPrimaryAddress() != null ? 3 : 4;
                }
                if (this.type == 4) {
                    this.type = "".equals(thisContact.getPrimaryEmailAddress()) && !thisContact.getPhoneNumber("Business Fax").equals("") ? 2 : 1;
                } else if (this.type == 5) {
                    this.type = "".equals(thisContact.getPrimaryEmailAddress()) && thisContact.getPrimaryAddress() != null ? 3 : 1;
                }
                if (this.type == 1) {
                    if (this.campaignType == 1 && thisContact.getNoEmail()) {
                        this.status = "Email opt out";
                        return;
                    } else {
                        System.out.println("Notification-> notifyContact: " + thisContact.getPrimaryEmailAddress());
                        SMTPMessage mail = new SMTPMessage();
                        mail.setHost(this.host);
                        mail.setFrom(this.from);
                        if (this.from != null && !this.from.equals("")) {
                            mail.addReplyTo(this.from);
                        }
                        if (this.bcc != null && !"".equals(this.bcc)) {
                            mail.setBcc(this.bcc);
                        }
                        if (this.cc != null && !"".equals(this.cc)) {
                            mail.setCc(this.cc);
                        }
                        mail.setType("text/html");
                        mail.addTo(thisContact.getPrimaryEmailAddress());
                        mail.setSubject(this.subject);
                        mail.setBody(this.messageToSend);
                        mail.setAttachments(this.fileAttachments);
                        int errorCode = mail.send();
                        if (errorCode > 0) {
                            this.status = "Email Error";
                            System.out.println("Send error: " + mail.getErrorMsg() + "<br><br>");
                            System.err.println("ReportBuilder Error: Report could not be sent");
                            System.err.println(mail.getErrorMsg());
                            return;
                        } else {
                            this.status = "Email Sent";
                            this.insertNotification(db);
                            this.size = (long)(this.subject.length() + this.messageToSend.length()) + this.fileAttachments.getFileSize();
                        }
                    }
                    return;
                }
                if (this.type == 7) {
                    this.status = this.campaignType == 1 && thisContact.getNoInstantMessage() ? "IM opt out" : "IM Sent";
                    return;
                }
                if (this.type == 9) {
                    SMTPMessage mail = new SMTPMessage();
                    mail.setHost(this.host);
                    mail.setFrom(this.from);
                    if (this.from != null && !this.from.equals("")) {
                        mail.addReplyTo(this.from);
                    }
                    mail.setType("text/html");
                    boolean canEmail = false;
                    if (this.campaignType != 1 || !thisContact.getNoEmail()) {
                        canEmail = true;
                        Iterator itr = thisContact.getEmailAddressList().iterator();
                        if (itr.hasNext()) {
                            while (itr.hasNext()) {
                                EmailAddress tmpEmailAddress = (EmailAddress)((Object)itr.next());
                                mail.addTo(tmpEmailAddress.getEmail());
                            }
                        }
                    }
                    boolean canPage = true;
                    Iterator itr = thisContact.getTextMessageAddressList().iterator();
                    if (itr.hasNext()) {
                        while (itr.hasNext()) {
                            TextMessageAddress tmpTextMessageAddress = (TextMessageAddress)itr.next();
                            mail.addTo(tmpTextMessageAddress.getTextMessageAddress());
                        }
                    }
                    mail.setSubject(this.subject);
                    mail.setBody(this.messageToSend);
                    mail.setAttachments(this.fileAttachments);
                    int errorCode = mail.send();
                    if (errorCode > 0) {
                        this.status = "Email Error";
                        System.out.println("Send error: " + mail.getErrorMsg() + "<br><br>");
                        System.err.println("ReportBuilder Error: Report could not be sent");
                        System.err.println(mail.getErrorMsg());
                        return;
                    } else {
                        if (canEmail && canPage) {
                            this.status = "Broadcast Sent";
                        } else {
                            if (!canEmail) {
                                this.status = "Email Opt Out";
                            }
                            if (!canPage) {
                                this.status = "Text Message Opt Out";
                            }
                            if (!canEmail && !canPage) {
                                this.status = "Email and Text Message Opt Out";
                            }
                        }
                        this.insertNotification(db);
                        this.size = (long)(this.subject.length() + this.messageToSend.length()) + this.fileAttachments.getFileSize();
                    }
                    return;
                }
                if (this.type == 2) {
                    String phoneNumber = thisContact.getPhoneNumber("Business Fax");
                    System.out.println("Notification-> To: " + phoneNumber);
                    if (this.campaignType == 1 && thisContact.getNoFax()) {
                        this.status = "Fax opt out";
                        return;
                    } else {
                        if (phoneNumber.equals("") || phoneNumber.length() <= 0) return;
                        if ((phoneNumber = PhoneNumber.convertToNumber(phoneNumber)).startsWith("1")) {
                            phoneNumber = phoneNumber.substring(1);
                        }
                        phoneNumber = phoneNumber.startsWith("757") ? phoneNumber.substring(3) : "1" + phoneNumber;
                        System.out.println("Notification-> Will send fax to: " + phoneNumber);
                        this.faxLogEntry = this.databaseName + "|" + this.messageIdToSend + "|" + phoneNumber + "|" + thisContact.getId();
                        this.status = "Fax Queued";
                    }
                    return;
                }
                if (this.type == 3) {
                    this.contact = thisContact;
                    this.status = this.campaignType != 1 || !thisContact.getNoMail() ? "Added to Report" : "Mail opt out";
                    return;
                }
                if (this.type != 8) return;
            }
            catch (Exception e) {
                this.result = 2;
                this.errorMessage = e.toString();
                e.printStackTrace(System.out);
            }
            return;
        }
        System.out.println("Notification-> Type not set");
        {
            // empty if block
        }
    }

    public void notifySystem() throws Exception {
        if (this.type == 8) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Notification-> SENDING SSL NOTIFICATION");
            }
            SSLMessage thisMessage = new SSLMessage();
            thisMessage.setUrl(this.host);
            thisMessage.setPort(this.port);
            thisMessage.setMessage(this.messageToSend);
            if (this.context != null) {
                if (this.context instanceof ActionContext) {
                    thisMessage.setKeystoreLocation((String)((ActionContext)this.context).getServletContext().getAttribute("ClientSSLKeystore"));
                    thisMessage.setKeystorePassword((String)((ActionContext)this.context).getServletContext().getAttribute("ClientSSLKeystorePassword"));
                } else if (this.context instanceof ComponentContext) {
                    thisMessage.setKeystoreLocation((String)((ComponentContext)this.context).getAttribute("ClientSSLKeystore"));
                    thisMessage.setKeystorePassword((String)((ComponentContext)this.context).getAttribute("ClientSSLKeystorePassword"));
                }
            }
            this.result = thisMessage.send();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Notification->SEND RESULT: " + this.result);
            }
        }
    }

    public void send() {
        this.start();
    }

    public void send(Connection db) {
        this.connection = db;
        this.start();
    }

    public void send(ActionContext context) {
        this.context = context;
        this.start();
    }

    public void run() {
        try {
            if (this.userToNotify > -1) {
                this.notifyUser(this.connection);
            } else if (this.contactToNotify > -1) {
                this.notifyContact(this.connection);
            } else {
                this.notifySystem();
            }
        }
        catch (Exception ignore) {
            ignore.printStackTrace(System.out);
            this.result = 1;
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("notification_id");
        this.userToNotify = rs.getInt("notify_user");
        this.module = rs.getString("module");
        this.itemId = rs.getInt("item_id");
        this.itemModified = rs.getTimestamp("item_modified");
        this.attempt = rs.getTimestamp("attempt");
        this.typeText = rs.getString("notify_type");
        this.subject = rs.getString("subject");
        this.messageToSend = rs.getString("message");
        this.result = rs.getInt("result");
        this.errorMessage = rs.getString("errorMessage");
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("==[ NOTIFICATION ]============================").append(lf);
        text.append("User to notify: ").append(this.userToNotify).append(lf);
        text.append("Module: ").append(this.module).append(lf);
        text.append("Item Id: ").append(this.itemId).append(lf);
        text.append("Item Modified: ").append(this.itemModified).append(lf);
        text.append("Subject: ").append(this.subject).append(lf);
        text.append("From: ").append(this.from).append(lf);
        text.append("Message: ").append(this.messageToSend).append(lf);
        text.append("Type: ").append(this.type).append(lf);
        text.append("==============================================");
        return text.toString();
    }

    public static ArrayList recordList(Connection db) throws SQLException {
        ArrayList<Notification> records = new ArrayList<Notification>();
        PreparedStatement pst = db.prepareStatement("SELECT * FROM notification WHERE notification_id > -1 ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            Notification notification = new Notification(rs);
            records.add(notification);
        }
        rs.close();
        pst.close();
        return records;
    }
}

