/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class NotificationMessage
extends GenericBean {
    private int id = -1;
    private int notifyUser = -1;
    private String module = null;
    private int itemId = -1;
    private Timestamp itemModified = null;
    private Timestamp attempt = null;
    private String notifyType = null;
    private String subject = null;
    private String message = null;
    private int result = -1;
    private String errorMessage = null;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getNotifyUser() {
        return this.notifyUser;
    }

    public void setNotifyUser(int tmp) {
        this.notifyUser = tmp;
    }

    public void setNotifyUser(String tmp) {
        this.notifyUser = Integer.parseInt(tmp);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String tmp) {
        this.module = tmp;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public Timestamp getItemModified() {
        return this.itemModified;
    }

    public void setItemModified(Timestamp tmp) {
        this.itemModified = tmp;
    }

    public void setItemModified(String tmp) {
        this.itemModified = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getAttempt() {
        return this.attempt;
    }

    public void setAttempt(Timestamp tmp) {
        this.attempt = tmp;
    }

    public void setAttempt(String tmp) {
        this.attempt = DatabaseUtils.parseTimestamp(tmp);
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(String tmp) {
        this.notifyType = tmp;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String tmp) {
        this.message = tmp;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int tmp) {
        this.result = tmp;
    }

    public void setResult(String tmp) {
        this.result = Integer.parseInt(tmp);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String tmp) {
        this.errorMessage = tmp;
    }

    public NotificationMessage() {
    }

    public NotificationMessage(Connection db, int notificationId) throws SQLException {
        this.queryRecord(db, notificationId);
    }

    public NotificationMessage(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int notificationId) throws SQLException {
        if (notificationId == -1) {
            throw new SQLException("Invalid Notification ID specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT n.* FROM notification n WHERE n.notification_id = ? ");
        pst.setInt(1, notificationId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Record Not Found");
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("notification_id");
        this.notifyUser = rs.getInt("notify_user");
        this.module = rs.getString("module");
        this.itemId = rs.getInt("item_id");
        this.itemModified = rs.getTimestamp("item_modified");
        this.attempt = rs.getTimestamp("attempt");
        this.notifyType = rs.getString("notify_type");
        this.subject = rs.getString("subject");
        this.message = rs.getString("message");
        this.result = rs.getInt("result");
        this.errorMessage = rs.getString("errorMessage");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "notification_notification_i_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO notification (notify_user, " + DatabaseUtils.addQuotes(db, "module") + ", item_id, item_modified, attempt, notify_type, " + "subject, " + DatabaseUtils.addQuotes(db, "message") + ", ");
        if (this.id > -1) {
            sql.append("notification_id, ");
        }
        sql.append("result, errorMessage) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.notifyUser);
        pst.setString(++i, this.module);
        pst.setInt(++i, this.itemId);
        pst.setTimestamp(++i, this.itemModified);
        pst.setTimestamp(++i, this.attempt);
        pst.setString(++i, this.notifyType);
        pst.setString(++i, this.subject);
        pst.setString(++i, this.message);
        if (this.getId() > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.result);
        pst.setString(++i, this.errorMessage);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "notification_notification_i_seq", this.id);
        return true;
    }
}

