/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class PhoneNumber {
    public static final int BUSINESS = 1;
    protected boolean isContact = false;
    private int id = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int type = -1;
    private String typeName = "Main";
    private String number = "";
    private String extension = "";
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean primaryNumber = false;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.setId(Integer.parseInt(tmp));
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setNumber(String tmp) {
        this.number = tmp;
    }

    public void setExtension(String tmp) {
        this.extension = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setPrimaryNumber(boolean tmp) {
        this.primaryNumber = tmp;
    }

    public void setPrimaryNumber(String tmp) {
        this.primaryNumber = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getPrimaryNumber() {
        return this.primaryNumber;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public boolean isValid() {
        return this.type > -1 && this.number != null && !this.number.trim().equals("") || !this.enabled;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getNumber() {
        return this.number;
    }

    public String getExtension() {
        return this.extension;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public String getPhoneNumber() {
        if (this.extension != null && !this.extension.equals("")) {
            return this.getNumber() + " x" + this.getExtension();
        }
        return this.getNumber();
    }

    public String getAreaCode() {
        if (this.getNumber().length() == 12) {
            return this.getNumber().substring(0, 3);
        }
        return "";
    }

    public String getPrefix() {
        if (this.getNumber().length() == 12) {
            return this.getNumber().substring(4, 7);
        }
        if (this.getNumber().length() == 8) {
            return this.getNumber().substring(0, 3);
        }
        return "";
    }

    public String getPostfix() {
        if (this.getNumber().length() == 12) {
            return this.getNumber().substring(8, 12);
        }
        if (this.getNumber().length() == 8) {
            return this.getNumber().substring(4, 8);
        }
        if (this.getNumber().length() > 0) {
            return this.getNumber();
        }
        return "";
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("phone_id"));
        if (!this.isContact) {
            this.setOrgId(rs.getInt("org_id"));
            if (rs.wasNull()) {
                this.setOrgId(-1);
            }
        } else {
            this.setContactId(rs.getInt("contact_id"));
            if (rs.wasNull()) {
                this.setContactId(-1);
            }
        }
        this.setType(rs.getInt("phone_type"));
        if (rs.wasNull()) {
            this.setType(-1);
        }
        this.setNumber(rs.getString("number"));
        this.setExtension(rs.getString("extension"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setEnteredBy(rs.getInt("enteredby"));
        if (this.enteredBy == -1) {
            this.setEnteredBy(0);
        }
        this.setModified(rs.getTimestamp("modified"));
        this.setModifiedBy(rs.getInt("modifiedby"));
        this.setPrimaryNumber(rs.getBoolean("primary_number"));
        this.setTypeName(rs.getString("description"));
        if (this.modifiedBy == -1) {
            this.setModifiedBy(0);
        }
    }

    public void buildRecord(ActionContext context, int parseItem) {
        String action;
        this.setType(context.getRequest().getParameter("phone" + parseItem + "type"));
        StringBuffer thisString = new StringBuffer();
        if (context.getRequest().getParameter("phone" + parseItem + "number") != null && !context.getRequest().getParameter("phone" + parseItem + "number").trim().equals("")) {
            thisString.append(PhoneNumber.convertToFormattedNumber(context, context.getRequest().getParameter("phone" + parseItem + "number")));
        }
        this.setNumber(thisString.toString());
        this.setExtension(context.getRequest().getParameter("phone" + parseItem + "ext"));
        if (context.getRequest().getParameter("phone" + parseItem + "delete") != null && (action = context.getRequest().getParameter("phone" + parseItem + "delete").toLowerCase()).equals("on")) {
            this.setEnabled(false);
        }
        if (context.getRequest().getParameter("phone" + parseItem + "id") != null) {
            this.setId(context.getRequest().getParameter("phone" + parseItem + "id"));
        }
    }

    public static final String convertToNumber(String tmp) {
        tmp = tmp.trim();
        StringBuffer sb = new StringBuffer();
        String allowed = "0123456789";
        for (int i = 0; i < tmp.length(); ++i) {
            String theChar = tmp.substring(i, i + 1);
            if (allowed.indexOf(theChar) > -1) {
                sb.append(theChar);
            }
            if (i != 0 || !theChar.equals("+")) continue;
            sb.append(theChar);
        }
        return sb.toString();
    }

    public static final String convertToFormattedNumber(ActionContext context, String tmp) {
        String tmpNum = "";
        tmpNum = tmp.indexOf("+") == 0 ? tmp : PhoneNumber.convertToNumber(tmp);
        StringBuffer result = new StringBuffer();
        String defaultCountry = ApplicationPrefs.getPref(context.getServletContext(), "SYSTEM.COUNTRY");
        if (tmpNum.indexOf("+") == -1 && "UNITED STATES".equals(defaultCountry)) {
            if (tmpNum.length() == 11 && tmpNum.charAt(0) == '1') {
                tmpNum = tmpNum.substring(1);
            }
            if (tmpNum.length() == 10) {
                result.append("(");
                result.append(tmpNum.substring(0, 3));
                result.append(") ");
                result.append(tmpNum.substring(3, 6));
                result.append("-");
                result.append(tmpNum.substring(6, 10));
            } else {
                result.append(tmpNum);
            }
        } else {
            result.append(tmpNum);
        }
        return result.toString();
    }
}

