/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PhoneNumberList
extends Vector {
    protected PagedListInfo pagedListInfo = null;
    protected int orgId = -1;
    protected int type = -1;
    protected int contactId = -1;
    protected String number = null;
    protected String extension = null;
    protected boolean usersOnly = false;

    protected void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    protected void setType(int tmp) {
        this.type = tmp;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setUsersOnly(boolean usersOnly) {
        this.usersOnly = usersOnly;
    }

    public String getPhoneNumber(String thisType) {
        for (PhoneNumber thisNumber : this) {
            if (!thisType.equals(thisNumber.getTypeName())) continue;
            return thisNumber.getPhoneNumber();
        }
        return "";
    }

    public String getPhoneNumber(int thisType) {
        for (PhoneNumber thisNumber : this) {
            if (thisType != thisNumber.getType()) continue;
            return thisNumber.getPhoneNumber();
        }
        return "";
    }

    public String getExtension(String tmpNumber) {
        Iterator i = this.iterator();
        System.out.println("tmpNumber " + tmpNumber);
        while (i.hasNext()) {
            PhoneNumber thisNumber = (PhoneNumber)i.next();
            if (!tmpNumber.equals(thisNumber.getPhoneNumber())) continue;
            return thisNumber.getExtension();
        }
        return "";
    }

    public String getPrimaryPhoneNumber() {
        Iterator i = this.iterator();
        PhoneNumber thisNumber = null;
        while (i.hasNext() && !(thisNumber = (PhoneNumber)i.next()).getPrimaryNumber()) {
        }
        return thisNumber == null ? "" : thisNumber.getPhoneNumber();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND org_id = ? ");
        }
        if (this.type != -1) {
            sqlFilter.append("AND phone_type = ? ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND contact_id = ? ");
        }
        if (this.number != null) {
            sqlFilter.append("AND number = ? ");
        }
        if (this.extension != null) {
            sqlFilter.append("AND extension = ? ");
        }
        if (this.usersOnly) {
            sqlFilter.append("AND contact_id IN (SELECT contact_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE enabled = ? AND (expires IS NULL OR expires < CURRENT_TIMESTAMP)) ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.type != -1) {
            pst.setInt(++i, this.type);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.number != null) {
            pst.setString(++i, this.number);
        }
        if (this.extension != null) {
            pst.setString(++i, this.extension);
        }
        if (this.usersOnly) {
            pst.setBoolean(++i, true);
        }
        return i;
    }
}

