/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.base.ReportCell;
import org.aspcfs.modules.base.ReportColumn;
import org.aspcfs.modules.base.ReportRow;
import org.aspcfs.utils.StringUtils;

public class Report {
    private int id = 0;
    private int enteredById = 0;
    private String header = null;
    private String footer = null;
    private String subject = "";
    private String category = "";
    private Date timestamp = new Date();
    private Vector columns = new Vector();
    private Vector rows = new Vector();
    private String delimitedCharacter = "\t";
    private boolean sorted = false;
    private int compareColumn = 0;
    private int borderSize = 1;
    private boolean showColumnHeaderWhenNoRecords = false;
    private boolean showColumnHeaders = true;
    protected static boolean newLine = true;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredById = tmp;
    }

    public void setHeader(String tmp) {
        this.header = tmp;
    }

    public void setFooter(String tmp) {
        this.footer = tmp;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setCategory(String tmp) {
        this.category = tmp;
    }

    public void setDelimitedCharacter(String tmp) {
        this.delimitedCharacter = tmp;
    }

    public void setBorderSize(int tmp) {
        this.borderSize = tmp;
    }

    public void setShowColumnHeaderWhenNoRecords(boolean tmp) {
        this.showColumnHeaderWhenNoRecords = tmp;
    }

    public void setShowColumnHeaders(boolean tmp) {
        this.showColumnHeaders = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getEnteredBy() {
        return this.enteredById;
    }

    public String getHeader() {
        return this.header;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getCategory() {
        return this.category;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getHtml() {
        Iterator i = null;
        StringBuffer html = new StringBuffer();
        html.append("<table border='" + this.borderSize + "'>");
        if (this.header != null) {
            html.append("<tr><td colspan='" + this.columns.size() + "'>" + this.header + "</td></tr>");
        }
        if ((this.showColumnHeaderWhenNoRecords && this.rows.size() == 0 || this.rows.size() > 0) && this.showColumnHeaders) {
            html.append("<tr>");
            for (ReportColumn thisColumn : this.columns) {
                html.append("<td");
                if (thisColumn.isFormatted()) {
                    html.append(" " + thisColumn.getFormatting());
                } else {
                    html.append(" valign='top' bgcolor='#FFFFFF' nowrap");
                }
                html.append(">");
                html.append(thisColumn.getHtmlName());
                html.append("</td>");
            }
            html.append("</tr>");
        }
        i = this.rows.iterator();
        while (i.hasNext()) {
            html.append("<tr>");
            ReportRow thisRow = (ReportRow)i.next();
            Vector cells = thisRow.getCells();
            for (ReportCell thisCell : cells) {
                html.append("<td");
                if (thisCell.isFormatted()) {
                    html.append(" " + thisCell.getFormatting());
                } else {
                    html.append(" valign='top' nowrap");
                }
                html.append(">");
                html.append(this.check(thisCell.getData()));
                html.append("</td>");
            }
            html.append("</tr>");
        }
        if (this.footer != null) {
            html.append("<tr><td colspan='" + this.columns.size() + "'>" + this.footer + "</td></tr>");
        }
        html.append("</table>");
        return html.toString();
    }

    public String getDelimited() {
        StringBuffer ascii = new StringBuffer();
        Iterator i = null;
        if (this.header != null) {
            ascii.append(this.header + "\r\n");
        }
        if ((this.showColumnHeaderWhenNoRecords && this.rows.size() == 0 || this.rows.size() > 0) && this.showColumnHeaders) {
            for (ReportColumn thisColumn : this.columns) {
                String tmp = this.checkNull(thisColumn.getName());
                ascii.append(Report.prepareToWrite(tmp));
            }
            ascii.append("\r\n");
            newLine = true;
        }
        for (ReportRow thisRow : this.rows) {
            Vector cells = thisRow.getCells();
            for (ReportCell thisCell : cells) {
                String tmp = this.checkNull(thisCell.getData());
                ascii.append(Report.prepareToWrite(tmp));
            }
            ascii.append("\r\n");
            newLine = true;
        }
        if (this.footer != null) {
            ascii.append(this.footer + "\r\n");
        }
        return ascii.toString();
    }

    public void addColumn(String tmp) {
        ReportColumn rc = new ReportColumn(tmp);
        this.columns.addElement(rc);
    }

    public void addColumn(String tmp, String tmp2) {
        ReportColumn rc = new ReportColumn(tmp);
        rc.setHtmlName(tmp2);
        this.columns.addElement(rc);
    }

    public void addRow(ReportRow tmp) {
        this.rows.addElement(tmp);
    }

    public void sortByColumn(int tmp) {
        this.sortByColumn(tmp, "string");
    }

    public void sortByColumn(int tmp, String type) {
        this.compareColumn = tmp;
        Object[] sortArray = this.rows.toArray();
        Comparator comparator = null;
        comparator = type.equals("date") ? new cellComparatorDate() : (type.equals("int") ? new cellComparatorInt() : new cellComparatorString());
        Arrays.sort(sortArray, comparator);
        this.rows.clear();
        for (int i = 0; i < sortArray.length; ++i) {
            this.rows.addElement((ReportRow)sortArray[i]);
        }
    }

    public int saveHtml(String filename) throws IOException {
        File outputFile = new File(filename);
        FileWriter out = new FileWriter(outputFile);
        out.write(this.getHtml());
        out.close();
        return 0;
    }

    public int saveDelimited(String filename) throws IOException {
        File outputFile = new File(filename);
        FileWriter out = new FileWriter(outputFile);
        out.write(this.getDelimited());
        out.close();
        return 0;
    }

    private String check(String tmp) {
        if (tmp == null || tmp.trim().equals("")) {
            return "&nbsp;";
        }
        return tmp;
    }

    private String checkNull(String tmp) {
        if (tmp == null) {
            return "";
        }
        return tmp;
    }

    private static String prepareToWrite(String value) {
        StringBuffer ascii = new StringBuffer();
        boolean quote = false;
        if (value.length() > 0) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != '\"' && c != ',' && c != '\n' && c != '\r') continue;
                quote = true;
            }
        } else if (newLine) {
            quote = true;
        }
        if (newLine) {
            newLine = false;
        } else {
            ascii.append(",");
        }
        if (quote) {
            ascii.append(Report.escapeAndQuote(value));
        } else {
            ascii.append(value);
        }
        return ascii.toString();
    }

    private static String escapeAndQuote(String value) {
        String s = StringUtils.replace(value, "\"", "\"\"");
        return new StringBuffer(2 + s.length()).append("\"").append(s).append("\"").toString();
    }

    class cellComparatorDate
    implements Comparator {
        cellComparatorDate() {
        }

        public int compare(Object left, Object right) {
            return ((ReportRow)left).getCell(Report.this.compareColumn).compareDateTo(((ReportRow)right).getCell(Report.this.compareColumn));
        }
    }

    class cellComparatorInt
    implements Comparator {
        cellComparatorInt() {
        }

        public int compare(Object left, Object right) {
            return ((ReportRow)left).getCell(Report.this.compareColumn).compareIntTo(((ReportRow)right).getCell(Report.this.compareColumn));
        }
    }

    class cellComparatorString
    implements Comparator {
        cellComparatorString() {
        }

        public int compare(Object left, Object right) {
            return ((ReportRow)left).getCell(Report.this.compareColumn).compareTo(((ReportRow)right).getCell(Report.this.compareColumn));
        }
    }
}

