/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;

public class ReportCell
implements Comparable {
    private String data = "";
    private String formatting = "";
    private Comparator stringComparator = new cellComparator();
    private Comparator intComparator = new cellComparatorInt();
    private Comparator dateComparator = new cellComparatorDate();

    public ReportCell() {
    }

    public ReportCell(String tmp) {
        this.data = tmp;
    }

    public ReportCell(String tmp, String tmp2) {
        this.data = tmp;
        this.formatting = tmp2;
    }

    public void setData(String tmp) {
        this.data = tmp;
    }

    public void setFormatting(String tmp) {
        this.formatting = tmp;
    }

    public String getData() {
        return this.data;
    }

    public int getDataInt() {
        return Integer.parseInt(this.data);
    }

    public Date getDataDate() {
        try {
            DateFormat df = DateFormat.getDateInstance();
            Date date = df.parse(this.data);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getFormatting() {
        return this.formatting;
    }

    public boolean isFormatted() {
        return !this.formatting.equals("");
    }

    public int compareTo(Object object) {
        return this.stringComparator.compare(this, object);
    }

    public int compareIntTo(Object object) {
        return this.intComparator.compare(this, object);
    }

    public int compareDateTo(Object object) {
        return this.dateComparator.compare(this, object);
    }

    class cellComparatorDate
    implements Comparator {
        cellComparatorDate() {
        }

        public int compare(Object left, Object right) {
            return ((ReportCell)left).getDataDate().compareTo(((ReportCell)right).getDataDate());
        }
    }

    class cellComparatorInt
    implements Comparator {
        cellComparatorInt() {
        }

        public int compare(Object left, Object right) {
            return ((ReportCell)left).getDataInt() - ((ReportCell)right).getDataInt();
        }
    }

    class cellComparator
    implements Comparator {
        cellComparator() {
        }

        public int compare(Object left, Object right) {
            return ((ReportCell)left).getData().compareTo(((ReportCell)right).getData());
        }
    }
}

