/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.base;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.utils.DatabaseUtils;

public class TextMessageAddress {
    public static final int BUSINESS = 1;
    protected boolean isContact = false;
    private int id = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int type = -1;
    private String typeName = "Main";
    private String textMessageAddress = "";
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean primaryTextMessageAddress = false;

    public void setIsContact(boolean tmp) {
        this.isContact = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setTextMessageAddress(String tmp) {
        this.textMessageAddress = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setPrimaryTextMessageAddress(boolean tmp) {
        this.primaryTextMessageAddress = tmp;
    }

    public void setPrimaryTextMessageAddress(String tmp) {
        this.primaryTextMessageAddress = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIsContact() {
        return this.isContact;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTextMessageAddress() {
        return this.textMessageAddress;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getPrimaryTextMessageAddress() {
        return this.primaryTextMessageAddress;
    }

    public boolean isValid() {
        return this.type > -1 && this.textMessageAddress != null && !this.textMessageAddress.trim().equals("");
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("address_id"));
        if (!this.isContact) {
            this.setOrgId(rs.getInt("org_id"));
            if (rs.wasNull()) {
                this.setOrgId(-1);
            }
        } else {
            this.setContactId(rs.getInt("contact_id"));
            if (rs.wasNull()) {
                this.setContactId(-1);
            }
        }
        if (rs.wasNull()) {
            this.setType(-1);
        }
        this.setTextMessageAddress(rs.getString("textmessageaddress"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setEnteredBy(rs.getInt("enteredby"));
        if (this.enteredBy == -1) {
            this.setEnteredBy(0);
        }
        this.setModified(rs.getTimestamp("modified"));
        this.setModifiedBy(rs.getInt("modifiedby"));
        if (this.isContact) {
            this.setPrimaryTextMessageAddress(rs.getBoolean("primary_textmessage_address"));
        }
        this.setType(rs.getInt("textmessageaddress_type"));
        this.setTypeName(rs.getString("description"));
        if (this.modifiedBy == -1) {
            this.setModifiedBy(0);
        }
    }

    public void buildRecord(HttpServletRequest request, int parseItem) {
        String action;
        this.setType(request.getParameter("textmessage" + parseItem + "type"));
        if (request.getParameter("textmessage" + parseItem + "id") != null) {
            this.setId(request.getParameter("textmessage" + parseItem + "id"));
        }
        this.setTextMessageAddress(request.getParameter("textmessage" + parseItem + "address"));
        if (request.getParameter("textmessage" + parseItem + "delete") != null && (action = request.getParameter("textmessage" + parseItem + "delete").toLowerCase()).equals("on")) {
            this.setEnabled(false);
        }
    }

    public String toString() {
        return "=[Email Address]=============================================\r\n Id: " + this.getId() + "\r\n" + " Org Id: " + this.getOrgId() + "\r\n" + " Contact Id: " + this.getContactId() + "\r\n" + " Type: " + this.getType() + "\r\n" + " Type Name: " + this.getTypeName() + "\r\n" + " Email: " + this.getTextMessageAddress() + "\r\n" + " Entered By: " + this.getEnteredBy() + "\r\n" + " Modified By: " + this.getModifiedBy() + "\r\n";
    }
}

