/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.utils.web.PagedListInfo;

public final class CampaignDocuments
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            FileItemList documents = new FileItemList();
            documents.setLinkModuleId(17);
            documents.setLinkItemId(thisCampaign.getId());
            PagedListInfo CampaignDocListInfo = this.getPagedListInfo(context, "CampaignDocListInfo");
            CampaignDocListInfo.setLink("CampaignDocuments.do?command=View&id=" + thisCampaign.getId());
            documents.setPagedListInfo(CampaignDocListInfo);
            documents.buildList(db);
            context.getRequest().setAttribute("FileItemList", (Object)documents);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "View Documents");
        if (errorMessage == null) {
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Upload Document");
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            Campaign thisCampaign;
            String filePath = this.getPath(context, "campaign");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (!this.hasAuthority(context, (thisCampaign = this.addCampaign(context, db = this.getConnection(context), id)).getEnteredBy())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + thisCampaign.getId());
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(17);
                thisItem.setLinkItemId(thisCampaign.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        if (itemId == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        if ((folderId = context.getRequest().getParameter("folderId")) != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), thisCampaign.getId(), 17);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Upload New Document Version");
        if (errorMessage == null) {
            return "AddVersionOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "campaign");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            db = this.getConnection(context);
            String id = (String)parts.get("id");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            Campaign thisCampaign = this.addCampaign(context, db, id);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(17);
                thisItem.setLinkItemId(thisCampaign.getId());
                thisItem.setId(Integer.parseInt(itemId));
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(Double.parseDouble(versionId));
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insertVersion(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisCampaign.getId(), 17);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Document Details");
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block24: {
            if (!this.hasPermission(context, "campaign-dashboard-view")) {
                return "PermissionError";
            }
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            FileItemVersion thisItem = null;
            SystemStatus systemStatus = this.getSystemStatus(context);
            Connection db = null;
            try {
                db = this.getConnection(context);
                Campaign thisCampaign = this.addCampaign(context, db);
                if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                    String string = "PermissionError";
                    return string;
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), thisCampaign.getId(), 17);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                FileItemVersion itemToDownload;
                if (version == null) {
                    itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "campaign") + CampaignDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (!fileDownload.fileExists()) {
                        db = null;
                        System.err.println("CampaignDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandView(context);
                        return string;
                    }
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block24;
                }
                itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "campaign") + CampaignDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block24;
                }
                db = null;
                System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "Dashboard", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisCampaign.getId(), 17);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Modify Document Information");
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisCampaign.getId(), 17);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            recordInserted = thisItem.update(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "");
        if (recordInserted) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("fid", (Object)itemId);
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Campaign thisCampaign = this.addCampaign(context, db);
            if (!this.hasAuthority(context, thisCampaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisCampaign.getId(), 17);
            if (thisItem.getEnteredBy() == this.getUserId(context)) {
                recordDeleted = thisItem.delete(db, this.getPath(context, "campaign"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Delete Document");
        if (recordDeleted) {
            return "DeleteOK";
        }
        return "DeleteERROR";
    }

    private Campaign addCampaign(ActionContext context, Connection db) throws SQLException {
        String campaignId = context.getRequest().getParameter("id");
        if (campaignId == null) {
            campaignId = (String)context.getRequest().getAttribute("id");
        }
        return this.addCampaign(context, db, campaignId);
    }

    private Campaign addCampaign(ActionContext context, Connection db, String campaignId) throws SQLException {
        context.getRequest().setAttribute("id", (Object)campaignId);
        Campaign thisCampaign = new Campaign(db, Integer.parseInt(campaignId));
        context.getRequest().setAttribute("Campaign", (Object)thisCampaign);
        return thisCampaign;
    }
}

