/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.ActiveSurvey;
import org.aspcfs.modules.communications.base.ActiveSurveyAnswerItemList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItemList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionList;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignList;
import org.aspcfs.modules.communications.base.CampaignReport;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.MessageList;
import org.aspcfs.modules.communications.base.RecipientList;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.communications.base.SearchCriteriaListList;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.communications.base.SurveyList;
import org.aspcfs.modules.communications.base.SurveyResponse;
import org.aspcfs.modules.communications.base.SurveyResponseList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class CampaignManager
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return "DefaultOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDashboard(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        this.resetPagedListInfo(context);
        Connection db = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignDashboardListInfo");
        pagedListInfo.setLink("CampaignManager.do?command=Dashboard");
        try {
            db = this.getConnection(context);
            CampaignList campaignList = new CampaignList();
            campaignList.setPagedListInfo(pagedListInfo);
            campaignList.setCompleteOnly(true);
            if ("all".equals(pagedListInfo.getListView())) {
                campaignList.setOwnerIdRange(this.getUserRange(context));
                campaignList.setUserGroupUserId(this.getUserId(context));
                campaignList.setType(1);
            } else if ("instant".equals(pagedListInfo.getListView())) {
                campaignList.setOwnerIdRange(this.getUserRange(context));
                campaignList.setUserGroupUserId(this.getUserId(context));
                campaignList.setType(2);
            } else if ("trashed".equals(pagedListInfo.getListView())) {
                campaignList.setOwnerIdRange(this.getUserRange(context));
                campaignList.setIncludeOnlyTrashed(true);
            } else {
                campaignList.setType(1);
                campaignList.setOwner(this.getUserId(context));
            }
            campaignList.buildList(db);
            context.getRequest().setAttribute("campList", (Object)campaignList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "Dashboard";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Campaign Dashboard");
        return "DashboardOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignListInfo");
        pagedListInfo.setLink("CampaignManager.do?command=View");
        this.deletePagedListInfo(context, "CampaignCenterGroupInfo");
        try {
            db = this.getConnection(context);
            CampaignList campaignList = new CampaignList();
            campaignList.setPagedListInfo(pagedListInfo);
            campaignList.setIncompleteOnly(true);
            if ("all".equals(pagedListInfo.getListView())) {
                campaignList.setOwnerIdRange(this.getUserRange(context));
            } else {
                campaignList.setOwner(this.getUserId(context));
            }
            campaignList.buildList(db);
            context.getRequest().setAttribute("campList", (Object)campaignList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageCampaigns";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Build New Campaign");
        return "ViewOK";
    }

    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-add")) {
            return "PermissionError";
        }
        if ("list".equals(context.getRequest().getParameter("source"))) {
            this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        } else {
            this.addModuleBean(context, "Add Campaign", "Build New Campaign");
        }
        try {
            context.getSession().removeAttribute("CampaignCenterGroupInfo");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        Campaign campaign = (Campaign)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            campaign.setEnteredBy(this.getUserId(context));
            campaign.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)campaign);
            if (isValid) {
                recordInserted = campaign.insert(db);
            }
            if (recordInserted) {
                campaign = new Campaign(db, campaign.getId());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        if (recordInserted) {
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Campaign Details");
        Connection db = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            FileItemList files = new FileItemList();
            files.setLinkModuleId(16);
            files.setLinkItemId(campaign.getId());
            files.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)files);
            if ("true".equals(context.getRequest().getParameter("reset"))) {
                context.getSession().removeAttribute("CampaignCenterGroupInfo");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Edit Campaign Details");
        Connection db = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign();
            campaign.setBuildGroupMaps(true);
            campaign.queryRecord(db, Integer.parseInt(campaignId));
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Campaign campaign = null;
        this.addModuleBean(context, "Dashboard", "View Groups");
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewGroupsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreviewGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, context.getRequest().getParameter("id"));
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            SearchCriteriaList thisSCL = new SearchCriteriaList(db, context.getRequest().getParameter("scl"));
            context.getRequest().setAttribute("SCL", (Object)thisSCL);
            if ("true".equals(context.getRequest().getParameter("reset"))) {
                context.getSession().removeAttribute("CampaignCenterPreviewInfo");
            }
            PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignCenterPreviewInfo");
            pagedListInfo.setLink("CampaignManager.do?command=PreviewGroups&id=" + campaign.getId() + "&scl=" + thisSCL.getId() + "&popup=true");
            ContactList contacts = new ContactList();
            contacts.setScl(thisSCL, campaign.getEnteredBy(), this.getUserRange(context, campaign.getEnteredBy()));
            contacts.setPagedListInfo(pagedListInfo);
            contacts.setCheckExcludedFromCampaign(campaign.getId());
            contacts.setIncludeAllSites(true);
            contacts.setBuildDetails(true);
            contacts.setBuildTypes(false);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 626030330);
            contacts.setGeneralContactAccessTypes(accessTypeList);
            contacts.buildList(db);
            context.getRequest().setAttribute("ContactList", (Object)contacts);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PreviewGroupsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandToggleRecipient(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact();
            thisContact.setBuildDetails(false);
            thisContact.setBuildTypes(false);
            thisContact.setId(Integer.parseInt(contactId));
            thisContact.build(db);
            thisContact.checkExcludedFromCampaign(db, Integer.parseInt(campaignId));
            thisContact.toggleExcluded(db, Integer.parseInt(campaignId));
            context.getRequest().setAttribute("recipientText", (Object)(thisContact.getExcludedFromCampaign() ? "No" : "Yes"));
        }
        catch (Exception e) {
            System.out.println(e.toString());
            String string = "ToggleERROR";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ToggleOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewMessage(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            MessageList messageList = new MessageList();
            messageList.setOwner(this.getUserId(context));
            messageList.setPersonalId(-2);
            messageList.buildList(db);
            if (campaign.getMessageId() > 0 && !messageList.hasId(campaign.getMessageId())) {
                messageList.clear();
                messageList.setOwner(-1);
                messageList.setControlledHierarchyOnly(true, this.getUserRange(context));
                messageList.buildList(db);
                context.getRequest().setAttribute("listView", (Object)"all");
            } else {
                context.getRequest().setAttribute("listView", (Object)"my");
            }
            messageList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("MessageList", (Object)messageList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreviewMessage(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Dashboard", "Build New Campaign");
        Connection db = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            FileItemList documents = new FileItemList();
            documents.setLinkModuleId(16);
            documents.setLinkItemId(Integer.parseInt(campaignId));
            documents.buildList(db);
            context.getRequest().setAttribute("FileItemList", (Object)documents);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PreviewMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadMessage(ActionContext context) {
        Exception errorMessage;
        block22: {
            if (!this.hasPermission(context, "campaign-dashboard-view")) {
                return "PermissionError";
            }
            errorMessage = null;
            SystemStatus systemStatus = this.getSystemStatus(context);
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            FileItem thisItem = null;
            Connection db = null;
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            try {
                db = this.getConnection(context);
                thisItem = new FileItem(db, Integer.parseInt(itemId), id, 16);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "communications") + CampaignManager.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (!fileDownload.fileExists()) {
                        db = null;
                        System.err.println("CampaignDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandPreviewMessage(context);
                        return string;
                    }
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block22;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "campaign") + CampaignManager.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block22;
                }
                db = null;
                System.err.println("CampaignMessage Documents -> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandPreviewMessage(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "Dashboard", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewAttachment(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            SurveyList surveyList = new SurveyList();
            surveyList.setEnteredBy(this.getUserId(context));
            surveyList.buildList(db);
            if (campaign.getSurveyId() > 0 && !surveyList.hasId(campaign.getSurveyId())) {
                surveyList.clear();
                surveyList.setEnteredBy(-1);
                surveyList.setEnteredByIdRange(this.getUserRange(context));
                surveyList.buildList(db);
                context.getRequest().setAttribute("listView", (Object)"all");
            } else {
                context.getRequest().setAttribute("listView", (Object)"my");
            }
            surveyList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SurveyList", (Object)surveyList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewAttachmentOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewSchedule(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            String activeDate = context.getRequest().getParameter("activeDate");
            String activeDateTimeZone = context.getRequest().getParameter("activeDateTimeZone");
            String sendMethodId = context.getRequest().getParameter("sendMethodId");
            if (activeDate != null && activeDateTimeZone != null) {
                campaign.setActiveDateTimeZone(activeDateTimeZone);
                campaign.setTimeZoneForDateFields(context.getRequest(), activeDate, "activeDate");
            }
            if (sendMethodId != null) {
                campaign.setSendMethodId(Integer.parseInt(sendMethodId));
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            LookupList deliveryList = new LookupList(db, "lookup_delivery_options");
            context.getRequest().setAttribute("DeliveryList", (Object)deliveryList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewScheduleOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreviewSchedule(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Dashboard", "Preview Schedule");
        Connection db = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PreviewScheduleOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreviewSurvey(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        Connection db = null;
        Survey thisSurvey = null;
        try {
            db = this.getConnection(context);
            int surveyId = Integer.parseInt(context.getRequest().getParameter("id"));
            thisSurvey = surveyId > 0 ? new Survey(db, surveyId) : new Survey();
            context.getRequest().setAttribute("Survey", (Object)thisSurvey);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "PreviewSurveyOK";
        }
        return "PreviewSurveyMISSING";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        this.addModuleBean(context, "ManageCampaigns", "Campaign: Add Groups");
        if (context.getRequest().getParameter("listView") == null) {
            // empty if block
        }
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignCenterGroupInfo");
        pagedListInfo.setLink("CampaignManager.do?command=AddGroups");
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            SearchCriteriaListList sclList = new SearchCriteriaListList();
            if ("all".equals(pagedListInfo.getListView())) {
                sclList.setOwnerIdRange(this.getUserRange(context));
            } else {
                sclList.setOwner(this.getUserId(context));
            }
            sclList.setPagedListInfo(pagedListInfo);
            sclList.buildList(db);
            context.getRequest().setAttribute("sclList", (Object)sclList);
            SearchCriteriaListList selectedList = new SearchCriteriaListList();
            selectedList.setCampaignId(campaignId);
            selectedList.buildList(db);
            CampaignManager.processListCheckBoxes(selectedList, context);
            context.getRequest().setAttribute("selectedList", (Object)selectedList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                return "PermissionError";
            }
            return "AddGroupsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        boolean recordInserted = false;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            campaign.setGroups(context.getRequest());
            campaign.setModifiedBy(this.getUserId(context));
            recordInserted = campaign.insertGroups(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordInserted) {
                context.getRequest().setAttribute("Campaign", (Object)campaign);
                return "InsertGroupsOK";
            }
            return this.executeCommandAddGroups(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddMessage(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        this.addModuleBean(context, "ManageCampaigns", "Campaign: Add Message");
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            MessageList messageList = new MessageList();
            messageList.setOwner(this.getUserId(context));
            messageList.setPersonalId(-2);
            messageList.buildList(db);
            context.getRequest().setAttribute("MessageList", (Object)messageList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                return "PermissionError";
            }
            return "AddMessageOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddAttachment(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        this.addModuleBean(context, "ManageCampaigns", "Campaign: Add Attachment");
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                return "PermissionError";
            }
            return "AddMessageOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertMessage(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        String messageId = context.getRequest().getParameter("messageId");
        if (messageId != null) {
            try {
                db = this.getConnection(context);
                campaign = new Campaign(db, campaignId);
                if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                    String string = "PermissionError";
                    return string;
                }
                campaign.setMessageId(Integer.parseInt(messageId));
                campaign.setModifiedBy(this.getUserId(context));
                resultCount = campaign.updateMessage(db);
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        if (resultCount == 1) {
            return "InsertMessageOK";
        }
        return this.executeCommandAddMessage(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertAttachment(ActionContext context) {
        int surveyId;
        Campaign campaign;
        int resultCount;
        Connection db;
        block7: {
            if (!this.hasPermission(context, "campaign-campaigns-edit")) {
                return "PermissionError";
            }
            db = null;
            resultCount = 0;
            campaign = null;
            surveyId = -1;
            String campaignId = context.getRequest().getParameter("id");
            surveyId = Integer.parseInt(context.getRequest().getParameter("surveyId"));
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            if (this.hasAuthority(context, campaign.getEnteredBy())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            campaign.setSurveyId(surveyId);
            campaign.setModifiedBy(this.getUserId(context));
            resultCount = campaign.updateSurvey(db);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            return "InsertAttachmentOK";
        }
        return this.executeCommandAddAttachment(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateAddressRequest(ActionContext context) {
        String addAddressRequest;
        int surveyId;
        Campaign campaign;
        int resultCount;
        Connection db;
        Exception errorMessage;
        block8: {
            if (!this.hasPermission(context, "campaign-campaign-contact-updater-view")) {
                return "PermissionError";
            }
            errorMessage = null;
            db = null;
            resultCount = 0;
            campaign = null;
            surveyId = -1;
            addAddressRequest = null;
            String campaignId = context.getRequest().getParameter("id");
            addAddressRequest = context.getRequest().getParameter("insert");
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            if (this.hasAuthority(context, campaign.getEnteredBy())) break block8;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            surveyId = Survey.getAddressSurveyId(db);
            campaign.setSurveyId(surveyId);
            campaign.setModifiedBy(this.getUserId(context));
            campaign.setHasAddressRequest(addAddressRequest);
            resultCount = campaign.updateAddressRequest(db);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            context.getRequest().setAttribute("addressRequestChanged", (Object)(resultCount == 1 ? "YES" : "NO"));
        }
        catch (Exception e) {
            try {
                errorMessage = e;
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
        }
        this.freeConnection(context, db);
        if (errorMessage == null) {
            if (resultCount == 1) {
                return "InsertAttachmentOK";
            }
            return this.executeCommandAddAttachment(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertSchedule(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        int resultCount = -1;
        boolean isValid = false;
        String campaignId = context.getRequest().getParameter("id");
        String activeDate = context.getRequest().getParameter("activeDate");
        String activeDateTimeZone = context.getRequest().getParameter("activeDateTimeZone");
        Campaign campaign = new Campaign();
        if (!StringUtils.hasText(activeDate)) {
            campaign.getErrors().put("activeDateError", this.getSystemStatus(context).getLabel("object.validation.required"));
            this.processErrors(context, campaign.getErrors());
            return this.executeCommandViewSchedule(context);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            campaign.queryRecord(db, Integer.parseInt(campaignId));
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            campaign.setActiveDateTimeZone(activeDateTimeZone);
            campaign.setTimeZoneForDateFields(context.getRequest(), activeDate, "activeDate");
            if (context.getRequest().getParameter("active") != null) {
                campaign.setActive(context.getRequest().getParameter("active"));
            }
            campaign.setModifiedBy(this.getUserId(context));
            campaign.setSendMethodId(Integer.parseInt(context.getRequest().getParameter("sendMethodId")));
            isValid = this.validateObject(context, db, (Object)campaign);
            if (isValid) {
                resultCount = campaign.updateSchedule(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            return "InsertScheduleOK";
        }
        return this.executeCommandViewSchedule(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        boolean recordDeleted = false;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            campaign.setGroups(context.getRequest());
            campaign.setModifiedBy(this.getUserId(context));
            recordDeleted = campaign.deleteGroups(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("Campaign", (Object)campaign);
                return "RemoveGroupsOK";
            }
            return "RemoveGroupsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = (Campaign)((Object)context.getFormBean());
            int enteredBy = Campaign.queryEnteredBy(db, campaign.getId());
            if (this.hasAuthority(context, enteredBy) && this.validateObject(context, db, (Object)campaign)) {
                campaign.setModifiedBy(this.getUserId(context));
                campaign.setBuildGroupMaps(true);
                campaign.buildUserGroupMaps(db);
                resultCount = campaign.updateDetails(db);
            } else {
                resultCount = -1;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1) {
            return "PermissionError";
        }
        if (resultCount == 1) {
            return "UpdateDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        int resultCount = 0;
        Campaign campaign = null;
        Campaign previousCampaign = null;
        String id = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            previousCampaign = new Campaign(db, id);
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            campaign.setModifiedBy(this.getUserId(context));
            resultCount = campaign.cancel(db);
            campaign.queryRecord(db, campaign.getId());
            if (resultCount == 1) {
                campaign.setContacts(db, campaign.getEnteredBy(), this.getUserRange(context, campaign.getEnteredBy()));
                this.processUpdateHook(context, (Object)previousCampaign, (Object)campaign);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (resultCount == 1) {
                return "CancelOK";
            }
            context.getRequest().setAttribute("Error", (Object)"<p><b>This campaign could not be canceled because it has already started processing or has completed.</b></p><p>Once the server starts sending the messages, the campaign cannot be stopped.</p><p><a href=\"CampaignManager.do?command=Dashboard\">Back to Dashboard</a></p>");
            return "UserError";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandActivate(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        Campaign campaign = null;
        Campaign previousCampaign = null;
        String id = context.getRequest().getParameter("id");
        String modified = context.getRequest().getParameter("modified");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            previousCampaign = new Campaign(db, id);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) || campaign.getDeliveryType() == 9) {
                String string = "PermissionError";
                return string;
            }
            campaign.setModifiedBy(this.getUserId(context));
            campaign.setModified(modified);
            campaign.setServerName(RequestUtils.getServerUrl(context.getRequest()));
            resultCount = campaign.activate(db, campaign.getEnteredBy(), this.getUserRange(context, campaign.getEnteredBy()));
            campaign.queryRecord(db, campaign.getId());
            if (resultCount == 1) {
                campaign.setContacts(db, campaign.getEnteredBy(), this.getUserRange(context, campaign.getEnteredBy()));
                this.processUpdateHook(context, (Object)previousCampaign, (Object)campaign);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            return "ActivateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            int surveyId = -1;
            surveyId = ActiveSurvey.getId(db, campaign.getId(), 1);
            if (surveyId > 0) {
                ActiveSurvey thisSurvey = new ActiveSurvey(db, surveyId);
                context.getRequest().setAttribute("ActiveSurvey", (Object)thisSurvey);
            }
            int addressSurveyId = -1;
            addressSurveyId = ActiveSurvey.getId(db, campaign.getId(), 2);
            if (addressSurveyId > 0) {
                ActiveSurvey thisSurvey = new ActiveSurvey(db, addressSurveyId);
                context.getRequest().setAttribute("AddressSurvey", (Object)thisSurvey);
            }
            context.getRequest().setAttribute("User", (Object)this.getUser(context, this.getUserId(context)));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Campaign: Details");
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewResults(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        String id = context.getRequest().getParameter("id");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("SurveyQuestionListInfo");
        }
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "SurveyQuestionListInfo");
        pagedListInfo.setLink("CampaignManager.do?command=ViewResults&id=" + id);
        this.deletePagedListInfo(context, "YesResponseDetailsListInfo");
        this.deletePagedListInfo(context, "NoResponseDetailsListInfo");
        this.deletePagedListInfo(context, "CampaignRecipientInfo");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            int surveyId = -1;
            surveyId = ActiveSurvey.getId(db, campaign.getId(), 1);
            if (surveyId > 0) {
                ActiveSurveyQuestionList thisList = new ActiveSurveyQuestionList();
                thisList.setActiveSurveyId(surveyId);
                thisList.setBuildResults(true);
                thisList.buildList(db);
                context.getRequest().setAttribute("SurveyQuestionList", (Object)thisList);
            }
            int addressSurveyId = -1;
            addressSurveyId = ActiveSurvey.getId(db, campaign.getId(), 2);
            if (addressSurveyId > 0) {
                SurveyResponseList thisYesList = new SurveyResponseList();
                thisYesList.setSurveyId(addressSurveyId);
                thisYesList.setAddressUpdated(SurveyResponse.ADDRESS_UPDATED);
                thisYesList.buildList(db);
                context.getRequest().setAttribute("yesAddressUpdateResponseList", (Object)thisYesList);
                SurveyResponseList thisNoList = new SurveyResponseList();
                thisNoList.setSurveyId(addressSurveyId);
                thisNoList.setOnlyNotUpdated(true);
                thisNoList.buildList(db);
                context.getRequest().setAttribute("noAddressUpdateResponseList", (Object)thisNoList);
                RecipientList recipients = new RecipientList();
                recipients.setCampaignId(campaign.getId());
                recipients.setBuildContact(true);
                recipients.setOnlyResponded(true);
                recipients.setSurveyId(addressSurveyId);
                recipients.buildList(db);
                context.getRequest().setAttribute("recipientList", (Object)recipients);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Campaign: Results");
        return "ResultsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewResponse(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        String id = context.getRequest().getParameter("id");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("SurveyResponseListInfo");
            context.getSession().removeAttribute("AddressUpdateResponseListInfo");
        }
        PagedListInfo surveyResponseListInfo = this.getPagedListInfo(context, "SurveyResponseListInfo");
        surveyResponseListInfo.setLink("CampaignManager.do?command=ViewResponse&id=" + id);
        PagedListInfo addressUpdateResponseListInfo = this.getPagedListInfo(context, "AddressUpdateResponseListInfo");
        addressUpdateResponseListInfo.setLink("CampaignManager.do?command=ViewResponse&id=" + id);
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            int surveyId = -1;
            surveyId = ActiveSurvey.getId(db, campaign.getId(), 1);
            if (surveyId > 0) {
                SurveyResponseList thisList = new SurveyResponseList();
                thisList.setSurveyId(surveyId);
                thisList.setPagedListInfo(surveyResponseListInfo);
                thisList.buildList(db);
                context.getRequest().setAttribute("SurveyResponseList", (Object)thisList);
            }
            int addressSurveyId = -1;
            addressSurveyId = ActiveSurvey.getId(db, campaign.getId(), 2);
            if (addressSurveyId > 0) {
                SurveyResponseList thisList = new SurveyResponseList();
                thisList.setSurveyId(addressSurveyId);
                thisList.setPagedListInfo(addressUpdateResponseListInfo);
                thisList.buildList(db);
                context.getRequest().setAttribute("AddressUpdateResponseList", (Object)thisList);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Campaign: Response");
        return "ResponseOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddressUpdateResponseDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Campaign campaign = null;
        String id = context.getRequest().getParameter("id");
        String section = context.getRequest().getParameter("section");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("ResponseDetailsListInfo");
        }
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            int addressSurveyId = -1;
            addressSurveyId = ActiveSurvey.getId(db, campaign.getId(), 2);
            if (addressSurveyId > 0) {
                if (section == null || String.valueOf(SurveyResponse.ADDRESS_UPDATED).equals(section)) {
                    PagedListInfo yesResponseDetailsListInfo = this.getPagedListInfo(context, "YesResponseDetailsListInfo");
                    yesResponseDetailsListInfo.setLink("CampaignManager.do?command=AddressUpdateResponseDetails&id=" + id + "&section=" + SurveyResponse.ADDRESS_UPDATED);
                    SurveyResponseList thisYesList = new SurveyResponseList();
                    thisYesList.setSurveyId(addressSurveyId);
                    thisYesList.setPagedListInfo(yesResponseDetailsListInfo);
                    thisYesList.setAddressUpdated(SurveyResponse.ADDRESS_UPDATED);
                    thisYesList.buildList(db);
                    context.getRequest().setAttribute("yesAddressUpdateResponseList", (Object)thisYesList);
                }
                if (section == null || String.valueOf(SurveyResponse.ADDRESS_VALID).equals(section)) {
                    PagedListInfo noResponseDetailsListInfo = this.getPagedListInfo(context, "NoResponseDetailsListInfo");
                    noResponseDetailsListInfo.setLink("CampaignManager.do?command=AddressUpdateResponseDetails&id=" + id + "&section=" + SurveyResponse.ADDRESS_VALID);
                    SurveyResponseList thisNoList = new SurveyResponseList();
                    thisNoList.setSurveyId(addressSurveyId);
                    thisNoList.setPagedListInfo(noResponseDetailsListInfo);
                    thisNoList.setOnlyNotUpdated(true);
                    thisNoList.buildList(db);
                    context.getRequest().setAttribute("noAddressUpdateResponseList", (Object)thisNoList);
                }
                if (section == null || String.valueOf(SurveyResponse.ADDRESS_NO_RESPONSE).equals(section)) {
                    PagedListInfo recipientListInfo = this.getPagedListInfo(context, "CampaignRecipientInfo");
                    recipientListInfo.setLink("CampaignManager.do?command=AddressUpdateResponseDetails&id=" + id + "&section=" + SurveyResponse.ADDRESS_NO_RESPONSE);
                    RecipientList recipients = new RecipientList();
                    recipients.setCampaignId(campaign.getId());
                    recipients.setBuildContact(true);
                    recipients.setPagedListInfo(recipientListInfo);
                    recipients.setOnlyResponded(true);
                    recipients.setSurveyId(addressSurveyId);
                    recipients.buildList(db);
                    context.getRequest().setAttribute("recipientList", (Object)recipients);
                }
            }
            context.getRequest().setAttribute("section", (Object)section);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddressResponseDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandResponseDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Campaign campaign = null;
        String id = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        String responseId = context.getRequest().getParameter("responseId");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("ResponseDetailsListInfo");
        }
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ResponseDetailsListInfo");
        pagedListInfo.setLink("CampaignManager.do?command=ResponseDetails&id=" + id);
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            Contact thisContact = new Contact(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("contact", (Object)thisContact);
            int surveyId = -1;
            surveyId = ActiveSurvey.getId(db, campaign.getId(), 1);
            if (surveyId > 0) {
                ActiveSurveyQuestionList thisList = new ActiveSurveyQuestionList();
                thisList.setActiveSurveyId(surveyId);
                thisList.buildList(db);
                thisList.buildResponse(db, Integer.parseInt(contactId), Integer.parseInt(responseId));
                context.getRequest().setAttribute("ResponseDetails", (Object)thisList);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Campaign: Response Details");
        return "ResponseDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreviewRecipients(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        String id = context.getRequest().getParameter("id");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("CampaignDashboardRecipientInfo");
        }
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignDashboardRecipientInfo");
        pagedListInfo.setLink("CampaignManager.do?command=PreviewRecipients&id=" + id);
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            RecipientList recipients = new RecipientList();
            recipients.setCampaignId(campaign.getId());
            recipients.setBuildContact(true);
            recipients.setPagedListInfo(pagedListInfo);
            pagedListInfo.setSearchCriteria(recipients, context);
            recipients.buildList(db);
            context.getRequest().setAttribute("RecipientList", (Object)recipients);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Dashboard", "Campaign: Recipients");
        return "PreviewRecipientsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowItems(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        ActiveSurveyQuestionItemList itemList = null;
        int questionId = Integer.parseInt(context.getRequest().getParameter("questionId"));
        try {
            db = this.getConnection(context);
            itemList = new ActiveSurveyQuestionItemList();
            itemList.setQuestionId(questionId);
            itemList.buildList(db);
            itemList.updateResponse(db, questionId);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ItemList", (Object)itemList);
            return "ItemListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowItemDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        ActiveSurveyAnswerItemList itemDetails = null;
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("CommentListInfo");
        }
        int itemId = Integer.parseInt(context.getRequest().getParameter("itemId"));
        String questionId = context.getRequest().getParameter("questionId");
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ItemDetailsListInfo");
        pagedListInfo.setLink("CampaignManager.do?command=ShowItemDetails&itemId=" + itemId + "&questionId=" + questionId);
        try {
            db = this.getConnection(context);
            itemDetails = new ActiveSurveyAnswerItemList();
            itemDetails.setItemId(itemId);
            itemDetails.setPagedListInfo(pagedListInfo);
            itemDetails.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ItemDetails", (Object)itemDetails);
            return "ItemDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        SystemStatus systemStatus;
        HtmlDialog htmlDialog;
        String passedId;
        Campaign campaign;
        DependencyList dependencies;
        Exception errorMessage;
        Connection db;
        block7: {
            if (!this.hasPermission(context, "campaign-campaigns-delete")) {
                return "PermissionError";
            }
            db = null;
            errorMessage = null;
            dependencies = null;
            campaign = null;
            passedId = context.getRequest().getParameter("id");
            htmlDialog = new HtmlDialog();
            systemStatus = this.getSystemStatus(context);
            db = this.getConnection(context);
            campaign = new Campaign(db, passedId);
            if (this.hasAuthority(context, campaign.getEnteredBy())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            dependencies = campaign.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='CampaignManager.do?command=Trash&action=delete&id=" + passedId + "&forceDelete=true'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            try {
                errorMessage = e;
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
        }
        this.freeConnection(context, db);
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        Campaign campaign = null;
        String passedId = context.getRequest().getParameter("id");
        Connection db = null;
        boolean activeCampaign = false;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, passedId);
            activeCampaign = campaign.getActive();
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = campaign.delete(db, CampaignManager.getDbNamePath(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            if (activeCampaign) {
                context.getRequest().setAttribute("refreshUrl", (Object)"CampaignManager.do?command=Dashboard");
                return "DeleteActiveCampaignOK";
            }
            return "DeleteOK";
        }
        this.processErrors(context, campaign.getErrors());
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Campaign campaign = null;
        String passedId = context.getRequest().getParameter("id");
        Connection db = null;
        boolean activeCampaign = false;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, passedId);
            activeCampaign = campaign.getActive();
            if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = campaign.updateStatus(db, true, this.getUserId(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated) {
            if (activeCampaign) {
                context.getRequest().setAttribute("refreshUrl", (Object)"CampaignManager.do?command=Dashboard");
                return "DeleteActiveCampaignOK";
            }
            return "DeleteOK";
        }
        this.processErrors(context, campaign.getErrors());
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String linkItemId = context.getRequest().getParameter("id");
        String fileId = context.getRequest().getParameter("fid");
        FileItem itemToDownload = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            itemToDownload = new FileItem(db, Integer.parseInt(fileId), Integer.parseInt(linkItemId), 17);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            String filePath = this.getPath(context, "communications") + CampaignManager.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(itemToDownload.getClientFilename());
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("PMF-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowComments(ActionContext context) {
        Connection db = null;
        String questionId = context.getRequest().getParameter("questionId");
        String type = context.getRequest().getParameter("type");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("CommentListInfo");
        }
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CommentListInfo");
        pagedListInfo.setLink("CampaignManager.do?command=ShowComments&questionId=" + questionId + "&type=" + type);
        try {
            SurveyAnswerList answerList = new SurveyAnswerList();
            answerList.setQuestionId(Integer.parseInt(questionId));
            answerList.setHasComments(1);
            answerList.setPagedListInfo(pagedListInfo);
            db = this.getConnection(context);
            answerList.buildList(db);
            context.getRequest().setAttribute("SurveyAnswerList", (Object)answerList);
            context.getRequest().setAttribute("SurveyContactList", (Object)answerList.getContacts());
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PopupCommentsOK";
    }

    private static void processListCheckBoxes(SearchCriteriaListList selectedList, ActionContext context) {
        int count = 0;
        while (context.getRequest().getParameter("select" + ++count) != null) {
            SearchCriteriaList scl = new SearchCriteriaList();
            scl.setId(context.getRequest().getParameter("select" + count));
            if ("on".equalsIgnoreCase(context.getRequest().getParameter("select" + count + "check"))) {
                if (selectedList.containsItem(scl)) continue;
                selectedList.add(scl);
                continue;
            }
            selectedList.removeItem(scl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewAttachmentsOverview(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            if (campaign.hasSurvey()) {
                Survey survey = new Survey(db, campaign.getSurveyId());
                context.getRequest().setAttribute("Survey", (Object)survey);
            }
            FileItemList files = new FileItemList();
            files.setLinkModuleId(16);
            files.setLinkItemId(campaign.getId());
            files.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)files);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewAttachmentsOverviewOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandManageFileAttachments(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            FileItemList files = new FileItemList();
            files.setLinkModuleId(16);
            files.setLinkItemId(campaign.getId());
            files.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)files);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ManageFileAttachmentsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadFile(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        boolean recordInserted = false;
        try {
            String filePath = this.getPath(context, "communications");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("id");
            String subject = "Attachment";
            Campaign campaign = new Campaign(db, Integer.parseInt(id));
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            if (parts.get("id" + id) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(16);
                thisItem.setLinkItemId(campaign.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(-1);
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandManageFileAttachments(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveFile(ActionContext context) {
        String campaignId;
        String itemId;
        boolean recordDeleted;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "campaign-campaigns-edit")) {
                return "PermissionError";
            }
            db = null;
            recordDeleted = false;
            itemId = context.getRequest().getParameter("fid");
            campaignId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            Campaign campaign = new Campaign(db, Integer.parseInt(campaignId));
            if (this.hasAuthority(context, campaign.getEnteredBy())) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(campaignId), 16);
            recordDeleted = thisItem.delete(db, this.getPath(context, "communications"));
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return this.executeCommandManageFileAttachments(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExportReport(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-view")) {
            return "PermissionError";
        }
        String campaignId = context.getRequest().getParameter("id");
        String filePath = this.getPath(context, "campaign") + CampaignManager.getDatePath(new Date());
        CampaignReport thisReport = new CampaignReport();
        thisReport.setFilePath(filePath);
        thisReport.setCampaignId(Integer.parseInt(campaignId));
        thisReport.setEnteredBy(this.getUserId(context));
        thisReport.setModifiedBy(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisReport.build(db);
            thisReport.saveAndInsert(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ExportReportOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadFile(ActionContext context) {
        Exception errorMessage;
        block20: {
            if (!this.hasPermission(context, "campaign-campaigns-view")) {
                return "PermissionError";
            }
            errorMessage = null;
            SystemStatus systemStatus = this.getSystemStatus(context);
            String itemId = context.getRequest().getParameter("fid");
            String campaignId = context.getRequest().getParameter("id");
            FileItem thisItem = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                Campaign campaign = new Campaign(db, Integer.parseInt(campaignId));
                if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                    String string = "PermissionError";
                    return string;
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(campaignId), 16);
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                FileItem itemToDownload = thisItem;
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "communications") + CampaignManager.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block20;
                }
                db = null;
                System.err.println("CampaignManager-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "ManageCampaigns", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMessageJSList(ActionContext context) {
        Connection db = null;
        String listView = context.getRequest().getParameter("listView");
        try {
            MessageList messageList = new MessageList();
            if ("all".equals(listView)) {
                messageList.setAllMessages(true, this.getUserId(context), this.getUserRange(context));
            } else if ("hierarchy".equals(listView)) {
                messageList.setControlledHierarchyOnly(true, this.getUserRange(context));
                messageList.setPersonalId(this.getUserId(context));
            } else if ("personal".equals(listView)) {
                messageList.setOwner(this.getUserId(context));
                messageList.setRuleId(626030333);
                messageList.setPersonalId(-2);
            } else {
                messageList.setOwner(this.getUserId(context));
                messageList.setPersonalId(-2);
            }
            db = this.getConnection(context);
            messageList.buildList(db);
            context.getRequest().setAttribute("messageList", (Object)messageList);
            this.freeConnection(context, db);
        }
        catch (SQLException e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return CampaignManager.getReturn(context, "MessageJSList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSurveyJSList(ActionContext context) {
        Connection db = null;
        String listView = context.getRequest().getParameter("listView");
        try {
            SurveyList surveyList = new SurveyList();
            if ("all".equals(listView)) {
                surveyList.setEnteredByIdRange(this.getUserRange(context));
            } else {
                surveyList.setEnteredBy(this.getUserId(context));
            }
            db = this.getConnection(context);
            surveyList.buildList(db);
            context.getRequest().setAttribute("surveyList", (Object)surveyList);
            this.freeConnection(context, db);
        }
        catch (SQLException e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SurveyJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandBroadcastAuthenticationForm(ActionContext context) {
        String campaignId = context.getRequest().getParameter("id");
        Campaign campaign = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, Integer.parseInt(campaignId));
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            Message message = new Message(db, campaign.getMessageId());
            context.getRequest().setAttribute("Message", (Object)message);
        }
        catch (SQLException e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "BroadcastAuthenticationFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandBroadcastCampaign(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        String password = context.getRequest().getParameter("broadcastPassword");
        String campaignId = context.getRequest().getParameter("id");
        String modified = context.getRequest().getParameter("modified");
        Campaign campaign = null;
        Connection db = null;
        boolean validUser = false;
        int resultCount = -1;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            int userId = this.getUserId(context);
            validUser = Campaign.authenticateForBroadcast(db, userId, password);
            if (validUser) {
                campaign = new Campaign(db, Integer.parseInt(campaignId));
                context.getRequest().setAttribute("Campaign", (Object)campaign);
                if (!this.hasAuthority(context, campaign.getEnteredBy())) {
                    String string = "PermissionError";
                    return string;
                }
                campaign.setModifiedBy(userId);
                campaign.setModified(modified);
                campaign.setServerName(RequestUtils.getServerUrl(context.getRequest()));
                resultCount = campaign.activate(db, campaign.getEnteredBy(), this.getUserRange(context, campaign.getEnteredBy()));
            }
        }
        catch (SQLException e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!validUser) {
            context.getRequest().setAttribute("Error", (Object)systemStatus.getLabel("communications.campaign.broadCastInvalidPasswordMessage"));
            return this.executeCommandBroadcastAuthenticationForm(context);
        }
        if (resultCount != 1) {
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
            return "UserError";
        }
        context.getRequest().setAttribute("finalsubmit", (Object)"true");
        return "BroadcastCampaignOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestart(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Restart Campaign");
        Connection db = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        if (campaignId == null || "".equals(campaignId.trim())) {
            campaignId = (String)context.getRequest().getAttribute("id");
        }
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, campaignId);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            campaign.restartCampaign(db);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ResetOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddRecipient(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-edit")) {
            return "PermissionError";
        }
        boolean recipientAdded = false;
        Object errorMessage = null;
        Connection db = null;
        Campaign campaign = null;
        Campaign oldCampaign = null;
        String contactId = context.getRequest().getParameter("contactId");
        String allowDuplicates = context.getRequest().getParameter("allowDuplicates");
        String id = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            campaign = new Campaign(db, id);
            oldCampaign = new Campaign(db, id);
            campaign.setBuildGroupMaps(true);
            campaign.buildUserGroupMaps(db);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            RecipientList recipients = new RecipientList();
            recipients.setCampaignId(campaign.getId());
            recipients.setBuildContact(true);
            recipients.buildList(db);
            if (allowDuplicates != null && !"".equals(allowDuplicates.trim())) {
                recipients.setAllowDuplicates(allowDuplicates);
            }
            if (recipientAdded = recipients.addRecipient(db, contactId)) {
                String str = this.executeCommandRestart(context);
                campaign = new Campaign(db, id);
                Contact contact = new Contact(db, Integer.parseInt(contactId));
                ContactList contacts = new ContactList();
                contacts.add(contact);
                campaign.setContactList(contacts);
                this.processUpdateHook(context, (Object)oldCampaign, (Object)campaign);
            }
            context.getRequest().setAttribute("recipientAdded", (Object)String.valueOf(recipientAdded));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddRecipientOK";
    }

    private void resetPagedListInfo(ActionContext context) {
        this.deletePagedListInfo(context, "CampaignListInfo");
        this.deletePagedListInfo(context, "CampaignCenterPreviewInfo");
        this.deletePagedListInfo(context, "CampaignCenterGroupInfo");
        this.deletePagedListInfo(context, "SurveyQuestionListInfo");
        this.deletePagedListInfo(context, "SurveyResponseListInfo");
        this.deletePagedListInfo(context, "ResponseDetailsListInfo");
        this.deletePagedListInfo(context, "CampaignDashboardRecipientInfo");
        this.deletePagedListInfo(context, "ItemDetailsListInfo");
        this.deletePagedListInfo(context, "CommentListInfo");
        this.deletePagedListInfo(context, "campaignUserGroupListInfo");
    }
}

