/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.SearchCriteriaElement;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.communications.base.SearchCriteriaListList;
import org.aspcfs.modules.communications.base.SearchFieldList;
import org.aspcfs.modules.communications.base.SearchOperatorList;
import org.aspcfs.modules.communications.beans.SearchFormBean;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactTypeList;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class CampaignManagerGroup
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignGroupListInfo");
        pagedListInfo.setLink("CampaignManagerGroup.do?command=View");
        Connection db = null;
        SearchCriteriaListList sclList = new SearchCriteriaListList();
        try {
            db = this.getConnection(context);
            sclList.setPagedListInfo(pagedListInfo);
            if ("all".equals(pagedListInfo.getListView())) {
                sclList.setOwnerIdRange(this.getUserRange(context));
            } else {
                sclList.setOwner(this.getUserId(context));
            }
            sclList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageGroups";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "View Groups");
        if (errorMessage == null) {
            context.getRequest().setAttribute("sclList", (Object)sclList);
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String passedId = null;
        Connection db = null;
        passedId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            this.buildFormElements(context, db);
            if (passedId != null) {
                SearchCriteriaList scl = new SearchCriteriaList(db, passedId);
                context.getSession().setAttribute("SCL", (Object)scl);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageGroups";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Build New Group");
        if (errorMessage == null) {
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String passedId = null;
        SearchCriteriaList thisSCL = null;
        passedId = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisSCL = new SearchCriteriaList(db, passedId);
            if (!this.hasAuthority(context, thisSCL.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisSCL.delete(db);
            if (!recordDeleted) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${thisSCL.inactiveCount}", "" + thisSCL.getInactiveCount());
                map.put("${thisSCL.campaign}", thisSCL.getInactiveCount() == 1 ? "campaign is" : "campaigns are");
                map.put("${thisSCL.use}", thisSCL.getInactiveCount() == 1 ? "uses" : "use");
                Template template = new Template(systemStatus.getLabel("object.validation.actionError.canNotDeleteSCL"));
                template.setParseElements(map);
                thisSCL.getErrors().put("actionError", template.getParsedText());
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)"CampaignManagerGroup.do?command=View");
                return "DeleteOK";
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("CampaignManager-> Error deleting group");
            }
            this.processErrors(context, thisSCL.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        SearchCriteriaList thisSCL = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisSCL = new SearchCriteriaList(db, id);
            if (!this.hasAuthority(context, thisSCL.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisSCL.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='CampaignManagerGroup.do?command=Delete&id=" + id + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.groupCampaignHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        SearchFormBean thisSearchForm = (SearchFormBean)((Object)context.getFormBean());
        SearchCriteriaList thisSCL = thisSearchForm.getSearchCriteriaList();
        try {
            db = this.getConnection(context);
            if (!this.validateObject(context, db, (Object)thisSearchForm)) {
                String string = "InsertOK";
                return string;
            }
            isValid = true;
            StringTokenizer st = new StringTokenizer(thisSearchForm.getSearchCriteriaText(), "^");
            while (st.hasMoreTokens()) {
                String tmpCriteria = st.nextToken();
                SearchCriteriaElement thisElement = new SearchCriteriaElement(tmpCriteria);
                isValid = this.validateObject(context, db, thisElement) && isValid;
            }
            thisSCL.setGroupName(thisSearchForm.getGroupName());
            thisSCL.setContactSource(thisSearchForm.getContactSource());
            thisSCL.setEnteredBy(this.getUserId(context));
            thisSCL.setModifiedBy(this.getUserId(context));
            thisSCL.setOwner(this.getUserId(context));
            boolean bl = isValid = this.validateObject(context, db, thisSCL) && isValid;
            if (isValid) {
                recordInserted = thisSCL.insert(db);
            } else {
                LookupList siteList = new LookupList(db, "lookup_site_id");
                siteList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                thisSCL.setSiteList(siteList);
                thisSCL.buildRelatedResources(db);
                context.getRequest().setAttribute("SCL", (Object)thisSCL);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        SearchCriteriaList scl = null;
        String passedId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            this.buildFormElements(context, db);
            if (passedId != null) {
                scl = new SearchCriteriaList(db, passedId);
                LookupList siteList = new LookupList(db, "lookup_site_id");
                siteList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                scl.setSiteList(siteList);
                context.getRequest().setAttribute("SCL", (Object)scl);
                User owner = new User(db, scl.getOwner());
                context.getRequest().setAttribute("owner", (Object)owner);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageGroups";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Modify Criteria");
        if (errorMessage == null) {
            if (!this.hasAuthority(context, scl.getOwner())) {
                return "PermissionError";
            }
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        int resultCount = -1;
        SearchFormBean thisSearchForm = (SearchFormBean)((Object)context.getRequest().getAttribute("SearchForm"));
        SearchCriteriaList thisSCL = thisSearchForm.getSearchCriteriaList();
        try {
            String tmpCriteria;
            db = this.getConnection(context);
            if (!this.validateObject(context, db, (Object)thisSearchForm)) {
                String string = "UpdateOK";
                return string;
            }
            isValid = true;
            StringTokenizer st = new StringTokenizer(thisSearchForm.getSearchCriteriaText(), "^");
            while (st.hasMoreTokens()) {
                tmpCriteria = st.nextToken();
                SearchCriteriaElement thisElement = new SearchCriteriaElement(tmpCriteria);
                isValid = this.validateObject(context, db, thisElement) && isValid;
            }
            thisSCL.setId(Integer.parseInt(context.getRequest().getParameter("id")));
            thisSCL.setGroupName(thisSearchForm.getGroupName());
            thisSCL.setContactSource(thisSearchForm.getContactSource());
            thisSCL.setOwner(thisSearchForm.getOwner());
            thisSCL.setModifiedBy(this.getUserId(context));
            if (!this.hasAuthority(context, thisSCL.getOwner())) {
                tmpCriteria = "PermissionError";
                return tmpCriteria;
            }
            boolean bl = isValid = this.validateObject(context, db, thisSCL) && isValid;
            if (isValid) {
                resultCount = thisSCL.update(db);
            }
            if (resultCount != -1) {
                context.getRequest().setAttribute("id", (Object)String.valueOf(thisSCL.getId()));
                context.getSession().removeAttribute("CampaignGroupsPreviewInfo");
                PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignGroupsPreviewInfo");
                pagedListInfo.setLink("CampaignManagerGroup.do?command=Preview&id=" + thisSCL.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ManageGroups", "Preview");
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandView(context);
            }
            return "UpdateOK";
        }
        if (resultCount == -1) {
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        SearchCriteriaList thisSCL = null;
        try {
            db = this.getConnection(context);
            thisSCL = new SearchCriteriaList(db, context.getRequest().getParameter("id"));
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            thisSCL.setSiteList(siteList);
            context.getRequest().setAttribute("scl", (Object)thisSCL);
            context.getRequest().setAttribute("id", (Object)String.valueOf(thisSCL.getId()));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ManageGroups", "Criteria");
        if (errorMessage == null) {
            if (!this.hasAuthority(context, thisSCL.getEnteredBy())) {
                return "PermissionError";
            }
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreview(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        User user = this.getUser(context, this.getUserId(context));
        SearchCriteriaList thisSCL = null;
        try {
            db = this.getConnection(context);
            thisSCL = new SearchCriteriaList(db, context.getRequest().getParameter("id"));
            context.getRequest().setAttribute("scl", (Object)thisSCL);
            context.getRequest().setAttribute("id", (Object)String.valueOf(thisSCL.getId()));
            if ("true".equals(context.getRequest().getParameter("reset"))) {
                context.getSession().removeAttribute("CampaignGroupsPreviewInfo");
            }
            PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignGroupsPreviewInfo");
            pagedListInfo.setLink("CampaignManagerGroup.do?command=Preview&id=" + thisSCL.getId());
            ContactList contacts = new ContactList();
            contacts.setScl(thisSCL, this.getUserId(context), this.getUserRange(context));
            contacts.setPagedListInfo(pagedListInfo);
            contacts.setBuildDetails(true);
            contacts.setLeadsOnly(0);
            if (contacts.getSiteId() == -2) {
                contacts.setSiteId(user.getSiteId());
                contacts.setIncludeAllSites(true);
            } else {
                contacts.setExclusiveToSite(true);
                contacts.setIncludeAllSites(false);
            }
            contacts.setBuildTypes(false);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 626030330);
            contacts.setGeneralContactAccessTypes(accessTypeList);
            contacts.buildList(db);
            context.getRequest().setAttribute("ContactList", (Object)contacts);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ManageGroups", "Preview");
        if (errorMessage == null) {
            if (!this.hasAuthority(context, thisSCL.getEnteredBy())) {
                return "PermissionError";
            }
            return "PreviewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPopPreview(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-groups-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        SearchCriteriaList thisSCL = null;
        User user = this.getUser(context, this.getUserId(context));
        boolean isValid = false;
        try {
            String criteria = context.getRequest().getParameter("criteria");
            if ("true".equals(context.getRequest().getParameter("reset"))) {
                context.getSession().removeAttribute("CampaignGroupsPreviewInfo");
            }
            PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignGroupsPreviewInfo");
            pagedListInfo.setLink("CampaignManagerGroup.do?command=PopPreview&criteria=" + criteria + "&popup=true");
            isValid = true;
            StringTokenizer st = new StringTokenizer(criteria, "^");
            while (st.hasMoreTokens()) {
                String tmpCriteria = st.nextToken();
                SearchCriteriaElement thisElement = new SearchCriteriaElement(tmpCriteria);
                isValid = this.validateObject(context, db, thisElement) && isValid;
            }
            db = this.getConnection(context);
            if (isValid) {
                thisSCL = new SearchCriteriaList(criteria);
                thisSCL.setGroupName("Preview Group");
                thisSCL.setEnteredBy(this.getUserId(context));
                thisSCL.setModifiedBy(this.getUserId(context));
                thisSCL.setOwner(this.getUserId(context));
                thisSCL.buildRelatedResources(db);
            }
            ContactList contacts = new ContactList();
            if (isValid) {
                contacts.setScl(thisSCL, this.getUserId(context), this.getUserRange(context));
                contacts.setPagedListInfo(pagedListInfo);
                contacts.setBuildDetails(true);
                contacts.setLeadsOnly(0);
                if (contacts.getSiteId() == -2) {
                    contacts.setIncludeAllSites(true);
                    contacts.setSiteId(user.getSiteId());
                } else {
                    contacts.setIncludeAllSites(false);
                    contacts.setExclusiveToSite(true);
                }
                contacts.setBuildTypes(false);
                AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 626030330);
                contacts.setGeneralContactAccessTypes(accessTypeList);
                contacts.buildList(db);
            } else {
                context.getRequest().setAttribute("errorString", (Object)this.getSystemStatus(context).getLabel("object.validation.checkCriteria.error", "Error. Please enter valid search criteria."));
            }
            context.getRequest().setAttribute("scl", (Object)thisSCL);
            context.getRequest().setAttribute("ContactList", (Object)contacts);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "ManageGroups", "Pop-up Preview");
        if (errorMessage == null) {
            return "PopPreviewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public void buildFormElements(ActionContext context, Connection db) throws SQLException {
        SearchFieldList searchFieldList = new SearchFieldList();
        SearchOperatorList stringOperatorList = new SearchOperatorList();
        SearchOperatorList dateOperatorList = new SearchOperatorList();
        SearchOperatorList numberOperatorList = new SearchOperatorList();
        SystemStatus thisSystem = this.getSystemStatus(context);
        HtmlSelect contactSource = new HtmlSelect();
        contactSource.addItem(1, thisSystem.getLabel("contact.myContacts"));
        contactSource.addItem(2, thisSystem.getLabel("actionList.allContacts"));
        contactSource.addItem(3, thisSystem.getLabel("actionList.allAccountContacts"));
        contactSource.addItem(4, thisSystem.getLabel("employees.employees"));
        context.getRequest().setAttribute("ContactSource", (Object)contactSource);
        ContactTypeList typeList = new ContactTypeList();
        PagedListInfo contactTypeInfo = new PagedListInfo();
        contactTypeInfo.setItemsPerPage(0);
        typeList.setPagedListInfo(contactTypeInfo);
        typeList.buildList(db);
        LookupList ctl = typeList.getLookupList(thisSystem, "typeId", 0);
        ctl.setExcludeDisabledIfUnselected(true);
        ctl.setJsEvent("onChange = \"javascript:setText(document.searchForm.typeId)\"");
        context.getRequest().setAttribute("ContactTypeList", (Object)ctl);
        LookupList accountTypeList = new LookupList();
        accountTypeList.setTableName("lookup_account_types");
        accountTypeList.setSelectSize(1);
        accountTypeList.setShowDisabledFlag(true);
        accountTypeList.setExcludeDisabledIfUnselected(true);
        accountTypeList.buildList(db);
        context.getRequest().setAttribute("AccountTypeList", (Object)accountTypeList);
        searchFieldList.buildFieldList(db);
        context.getRequest().setAttribute("SearchFieldList", (Object)searchFieldList);
        stringOperatorList.buildOperatorList(db, 0);
        context.getRequest().setAttribute("StringOperatorList", (Object)stringOperatorList);
        dateOperatorList.buildOperatorList(db, 1);
        context.getRequest().setAttribute("DateOperatorList", (Object)dateOperatorList);
        numberOperatorList.buildOperatorList(db, 2);
        context.getRequest().setAttribute("NumberOperatorList", (Object)numberOperatorList);
        LookupList siteValueList = new LookupList(db, "lookup_site_id");
        siteValueList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteValueList", (Object)siteValueList);
        LookupList siteCriteriaList = new LookupList(db, "lookup_site_id");
        siteCriteriaList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteCriteriaList", (Object)siteCriteriaList);
    }
}

