/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.MessageList;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class CampaignManagerMessage
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "CampaignMessageListInfo");
        pagedListInfo.setLink("CampaignManagerMessage.do?command=View");
        Connection db = null;
        MessageList messageList = new MessageList();
        try {
            db = this.getConnection(context);
            messageList.setPagedListInfo(pagedListInfo);
            if ("all".equals(pagedListInfo.getListView())) {
                messageList.setAllMessages(true, this.getUserId(context), this.getUserRange(context));
            } else if ("hierarchy".equals(pagedListInfo.getListView())) {
                messageList.setControlledHierarchyOnly(true, this.getUserRange(context));
                messageList.setPersonalId(this.getUserId(context));
            } else if ("personal".equals(pagedListInfo.getListView())) {
                messageList.setOwner(this.getUserId(context));
                messageList.setRuleId(626030333);
                messageList.setPersonalId(-2);
            } else {
                messageList.setOwner(this.getUserId(context));
                messageList.setPersonalId(-2);
            }
            messageList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageMessages";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "View Messages");
        if (errorMessage == null) {
            context.getRequest().setAttribute("MessageList", (Object)messageList);
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Messages", "Modify Message");
        Exception errorMessage = null;
        String messageId = context.getRequest().getParameter("id");
        Connection db = null;
        Message newMessage = null;
        try {
            db = this.getConnection(context);
            newMessage = new Message(db, messageId);
            if (!this.hasAuthority(db, context, (Object)newMessage)) {
                String string = "PermissionError";
                return string;
            }
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 707031028);
            context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageMessages";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Modify Message");
        if (errorMessage == null) {
            context.getRequest().setAttribute("Message", (Object)newMessage);
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Message newMessage;
        int resultCount;
        boolean isValid;
        Connection db;
        block10: {
            if (!this.hasPermission(context, "campaign-campaigns-messages-edit")) {
                return "PermissionError";
            }
            this.addModuleBean(context, "ManageMessages", "Message Details");
            db = null;
            isValid = false;
            resultCount = 0;
            String id = context.getRequest().getParameter("id");
            newMessage = (Message)((Object)context.getFormBean());
            newMessage.setAttachmentList(context.getRequest().getParameterValues("selectedList"));
            db = this.getConnection(context);
            Message oldMessage = new Message(db, Integer.parseInt(id));
            if (this.hasAuthority(db, context, (Object)oldMessage)) break block10;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            newMessage.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)newMessage);
            if (isValid) {
                resultCount = newMessage.update(db);
            }
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            context.getRequest().setAttribute("MessageDetails", (Object)newMessage);
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandView(context);
            }
            return "UpdateOK";
        }
        if (resultCount == -1 || !isValid) {
            context.getRequest().setAttribute("MessageDetails", (Object)newMessage);
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageMessages", "View Message Details");
        String messageId = context.getRequest().getParameter("id");
        Connection db = null;
        Message newMessage = null;
        try {
            db = this.getConnection(context);
            newMessage = new Message(db, messageId);
            if (!this.hasAuthority(db, context, (Object)newMessage)) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("MessageDetails", (Object)newMessage);
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-add")) {
            return "PermissionError";
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageMessages";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 707031028);
            context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Add Message");
        if (errorMessage == null) {
            return CampaignManagerMessage.getReturn(context, "Add");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "BuildNew", "Add New Message");
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        Message newMessage = (Message)((Object)context.getFormBean());
        try {
            newMessage.setAttachmentList(context.getRequest().getParameterValues("selectedList"));
            newMessage.setEnteredBy(this.getUserId(context));
            newMessage.setModifiedBy(this.getUserId(context));
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)newMessage);
            if (isValid) {
                recordInserted = newMessage.insert(db);
            }
            if (recordInserted) {
                newMessage = new Message(db, newMessage.getId());
                context.getRequest().setAttribute("Message", (Object)newMessage);
            }
            this.freeConnection(context, db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDeleted = false;
        Message thisMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisMessage = new Message(db, context.getRequest().getParameter("id"));
            if (!this.hasAuthority(db, context, (Object)thisMessage)) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisMessage.delete(db);
            if (!recordDeleted) {
                String inactiveCounter = "" + thisMessage.getInactiveCount();
                String label = "";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${message.inactiveCount}", inactiveCounter);
                map.put("${message.campaign}", thisMessage.getInactiveCount() == 1 ? "campaign is" : "campaigns are");
                map.put("${message.use}", thisMessage.getInactiveCount() == 1 ? "uses" : "use");
                Template template = new Template(systemStatus.getLabel("object.validation.actionError.canNotDeleteMessage"));
                template.setParseElements(map);
                thisMessage.getErrors().put("actionError", template.getParsedText());
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)"CampaignManagerMessage.do?command=View");
                return "DeleteOK";
            }
            this.processErrors(context, thisMessage.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreviewMessage(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ManageCampaigns", "Build New Campaign");
        Connection db = null;
        String messageId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            Message thisMessage = new Message(db, messageId);
            context.getRequest().setAttribute("Message", (Object)thisMessage);
        }
        catch (Exception e) {
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PreviewOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClone(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-messages-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Messages", "Clone Message");
        Exception errorMessage = null;
        String passedId = context.getRequest().getParameter("id");
        Connection db = null;
        Message newMessage = null;
        try {
            db = this.getConnection(context);
            newMessage = new Message(db, passedId);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 707031028);
            context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageMessages";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "Modify Message");
        if (errorMessage == null) {
            context.getRequest().setAttribute("Message", (Object)newMessage);
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Message thisMessage = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        if (!this.hasPermission(context, "campaign-campaigns-messages-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisMessage = new Message(db, id);
            if (!this.hasAuthority(db, context, (Object)thisMessage)) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisMessage.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='CampaignManagerMessage.do?command=Delete&id=" + id + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.messageCampaignHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }
}

