/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.ItemList;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.communications.base.SurveyList;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.modules.communications.base.SurveyQuestionList;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.CustomForm;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class CampaignManagerSurvey
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo surveyInfo = this.getPagedListInfo(context, "CampaignSurveyListInfo");
        surveyInfo.setLink("CampaignManagerSurvey.do?command=View");
        Connection db = null;
        SurveyList surveyList = new SurveyList();
        try {
            db = this.getConnection(context);
            surveyList.setPagedListInfo(surveyInfo);
            if ("all".equals(surveyInfo.getListView())) {
                surveyList.setEnteredByIdRange(this.getUserRange(context));
            } else {
                surveyList.setEnteredByIdRange(this.getUserId(context) + "");
            }
            surveyList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageSurveys";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        this.addModuleBean(context, submenu, "View Surveys");
        if (errorMessage == null) {
            context.getRequest().setAttribute("SurveyList", (Object)surveyList);
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-add") && !this.hasPermission(context, "campaign-campaigns-surveys-edit")) {
            return "PermissionError";
        }
        try {
            int pg = 0;
            int updateResult = 0;
            Exception errorMessage = null;
            Connection db = null;
            if (context.getRequest().getParameter("pg") != null) {
                pg = Integer.parseInt(context.getRequest().getParameter("pg"));
            }
            try {
                db = this.getConnection(context);
                CustomForm thisForm = this.getDynamicForm(context, "survey");
                thisForm.setSelectedTabId(pg);
                Survey thisSurvey = (Survey)((Object)context.getFormBean());
                thisSurvey.setRequestItems(context.getRequest());
                thisForm.setContext(context);
                updateResult = thisForm.populate(db, (Object)thisSurvey);
                context.getRequest().setAttribute("Survey", (Object)thisSurvey);
                context.getRequest().setAttribute("CustomFormInfo", (Object)thisForm);
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            String submenu = context.getRequest().getParameter("submenu");
            if (submenu == null) {
                submenu = (String)context.getRequest().getAttribute("submenu");
            }
            if (submenu == null) {
                submenu = "ManageSurveys";
            }
            context.getRequest().setAttribute("submenu", (Object)submenu);
            this.addModuleBean(context, submenu, "Add Survey");
            return "AddOK";
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            return "SystemError";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewItems(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        int questionId = -1;
        if (context.getRequest().getParameter("questionid") != null && !context.getRequest().getParameter("questionid").equals("")) {
            questionId = Integer.parseInt(context.getRequest().getParameter("questionid"));
        }
        try {
            db = this.getConnection(context);
            ItemList itemList = new ItemList();
            itemList.setQuestionId(questionId);
            itemList.buildList(db);
            context.getRequest().setAttribute("ItemList", (Object)itemList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ViewItemsOK";
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-edit")) {
            return "PermissionError";
        }
        int pg = 0;
        int questionId = -1;
        Exception errorMessage = null;
        Survey thisSurvey = null;
        Connection db = null;
        CustomForm thisForm = this.getDynamicForm(context, "survey");
        if (context.getRequest().getParameter("pg") != null) {
            pg = Integer.parseInt(context.getRequest().getParameter("pg"));
        }
        if (context.getRequest().getParameter("questionid") != null) {
            questionId = Integer.parseInt(context.getRequest().getParameter("questionid"));
        }
        try {
            db = this.getConnection(context);
            if (context.getRequest().getParameter("id") != null && Integer.parseInt(context.getRequest().getParameter("id")) != -1) {
                thisSurvey = new Survey(db, Integer.parseInt(context.getRequest().getParameter("id")));
            }
            thisSurvey.getQuestions().setQuestionId(questionId);
            thisForm.setSelectedTabId(pg);
            thisForm.setContext(context);
            thisForm.populate(db, (Object)thisSurvey);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageSurveys";
        }
        if (errorMessage == null) {
            if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                return "PermissionError";
            }
            context.getRequest().setAttribute("submenu", (Object)submenu);
            this.addModuleBean(context, submenu, "Add Surveys");
            if (thisSurvey != null) {
                if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                    return "PermissionError";
                }
                context.getRequest().setAttribute("Survey", (Object)thisSurvey);
                context.getRequest().setAttribute("CustomFormInfo", (Object)thisForm);
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                return "ModifyOK";
            }
            this.processErrors(context, thisSurvey.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Survey thisSurvey = null;
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, Integer.parseInt(context.getRequest().getParameter("id")));
            context.getRequest().setAttribute("Survey", (Object)thisSurvey);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageSurveys";
        }
        context.getRequest().setAttribute("submenu", (Object)submenu);
        if (errorMessage == null) {
            if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                return "PermissionError";
            }
            this.addModuleBean(context, submenu, "Add Surveys");
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandViewReturn(ActionContext context) {
        String id;
        String returnType = context.getRequest().getParameter("return");
        if (!"list".equals(returnType) && (id = context.getRequest().getParameter("id")) != null && !"-1".equals(id)) {
            return this.executeCommandDetails(context);
        }
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Survey thisSurvey = null;
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, Integer.parseInt(context.getRequest().getParameter("id")));
            if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisSurvey.delete(db);
            if (!recordDeleted) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${thisSurvey.inactiveCount}", "" + thisSurvey.getInactiveCount());
                map.put("${thisSurvey.campaign}", thisSurvey.getInactiveCount() == 1 ? "campaign is" : "campaigns are");
                map.put("${thisSurvey.use}", thisSurvey.getInactiveCount() == 1 ? "uses" : "use");
                Template template = new Template(systemStatus.getLabel("object.validation.actionError.canNotDeleteSurvey"));
                template.setParseElements(map);
                thisSurvey.getErrors().put("actionError", template.getParsedText());
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)"CampaignManagerSurvey.do?command=View");
                return "DeleteOK";
            }
            this.processErrors(context, thisSurvey.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteQuestion(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Survey thisSurvey = null;
        Connection db = null;
        int surveyId = Integer.parseInt(context.getRequest().getParameter("id"));
        int questionId = Integer.parseInt(context.getRequest().getParameter("questionid"));
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, surveyId);
            if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            SurveyQuestionList thisList = thisSurvey.getQuestions();
            recordDeleted = thisList.getQuestion(questionId).delete(db, surveyId);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                return this.executeCommandModify(context);
            }
            this.processErrors(context, thisSurvey.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPreview(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Survey thisSurvey = null;
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, Integer.parseInt(context.getRequest().getParameter("id")));
            context.getRequest().setAttribute("Survey", (Object)thisSurvey);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageSurveys";
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("submenu", (Object)submenu);
            this.addModuleBean(context, submenu, "Add Surveys");
            return "PreviewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-add") && !this.hasPermission(context, "campaign-campaigns-surveys-edit")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        int recordsModified = -1;
        boolean isValid = false;
        Connection db = null;
        try {
            Survey newSurvey = (Survey)((Object)context.getFormBean());
            int surveyId = -1;
            if (context.getRequest().getParameter("id") != null && !context.getRequest().getParameter("id").equals("")) {
                surveyId = Integer.parseInt(context.getRequest().getParameter("id"));
            }
            if (surveyId == -1) {
                newSurvey.setEnteredBy(this.getUserId(context));
            }
            newSurvey.setModifiedBy(this.getUserId(context));
            newSurvey.setRequestItems(context.getRequest());
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)newSurvey);
            for (SurveyQuestion question : newSurvey.getQuestions()) {
                isValid = this.validateObject(context, db, question) && isValid;
            }
            if (isValid) {
                if (surveyId == -1) {
                    recordInserted = newSurvey.insert(db);
                } else {
                    recordsModified = newSurvey.update(db);
                }
            }
            if ((recordInserted || recordsModified > 0) && isValid) {
                context.getRequest().setAttribute("SurveyDetails", (Object)newSurvey);
            } else {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CampaignManagerSurvey-> Insert Errors " + newSurvey.getErrors());
                }
                this.processErrors(context, newSurvey.getErrors());
            }
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
            this.freeConnection(context, db);
        }
        catch (Exception errorMessage) {
            errorMessage.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ((recordInserted || recordsModified > 0) && isValid) {
            return "InsertOK";
        }
        if (recordsModified == 0 && isValid) {
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
            return "UserError";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertAndAdd(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-add") && !this.hasPermission(context, "campaign-campaigns-surveys-edit")) {
            return "PermissionError";
        }
        int pg = 0;
        Exception errorMessage = null;
        Survey thisSurvey = null;
        Connection db = null;
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        String result = this.executeCommandInsert(context);
        if (result.equals("AddOK")) {
            if (context.getRequest().getParameter("pg") != null && "1".equals(context.getRequest().getParameter("pg"))) {
                context.getRequest().setAttribute("pg", (Object)"0");
            }
            return "AddOK";
        }
        CustomForm thisForm = this.getDynamicForm(context, "survey");
        if (context.getRequest().getParameter("pg") != null) {
            pg = Integer.parseInt(context.getRequest().getParameter("pg"));
        }
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, ((Survey)((Object)context.getRequest().getAttribute("SurveyDetails"))).getId());
            thisForm.setSelectedTabId(pg);
            thisForm.setContext(context);
            thisForm.populate(db, (Object)thisSurvey);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageSurveys";
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("submenu", (Object)submenu);
            this.addModuleBean(context, submenu, "Add Surveys");
            if (thisSurvey != null) {
                context.getRequest().setAttribute("Survey", (Object)thisSurvey);
                context.getRequest().setAttribute("CustomFormInfo", (Object)thisForm);
                return "InsertAndAddOK";
            }
            this.processErrors(context, thisSurvey.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Survey thisSurvey = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        if (!this.hasPermission(context, "campaign-campaigns-surveys-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisSurvey = new Survey(db, id);
            if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisSurvey.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='CampaignManagerSurvey.do?command=Delete&id=" + id + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.surveyCampaignHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandViewInteractiveOptions(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        return "InteractiveOptionsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveQuestion(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Survey thisSurvey = null;
        boolean pg = false;
        String direction = context.getRequest().getParameter("direction");
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, Integer.parseInt(context.getRequest().getParameter("id")));
            if (!this.hasAuthority(context, thisSurvey.getEnteredBy())) {
                String string = "PermissionError";
                return string;
            }
            thisSurvey.getQuestions().updateOrder(db, Integer.parseInt(context.getRequest().getParameter("questionid")), direction);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        String submenu = context.getRequest().getParameter("submenu");
        if (submenu == null) {
            submenu = (String)context.getRequest().getAttribute("submenu");
        }
        if (submenu == null) {
            submenu = "ManageSurveys";
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("submenu", (Object)submenu);
            this.addModuleBean(context, submenu, "Add Surveys");
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMockInsert(ActionContext context) {
        if (!this.hasPermission(context, "campaign-campaigns-surveys-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Survey thisSurvey = null;
        try {
            db = this.getConnection(context);
            thisSurvey = new Survey(db, Integer.parseInt(context.getRequest().getParameter("id")));
            context.getRequest().setAttribute("ThankYouText", (Object)thisSurvey.getOutro());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "MockInsertOK";
    }
}

