/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.UserGroupList;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignUserGroupMap;
import org.aspcfs.modules.communications.base.CampaignUserGroupMapList;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class CampaignUserGroups
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return "DefaultOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewActive(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        if (campaignId == null || "".equals(campaignId.trim())) {
            campaignId = (String)context.getRequest().getAttribute("id");
        }
        UserGroupList groups = null;
        UserGroupList completeGroupList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "campaignUserGroupListInfo");
        pagedListInfo.setLink("CampaignUserGroups.do?command=ViewActive&id=" + campaignId);
        try {
            db = this.getConnection(context);
            Campaign campaign = new Campaign();
            campaign.queryRecord(db, Integer.parseInt(campaignId));
            context.getRequest().setAttribute("campaign", (Object)campaign);
            groups = new UserGroupList();
            groups.setPagedListInfo(pagedListInfo);
            groups.setBuildResources(true);
            groups.setCampaignId(campaign.getId());
            groups.setIncludeAllSites(true);
            groups.buildList(db);
            context.getRequest().setAttribute("groupList", (Object)groups);
            completeGroupList = new UserGroupList();
            completeGroupList.setBuildResources(false);
            completeGroupList.setCampaignId(campaign.getId());
            completeGroupList.setIncludeAllSites(true);
            completeGroupList.buildList(db);
            context.getRequest().setAttribute("completeGroupList", (Object)completeGroupList);
            LookupList siteid = new LookupList(db, "lookup_site_id");
            siteid.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteid);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewActiveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveUserGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String campaignId = context.getRequest().getParameter("campaignId");
        if (campaignId == null || "".equals(campaignId.trim())) {
            campaignId = (String)context.getRequest().getAttribute("campaignId");
        }
        HashMap selectedList = (HashMap)context.getRequest().getAttribute("selectedList");
        try {
            db = this.getConnection(context);
            Campaign campaign = new Campaign();
            campaign.queryRecord(db, Integer.parseInt(campaignId));
            campaign.getUserGroupMaps().setCampaignId(campaign.getId());
            campaign.getUserGroupMaps().updateElements(selectedList);
            campaign.parseUserGroups(db);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListGroups(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String groups = context.getRequest().getParameter("groups");
        try {
            db = this.getConnection(context);
            CampaignUserGroupMapList groupMaps = new CampaignUserGroupMapList();
            groupMaps.setElements(groups);
            context.getRequest().setAttribute("userGroupMaps", (Object)groupMaps.createMapOfElements());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListGroupsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "campaign-dashboard-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String campaignId = context.getRequest().getParameter("id");
        if (campaignId == null || "".equals(campaignId.trim())) {
            campaignId = (String)context.getRequest().getAttribute("id");
        }
        String userGroupId = context.getRequest().getParameter("userGroupId");
        try {
            db = this.getConnection(context);
            Campaign campaign = new Campaign();
            campaign.queryRecord(db, Integer.parseInt(campaignId));
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            CampaignUserGroupMap map = new CampaignUserGroupMap(db, Integer.parseInt(campaignId), Integer.parseInt(userGroupId));
            map.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandViewActive(context);
    }
}

